/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.componentfactory.schedulexcalendar.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public final class DateTimeFormatUtils {
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    public static final DateTimeFormatter COMPACT_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static final DateTimeFormatter COMPACT_TIME_FORMATTER = DateTimeFormatter.ofPattern("HHmmss");

    public static LocalDateTime parseDate(String date, boolean end) {
        LocalDateTime result;
        block2: {
            try {
                result = LocalDateTime.parse(date, DATE_TIME_FORMATTER);
            }
            catch (Exception e) {
                result = LocalDate.parse(date, DATE_FORMATTER).atStartOfDay();
                if (!end) break block2;
                result = result.withHour(23).withMinute(59).withSecond(59);
            }
        }
        return result;
    }

    public static String formatZonedDateTime(String date) {
        try {
            ZonedDateTime zdt = ZonedDateTime.parse(date, DateTimeFormatter.ISO_ZONED_DATE_TIME);
            return zdt.format(DATE_TIME_FORMATTER);
        }
        catch (Exception e) {
            LocalDate ld = LocalDate.parse(date, DateTimeFormatter.ISO_DATE);
            return ld.format(DATE_FORMATTER);
        }
    }
}

