/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.componentfactory.schedulexcalendar.model;

import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.vaadin.addons.componentfactory.schedulexcalendar.model.Calendar;

public class Resource
implements Serializable {
    private String label;
    private String labelHtml;
    private String id;
    private String colorName;
    private Calendar.ColorDefinition lightColors;
    private Calendar.ColorDefinition darkColors;
    private List<Resource> resources = new ArrayList<Resource>();
    private boolean isOpen = true;

    public Resource(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabelHtml() {
        return this.labelHtml;
    }

    public void setLabelHtml(String labelHtml) {
        this.labelHtml = labelHtml;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getColorName() {
        return this.colorName;
    }

    public void setColorName(String colorName) {
        this.colorName = colorName;
    }

    public Calendar.ColorDefinition getLightColors() {
        return this.lightColors;
    }

    public void setLightColors(Calendar.ColorDefinition lightColors) {
        this.lightColors = lightColors;
    }

    public Calendar.ColorDefinition getDarkColors() {
        return this.darkColors;
    }

    public void setDarkColors(Calendar.ColorDefinition darkColors) {
        this.darkColors = darkColors;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        return Objects.equals(this.id, other.id);
    }

    public String getJson() {
        JsonObject js = Json.createObject();
        js.put("id", this.id);
        Optional.ofNullable(this.label).ifPresent(value -> js.put("label", value));
        Optional.ofNullable(this.labelHtml).ifPresent(value -> js.put("labelHTML", value));
        Optional.ofNullable(this.colorName).ifPresent(value -> js.put("colorName", value));
        Optional.ofNullable(this.lightColors).ifPresent(colors -> js.put("lightColors", (JsonValue)colors.toJsonObject()));
        Optional.ofNullable(this.darkColors).ifPresent(colors -> js.put("darkColors", (JsonValue)colors.toJsonObject()));
        if (this.resources != null && !this.resources.isEmpty()) {
            JsonArray resArray = Json.createArray();
            for (int i = 0; i < this.resources.size(); ++i) {
                resArray.set(i, (JsonValue)Json.parse((String)this.resources.get(i).getJson()));
            }
            js.put("resources", (JsonValue)resArray);
        }
        js.put("isOpen", this.isOpen);
        return js.toJson();
    }
}

