/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.componentfactory.schedulexcalendar.model;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import org.vaadin.addons.componentfactory.schedulexcalendar.util.DateTimeFormatUtils;

public class RecurrenceRule
implements Serializable {
    private Frequency freq;
    private Integer count;
    private Integer interval;
    private List<Day> byDay;
    private List<Integer> byMonthDay;
    private Until until;
    private Day wkst;

    public RecurrenceRule(Frequency freq) {
        this.freq = freq;
    }

    public Frequency getFreq() {
        return this.freq;
    }

    public void setFreq(Frequency freq) {
        this.freq = freq;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public List<Day> getByDay() {
        return this.byDay;
    }

    public void setByDay(List<Day> byDay) {
        this.byDay = byDay;
    }

    public List<Integer> getByMonthDay() {
        return this.byMonthDay;
    }

    public void setByMonthDay(List<Integer> byMonthDay) {
        this.byMonthDay = byMonthDay;
    }

    public Until getUntil() {
        return this.until;
    }

    public void setUntil(Until until) {
        this.until = until;
    }

    public Day getWkst() {
        return this.wkst;
    }

    public void setWkst(Day wkst) {
        this.wkst = wkst;
    }

    protected String getRule() {
        StringBuilder sb = new StringBuilder("FREQ=" + this.getFreq());
        if (this.getCount() != null) {
            sb.append(";COUNT=").append(this.getCount());
        }
        if (this.getInterval() != null) {
            sb.append(";INTERVAL=").append(this.getInterval());
        }
        if (this.getByDay() != null && !this.getByDay().isEmpty()) {
            String byDay = this.getByDay().stream().map(Enum::name).collect(Collectors.joining(","));
            sb.append(";BYDAY=").append(byDay);
        }
        if (this.getByMonthDay() != null && !this.getByMonthDay().isEmpty()) {
            String byMonthDay = this.getByMonthDay().stream().map(String::valueOf).collect(Collectors.joining(","));
            sb.append(";BYMONTHDAY=").append(byMonthDay);
        }
        if (this.getUntil() != null) {
            sb.append(";UNTIL=").append(this.getUntil().format());
        }
        if (this.getWkst() != null) {
            sb.append(";WKST=").append((Object)this.getWkst());
        }
        return sb.toString();
    }

    public static enum Frequency {
        DAILY,
        WEEKLY,
        MONTHLY,
        YEARLY;

    }

    public static class Until
    implements Serializable {
        private final LocalDate date;
        private final LocalTime time;

        public Until(LocalDate date) {
            this.date = date;
            this.time = null;
        }

        public Until(LocalDate date, LocalTime time) {
            this.date = date;
            this.time = time;
        }

        public LocalDate getDate() {
            return this.date;
        }

        public LocalTime getTime() {
            return this.time;
        }

        public String format() {
            DateTimeFormatter dateFmt = DateTimeFormatUtils.COMPACT_DATE_FORMATTER;
            if (this.time == null) {
                return this.date.format(dateFmt);
            }
            DateTimeFormatter timeFmt = DateTimeFormatUtils.COMPACT_TIME_FORMATTER;
            return this.date.format(dateFmt) + "T" + this.time.format(timeFmt);
        }
    }

    public static enum Day {
        MO,
        TU,
        WE,
        TH,
        FR,
        SA,
        SU;

    }
}

