/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.componentfactory.schedulexcalendar;

import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.vaadin.addons.componentfactory.schedulexcalendar.BaseConfiguration;
import org.vaadin.addons.componentfactory.schedulexcalendar.BaseConfigurationSection;
import org.vaadin.addons.componentfactory.schedulexcalendar.util.DateTimeFormatUtils;
import org.vaadin.addons.componentfactory.schedulexcalendar.util.LocaleUtils;
import org.vaadin.addons.componentfactory.schedulexcalendar.util.TimeInterval;
import org.vaadin.addons.componentfactory.schedulexcalendar.util.ViewType;

public class Configuration
extends BaseConfiguration
implements Serializable {
    private ViewType defaultView;
    private LocalDate selectedDate;
    private Locale locale;
    private Integer firstDayOfWeek;
    private ZoneId timeZone;
    private boolean isDark = false;
    private DayBoundaries dayBoundaries;
    private LocalDate minDate;
    private LocalDate maxDate;
    private WeekOptions weekOptions;
    private MonthGridOptions monthGridOptions;
    private DrawOptions drawOptions;
    private ICal iCal;
    private boolean showWeekNumbers = false;
    private boolean isResponsive = true;
    private boolean skipValidation = true;
    private TimeInterval resizeInterval;
    private TimeInterval dragAndDropInterval;
    private CurrentTimeIndicatorConfig currentTimeIndicatorConfig;
    private ScrollControllerConfig scrollControllerConfig;

    public ViewType getDefaultView() {
        return this.defaultView;
    }

    public void setDefaultView(ViewType defaultView) {
        this.defaultView = defaultView;
        this.runRefresh();
    }

    public LocalDate getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedDate(LocalDate selectedDate) {
        if (this.getCalendar() != null) {
            this.getCalendar().updateDate(selectedDate);
        }
        this.selectedDate = selectedDate;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        LocaleUtils.validateLocale(locale);
        if (this.getCalendar() != null) {
            this.getCalendar().updateLocale(locale);
        }
        this.locale = locale;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(ZoneId timeZone) {
        if (this.getCalendar() != null) {
            this.getCalendar().updateTimeZone(timeZone);
        }
        this.timeZone = timeZone;
    }

    public Integer getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setFirstDayOfWeek(Integer firstDayOfWeek) {
        if (this.getCalendar() != null) {
            this.getCalendar().updateFirstDayOfWeek(firstDayOfWeek);
        }
        this.firstDayOfWeek = firstDayOfWeek;
    }

    public boolean isDark() {
        return this.isDark;
    }

    public void setDark(boolean isDark) {
        if (this.getCalendar() != null) {
            this.getCalendar().setDarkMode(isDark);
        }
        this.isDark = isDark;
    }

    public DayBoundaries getDayBoundaries() {
        return this.dayBoundaries;
    }

    public void setDayBoundaries(DayBoundaries dayBoundaries) {
        if (dayBoundaries != null) {
            dayBoundaries.setConfiguration(this);
        }
        if (this.getCalendar() != null) {
            this.getCalendar().updateDayBoundaries(dayBoundaries);
        }
        this.dayBoundaries = dayBoundaries;
    }

    public LocalDate getMinDate() {
        return this.minDate;
    }

    public void setMinDate(LocalDate minDate) {
        if (this.getCalendar() != null) {
            this.getCalendar().updateMinDate(minDate);
        }
        this.minDate = minDate;
    }

    public LocalDate getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(LocalDate maxDate) {
        if (this.getCalendar() != null) {
            this.getCalendar().updateMaxDate(maxDate);
        }
        this.maxDate = maxDate;
    }

    public WeekOptions getWeekOptions() {
        return this.weekOptions;
    }

    public void setWeekOptions(WeekOptions weekOptions) {
        if (weekOptions != null) {
            weekOptions.setConfiguration(this);
        }
        if (this.getCalendar() != null) {
            this.getCalendar().updateWeekOptions(weekOptions);
        }
        this.weekOptions = weekOptions;
    }

    public MonthGridOptions getMonthGridOptions() {
        return this.monthGridOptions;
    }

    public void setMonthGridOptions(MonthGridOptions monthGridOptions) {
        if (monthGridOptions != null) {
            monthGridOptions.setConfiguration(this);
        }
        if (this.getCalendar() != null) {
            this.getCalendar().updateMonthGridOptions(monthGridOptions);
        }
        this.monthGridOptions = monthGridOptions;
    }

    public DrawOptions getDrawOptions() {
        return this.drawOptions;
    }

    public void setDrawOptions(DrawOptions drawOptions) {
        this.drawOptions = drawOptions;
        if (this.drawOptions != null) {
            this.drawOptions.setConfiguration(this);
        }
        this.runRefresh();
    }

    public ICal getiCal() {
        return this.iCal;
    }

    public void setiCal(ICal iCal) {
        this.iCal = iCal;
        this.runRefresh();
    }

    public boolean isShowWeekNumbers() {
        return this.showWeekNumbers;
    }

    public void setShowWeekNumbers(boolean showWeekNumbers) {
        this.showWeekNumbers = showWeekNumbers;
        this.runRefresh();
    }

    public boolean isResponsive() {
        return this.isResponsive;
    }

    public void setResponsive(boolean isResponsive) {
        this.isResponsive = isResponsive;
        this.runRefresh();
    }

    public boolean isSkipValidation() {
        return this.skipValidation;
    }

    public void setSkipValidation(boolean skipValidation) {
        this.skipValidation = skipValidation;
        this.runRefresh();
    }

    public TimeInterval getResizeInterval() {
        return this.resizeInterval;
    }

    public void setResizeInterval(TimeInterval resizeInterval) {
        this.resizeInterval = resizeInterval;
        this.runRefresh();
    }

    public TimeInterval getDragAndDropInterval() {
        return this.dragAndDropInterval;
    }

    public void setDragAndDropInterval(TimeInterval dragAndDropInterval) {
        this.dragAndDropInterval = dragAndDropInterval;
        this.runRefresh();
    }

    public CurrentTimeIndicatorConfig getCurrentTimeIndicatorConfig() {
        return this.currentTimeIndicatorConfig;
    }

    public void setCurrentTimeIndicatorConfig(CurrentTimeIndicatorConfig currentTimeIndicatorConfig) {
        this.currentTimeIndicatorConfig = currentTimeIndicatorConfig;
        if (this.currentTimeIndicatorConfig != null) {
            this.currentTimeIndicatorConfig.setConfiguration(this);
        }
        this.runRefresh();
    }

    public ScrollControllerConfig getScrollControllerConfig() {
        return this.scrollControllerConfig;
    }

    public void setScrollControllerConfig(ScrollControllerConfig scrollControllerConfig) {
        this.scrollControllerConfig = scrollControllerConfig;
        if (this.scrollControllerConfig != null) {
            this.scrollControllerConfig.setConfiguration(this);
        }
        this.runRefresh();
    }

    public String getJson() {
        JsonObject js = Json.createObject();
        Optional.ofNullable(this.defaultView).ifPresent(value -> js.put("defaultView", value.getName()));
        Optional.ofNullable(this.selectedDate).ifPresent(value -> js.put("selectedDate", value.format(DateTimeFormatUtils.DATE_FORMATTER)));
        Optional.ofNullable(this.locale).ifPresent(value -> js.put("locale", LocaleUtils.toScheduleXLocale(value)));
        Optional.ofNullable(this.timeZone).ifPresent(value -> js.put("timezone", this.timeZone.getId()));
        Optional.ofNullable(this.firstDayOfWeek).ifPresent(value -> js.put("firstDayOfWeek", (double)value.intValue()));
        js.put("isDark", this.isDark);
        Optional.ofNullable(this.dayBoundaries).ifPresent(value -> js.put("dayBoundaries", (JsonValue)value.toJson()));
        Optional.ofNullable(this.minDate).ifPresent(value -> js.put("minDate", value.format(DateTimeFormatUtils.DATE_FORMATTER)));
        Optional.ofNullable(this.maxDate).ifPresent(value -> js.put("maxDate", value.format(DateTimeFormatUtils.DATE_FORMATTER)));
        Optional.ofNullable(this.weekOptions).ifPresent(value -> js.put("weekOptions", (JsonValue)value.toJson()));
        Optional.ofNullable(this.drawOptions).ifPresent(value -> js.put("drawOptions", (JsonValue)value.toJson()));
        Optional.ofNullable(this.iCal).ifPresent(value -> js.put("iCal", (JsonValue)value.toJson()));
        Optional.ofNullable(this.monthGridOptions).ifPresent(value -> js.put("monthGridOptions", (JsonValue)value.toJson()));
        js.put("showWeekNumbers", this.showWeekNumbers);
        js.put("isResponsive", this.isResponsive);
        js.put("skipValidation", this.skipValidation);
        Optional.ofNullable(this.resizeInterval).ifPresent(value -> js.put("resizeInterval", (double)value.getInterval()));
        Optional.ofNullable(this.dragAndDropInterval).ifPresent(value -> js.put("dragAndDropInterval", (double)value.getInterval()));
        Optional.ofNullable(this.currentTimeIndicatorConfig).ifPresent(value -> js.put("currentTimeIndicatorConfig", (JsonValue)value.toJson()));
        Optional.ofNullable(this.scrollControllerConfig).ifPresent(value -> js.put("scrollControllerConfig", (JsonValue)value.toJson()));
        return js.toJson();
    }

    public static class DayBoundaries
    extends BaseConfigurationSection
    implements Serializable {
        private LocalTime start;
        private LocalTime end;

        public LocalTime getStart() {
            return this.start;
        }

        public void setStart(LocalTime start) {
            this.start = start;
            this.updateDayBoundaries();
        }

        public LocalTime getEnd() {
            return this.end;
        }

        public void setEnd(LocalTime end) {
            this.end = end;
            this.updateDayBoundaries();
        }

        private void updateDayBoundaries() {
            if (this.getConfiguration() != null) {
                ((Configuration)this.getConfiguration()).setDayBoundaries(this);
            }
        }

        public JsonObject toJson() {
            JsonObject js = Json.createObject();
            Optional.ofNullable(this.start).ifPresent(value -> js.put("start", value.format(DateTimeFormatUtils.TIME_FORMATTER)));
            Optional.ofNullable(this.end).ifPresent(value -> js.put("end", value.format(DateTimeFormatUtils.TIME_FORMATTER)));
            return js;
        }
    }

    public static class WeekOptions
    extends BaseConfigurationSection
    implements Serializable {
        private Integer gridHeight;
        private Integer nDays;
        private Integer eventWidth;
        private Map<String, String> timeAxisFormatOptions;
        private boolean eventOverlap = true;

        public Integer getGridHeight() {
            return this.gridHeight;
        }

        public void setGridHeight(Integer gridHeight) {
            this.gridHeight = gridHeight;
            this.updateWeekOptions();
        }

        public Integer getnDays() {
            return this.nDays;
        }

        public void setnDays(Integer nDays) {
            this.nDays = nDays;
            this.updateWeekOptions();
        }

        public Integer getEventWidth() {
            return this.eventWidth;
        }

        public void setEventWidth(Integer eventWidth) {
            this.eventWidth = eventWidth;
            this.updateWeekOptions();
        }

        public Map<String, String> getTimeAxisFormatOptions() {
            return this.timeAxisFormatOptions;
        }

        public void setTimeAxisFormatOptions(Map<String, String> timeAxisFormatOptions) {
            this.timeAxisFormatOptions = timeAxisFormatOptions;
            this.updateWeekOptions();
        }

        public boolean isEventOverlap() {
            return this.eventOverlap;
        }

        public void setEventOverlap(boolean eventOverlap) {
            this.eventOverlap = eventOverlap;
            this.updateWeekOptions();
        }

        private void updateWeekOptions() {
            if (this.getConfiguration() != null) {
                ((Configuration)this.getConfiguration()).setWeekOptions(this);
            }
        }

        public JsonObject toJson() {
            JsonObject js = Json.createObject();
            Optional.ofNullable(this.gridHeight).ifPresent(value -> js.put("gridHeight", (double)value.intValue()));
            Optional.ofNullable(this.nDays).ifPresent(value -> js.put("nDays", (double)value.intValue()));
            Optional.ofNullable(this.eventWidth).ifPresent(value -> js.put("eventWidth", (double)value.intValue()));
            Optional.ofNullable(this.timeAxisFormatOptions).ifPresent(map -> {
                JsonObject opts = Json.createObject();
                map.forEach((arg_0, arg_1) -> ((JsonObject)opts).put(arg_0, arg_1));
                js.put("timeAxisFormatOptions", (JsonValue)opts);
            });
            js.put("eventOverlap", this.eventOverlap);
            return js;
        }
    }

    public static class MonthGridOptions
    extends BaseConfigurationSection
    implements Serializable {
        private Integer nEventsPerDay;

        public Integer getnEventsPerDay() {
            return this.nEventsPerDay;
        }

        public void setnEventsPerDay(Integer nEventsPerDay) {
            this.nEventsPerDay = nEventsPerDay;
            this.updateMonthGridOptions();
        }

        private void updateMonthGridOptions() {
            if (this.getConfiguration() != null) {
                ((Configuration)this.getConfiguration()).setMonthGridOptions(this);
            }
        }

        public JsonObject toJson() {
            JsonObject js = Json.createObject();
            Optional.ofNullable(this.nEventsPerDay).ifPresent(value -> js.put("nEventsPerDay", (double)value.intValue()));
            return js;
        }
    }

    public static class DrawOptions
    extends BaseConfigurationSection
    implements Serializable {
        private TimeInterval snapDrawDuration;
        private String defaultTitle;

        public TimeInterval getSnapDrawDuration() {
            return this.snapDrawDuration;
        }

        public void setSnapDrawDuration(TimeInterval snapDrawDuration) {
            this.snapDrawDuration = snapDrawDuration;
            this.runRefresh();
        }

        public String getDefaultTitle() {
            return this.defaultTitle;
        }

        public void setDefaultTitle(String defaultTitle) {
            this.defaultTitle = defaultTitle;
            this.runRefresh();
        }

        public JsonObject toJson() {
            JsonObject js = Json.createObject();
            Optional.ofNullable(this.snapDrawDuration).ifPresent(value -> js.put("snapDrawDuration", (double)value.getInterval()));
            Optional.ofNullable(this.defaultTitle).ifPresent(value -> js.put("defaultTitle", value));
            return js;
        }
    }

    public static class ICal
    implements Serializable {
        private String iCal;

        public String getiCal() {
            return this.iCal;
        }

        public void setiCal(String iCal) {
            this.iCal = iCal;
        }

        public JsonObject toJson() {
            JsonObject js = Json.createObject();
            Optional.ofNullable(this.iCal).ifPresent(value -> js.put("iCal", value));
            return js;
        }
    }

    public static class CurrentTimeIndicatorConfig
    extends BaseConfigurationSection
    implements Serializable {
        private Boolean fullWeekWidth;
        private Integer timeZoneOffset;

        public Boolean getFullWeekWidth() {
            return this.fullWeekWidth;
        }

        public void setFullWeekWidth(Boolean fullWeekWidth) {
            this.fullWeekWidth = fullWeekWidth;
            this.runRefresh();
        }

        public Integer getTimeZoneOffset() {
            return this.timeZoneOffset;
        }

        public void setTimeZoneOffset(Integer timeZoneOffset) {
            this.timeZoneOffset = timeZoneOffset;
            this.runRefresh();
        }

        public JsonObject toJson() {
            JsonObject js = Json.createObject();
            Optional.ofNullable(this.fullWeekWidth).ifPresent(value -> js.put("fullWeekWidth", value.booleanValue()));
            Optional.ofNullable(this.timeZoneOffset).ifPresent(value -> js.put("timeZoneOffset", (double)value.intValue()));
            return js;
        }
    }

    public static class ScrollControllerConfig
    extends BaseConfigurationSection
    implements Serializable {
        private LocalTime initialScroll;

        public LocalTime getInitialScroll() {
            return this.initialScroll;
        }

        public void setInitialScroll(LocalTime initialScroll) {
            this.initialScroll = initialScroll;
            this.runRefresh();
        }

        public JsonObject toJson() {
            JsonObject js = Json.createObject();
            Optional.ofNullable(this.initialScroll).ifPresent(value -> js.put("initialScroll", value.format(DateTimeFormatUtils.TIME_FORMATTER)));
            return js;
        }
    }
}

