/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.componentfactory.schedulexcalendar;

import com.vaadin.flow.internal.Pair;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.vaadin.addons.componentfactory.schedulexcalendar.BaseConfiguration;
import org.vaadin.addons.componentfactory.schedulexcalendar.model.Resource;
import org.vaadin.addons.componentfactory.schedulexcalendar.util.DateTimeFormatUtils;
import org.vaadin.addons.componentfactory.schedulexcalendar.util.DayNameFormat;

public class ResourceSchedulerConfig
extends BaseConfiguration
implements Serializable {
    private Integer hourWidth;
    private Integer dayWidth;
    private List<Resource> resources = new ArrayList<Resource>();
    private Integer resourceHeight;
    private Integer eventHeight;
    private boolean dragAndDrop;
    private boolean resize;
    private boolean infiniteScroll;
    private Pair<LocalDateTime, LocalDateTime> initialHours;
    private Pair<LocalDate, LocalDate> initialDays;
    private Boolean highlightToday;
    private DayNameFormat dayNameFormat;

    public Integer getHourWidth() {
        return this.hourWidth;
    }

    public void setHourWidth(Integer hourWidth) {
        this.hourWidth = hourWidth;
        this.runRefresh();
    }

    public Integer getDayWidth() {
        return this.dayWidth;
    }

    public void setDayWidth(Integer dayWidth) {
        this.dayWidth = dayWidth;
        this.runRefresh();
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
        this.runRefresh();
    }

    public Integer getResourceHeight() {
        return this.resourceHeight;
    }

    public void setResourceHeight(Integer resourceHeight) {
        this.resourceHeight = resourceHeight;
        this.runRefresh();
    }

    public Integer getEventHeight() {
        return this.eventHeight;
    }

    public void setEventHeight(Integer eventHeight) {
        this.eventHeight = eventHeight;
        this.runRefresh();
    }

    public boolean isDragAndDrop() {
        return this.dragAndDrop;
    }

    public void setDragAndDrop(boolean dragAndDrop) {
        this.dragAndDrop = dragAndDrop;
        this.runRefresh();
    }

    public boolean isResize() {
        return this.resize;
    }

    public void setResize(boolean resize) {
        this.resize = resize;
        this.runRefresh();
    }

    public boolean isInfiniteScroll() {
        return this.infiniteScroll;
    }

    public void setInfiniteScroll(boolean infiniteScroll) {
        this.infiniteScroll = infiniteScroll;
        this.runRefresh();
    }

    public Pair<LocalDateTime, LocalDateTime> getInitialHours() {
        return this.initialHours;
    }

    public void setInitialHours(Pair<LocalDateTime, LocalDateTime> initialHours) {
        this.initialHours = initialHours;
        this.runRefresh();
    }

    public Pair<LocalDate, LocalDate> getInitialDays() {
        return this.initialDays;
    }

    public void setInitialDays(Pair<LocalDate, LocalDate> initialDays) {
        this.initialDays = initialDays;
        this.runRefresh();
    }

    public Boolean getHighlightToday() {
        return this.highlightToday;
    }

    public void setHighlightToday(Boolean highlightToday) {
        this.highlightToday = highlightToday;
        this.runRefresh();
    }

    public String getDayNameFormat() {
        return this.dayNameFormat != null ? this.dayNameFormat.getValue() : null;
    }

    public void setDayNameFormat(DayNameFormat dayNameFormat) {
        this.dayNameFormat = dayNameFormat;
        this.runRefresh();
    }

    public String getJson() {
        JsonObject js = Json.createObject();
        Optional.ofNullable(this.hourWidth).ifPresent(value -> js.put("hourWidth", (double)value.intValue()));
        Optional.ofNullable(this.dayWidth).ifPresent(value -> js.put("dayWidth", (double)value.intValue()));
        Optional.ofNullable(this.resourceHeight).ifPresent(value -> js.put("resourceHeight", (double)value.intValue()));
        Optional.ofNullable(this.eventHeight).ifPresent(value -> js.put("eventHeight", (double)value.intValue()));
        js.put("dragAndDrop", this.dragAndDrop);
        js.put("resize", this.resize);
        js.put("infiniteScroll", this.infiniteScroll);
        if (this.resources != null && !this.resources.isEmpty()) {
            JsonArray resArray = Json.createArray();
            for (int i = 0; i < this.resources.size(); ++i) {
                resArray.set(i, (JsonValue)Json.parse((String)this.resources.get(i).getJson()));
            }
            js.put("resources", (JsonValue)resArray);
        }
        if (this.initialHours != null) {
            js.put("initialHours", ((LocalDateTime)this.initialHours.getFirst()).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + "," + ((LocalDateTime)this.initialHours.getSecond()).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        }
        if (this.initialDays != null) {
            js.put("initialDays", ((LocalDate)this.initialDays.getFirst()).format(DateTimeFormatUtils.DATE_FORMATTER) + "," + ((LocalDate)this.initialDays.getSecond()).format(DateTimeFormatUtils.DATE_FORMATTER));
        }
        Optional.ofNullable(this.highlightToday).ifPresent(value -> js.put("highlightToday", value.booleanValue()));
        if (this.dayNameFormat != null) {
            js.put("dayNameFormat", this.dayNameFormat.getValue());
        } else {
            js.put("dayNameFormat", false);
        }
        return js.toJson();
    }
}

