/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.componentfactory.schedulexcalendar;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.vaadin.addons.componentfactory.schedulexcalendar.Configuration;
import org.vaadin.addons.componentfactory.schedulexcalendar.model.Calendar;
import org.vaadin.addons.componentfactory.schedulexcalendar.model.Event;
import org.vaadin.addons.componentfactory.schedulexcalendar.model.EventQueryFilter;
import org.vaadin.addons.componentfactory.schedulexcalendar.util.CalendarViewType;
import org.vaadin.addons.componentfactory.schedulexcalendar.util.DateTimeFormatUtils;
import org.vaadin.addons.componentfactory.schedulexcalendar.util.LocaleUtils;
import org.vaadin.addons.componentfactory.schedulexcalendar.util.ResourceViewType;
import org.vaadin.addons.componentfactory.schedulexcalendar.util.ViewType;

@NpmPackage.Container(value={@NpmPackage(value="temporal-polyfill", version="0.3.0"), @NpmPackage(value="@schedule-x/calendar", version="3.5.1"), @NpmPackage(value="@schedule-x/theme-default", version="3.5.1"), @NpmPackage(value="@schedule-x/resize", version="3.5.1"), @NpmPackage(value="@schedule-x/drag-and-drop", version="3.5.1"), @NpmPackage(value="@schedule-x/current-time", version="3.5.1"), @NpmPackage(value="@schedule-x/scroll-controller", version="3.5.1"), @NpmPackage(value="@schedule-x/calendar-controls", version="3.5.1"), @NpmPackage(value="@schedule-x/event-recurrence", version="3.5.1"), @NpmPackage(value="@schedule-x/ical", version="3.5.1")})
@CssImport.Container(value={@CssImport(value="@schedule-x/theme-default/dist/index.css"), @CssImport(value="./styles/vcf-schedule-x-calendar-styles.css")})
public abstract class BaseScheduleXCalendar
extends Div {
    private boolean calendarRendered;
    private List<? extends ViewType> views = new ArrayList<ViewType>();
    private Map<String, Calendar> calendars = new HashMap<String, Calendar>();
    private CallbackDataProvider<Event, EventQueryFilter> dataProvider;
    private ViewType view;
    private Configuration configuration;
    protected Div container;
    private Registration refreshRegistration;

    public BaseScheduleXCalendar(List<? extends ViewType> views, CallbackDataProvider<Event, EventQueryFilter> dataProvider, Configuration configuration) {
        this.initCalendarContainer();
        this.add(new Component[]{this.container});
        this.views = new ArrayList<ViewType>(views);
        this.dataProvider = dataProvider;
        this.configuration = configuration;
        this.configuration.setCalendar(this);
    }

    public BaseScheduleXCalendar(List<? extends ViewType> views, CallbackDataProvider<Event, EventQueryFilter> dataProvider, Configuration configuration, Map<String, Calendar> calendars) {
        this(views, dataProvider, configuration);
        this.calendars = calendars;
    }

    private void initCalendarContainer() {
        this.container = new Div();
        this.container.setId("calendar-container-" + String.valueOf(((Object)((Object)this)).hashCode()));
        this.container.setClassName("vcf-schedule-x-calendar");
        this.container.setSizeFull();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.initCalendar(false);
        this.addCalendarRenderedListener((SerializableRunnable & Serializable)() -> {});
    }

    protected abstract void initCalendar(boolean var1);

    private void requireRefresh() {
        this.getUI().ifPresent(ui -> {
            if (this.refreshRegistration != null) {
                this.refreshRegistration.remove();
            }
            if (this.isAttached()) {
                this.refreshRegistration = ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> this.initCalendar(this.view != null && this.view != this.configuration.getDefaultView()));
            }
        });
    }

    public void refreshCalendar() {
        this.getElement().executeJs("return", new Serializable[0]).then((SerializableConsumer & Serializable)e -> {
            if (this.calendarRendered) {
                this.calendarRendered = false;
                this.remove(new Component[]{this.container});
                this.initCalendarContainer();
                this.add(new Component[]{this.container});
                this.requireRefresh();
            }
        });
    }

    protected String viewsToJson() {
        JsonArray jsonArray = Json.createArray();
        for (int i = 0; i < this.views.size(); ++i) {
            jsonArray.set(i, this.views.get(i).getName());
        }
        return jsonArray.toJson();
    }

    protected String eventsToJson(LocalDateTime start, LocalDateTime end) {
        List events = this.dataProvider.fetch(new Query(0, Integer.MAX_VALUE, null, null, (Object)new EventQueryFilter(start, end))).toList();
        return events != null ? String.format("[%s]", events.stream().map(event -> event.getJson()).collect(Collectors.joining(","))) : "";
    }

    protected String configurationToJson() {
        return this.configuration != null ? this.configuration.getJson() : "{}";
    }

    protected String calendarsToJson() {
        if (this.calendars == null || this.calendars.isEmpty()) {
            return "{}";
        }
        JsonObject calendarJson = Json.createObject();
        this.calendars.forEach((id, calendar) -> calendarJson.put(id, (JsonValue)calendar.toJsonObject()));
        return calendarJson.toJson();
    }

    public CallbackDataProvider<Event, EventQueryFilter> getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(CallbackDataProvider<Event, EventQueryFilter> dataProvider) {
        this.dataProvider = dataProvider;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.getElement().removeAllChildren();
    }

    @ClientCallable
    void updateRange(String start, String end) {
        LocalDateTime startDate = LocalDateTime.parse(start, DateTimeFormatter.ISO_DATE_TIME);
        LocalDateTime endDate = LocalDateTime.parse(end, DateTimeFormatter.ISO_DATE_TIME);
        String events = this.eventsToJson(startDate, endDate);
        this.updateRange(events, start, end);
    }

    void updateRange(String events, String start, String end) {
        this.container.getElement().executeJs(this.getJsConnector() + ".onUpdateRange($0, $1, $2, $3);", new Serializable[]{this.container, events, start, end});
    }

    @ClientCallable
    void updateResourceSchedulerRange(String start, String end) {
        LocalDateTime startDate = LocalDateTime.parse(start, DateTimeFormatter.ISO_DATE_TIME);
        LocalDateTime endDate = LocalDateTime.parse(end, DateTimeFormatter.ISO_DATE_TIME);
        String events = this.eventsToJson(startDate, endDate);
        this.updateRange(events, start, end);
    }

    protected abstract String getJsConnector();

    public void setView(ViewType view) {
        this.executeOnCalendarRendered((SerializableRunnable & Serializable)() -> {
            this.getElement().executeJs(this.getJsConnector() + ".setView($0, $1);", new Serializable[]{this.container, view.getName()});
            this.view = view;
        });
    }

    public ViewType getView() {
        return this.view != null ? this.view : (this.configuration.getDefaultView() != null ? this.configuration.getDefaultView() : this.getViews().get(0));
    }

    public void setDate(LocalDate selectedDate) {
        this.configuration.setSelectedDate(selectedDate);
    }

    protected void updateDate(LocalDate selectedDate) {
        this.executeOnCalendarRendered((SerializableRunnable & Serializable)() -> this.getElement().executeJs(this.getJsConnector() + ".setDate($0, $1);", new Serializable[]{this.container, selectedDate.format(DateTimeFormatUtils.DATE_FORMATTER)}));
    }

    public LocalDate getDate() {
        return this.configuration.getSelectedDate();
    }

    public void setFirstDayOfWeek(Integer firstDayOfWeek) {
        this.configuration.setFirstDayOfWeek(firstDayOfWeek);
    }

    protected void updateFirstDayOfWeek(Integer firstDayOfWeek) {
        this.executeOnCalendarRendered((SerializableRunnable & Serializable)() -> this.getElement().executeJs(this.getJsConnector() + ".setFirstDayOfWeek($0, $1);", new Serializable[]{this.container, firstDayOfWeek}));
    }

    public Integer getFirstDayOfWeek() {
        return this.configuration.getFirstDayOfWeek();
    }

    public void setLocale(Locale locale) {
        this.configuration.setLocale(locale);
    }

    protected void updateLocale(Locale locale) {
        this.executeOnCalendarRendered((SerializableRunnable & Serializable)() -> this.getElement().executeJs(this.getJsConnector() + ".setLocale($0, $1);", new Serializable[]{this.container, LocaleUtils.toScheduleXLocale(locale)}));
    }

    public Locale getLocale() {
        return this.configuration.getLocale();
    }

    public void setTimeZone(ZoneId timeZone) {
        this.configuration.setTimeZone(timeZone);
    }

    protected void updateTimeZone(ZoneId timeZone) {
        this.executeOnCalendarRendered((SerializableRunnable & Serializable)() -> this.getElement().executeJs(this.getJsConnector() + ".setTimeZone($0, $1);", new Serializable[]{this.container, timeZone}));
    }

    public ZoneId getTimeZone() {
        return this.configuration.getTimeZone();
    }

    public void setViews(List<? extends ViewType> views) {
        this.executeOnCalendarRendered((SerializableRunnable & Serializable)() -> {
            this.getElement().executeJs(this.getJsConnector() + ".setViews($0, $1);", new Serializable[]{this.container, this.viewsToJson()});
            this.views = new ArrayList<ViewType>(views);
        });
    }

    public List<? extends ViewType> getViews() {
        return this.views;
    }

    public void setDayBoundaries(Configuration.DayBoundaries dayBoundaries) {
        this.configuration.setDayBoundaries(dayBoundaries);
    }

    protected void updateDayBoundaries(Configuration.DayBoundaries dayBoundaries) {
        this.executeOnCalendarRendered((SerializableRunnable & Serializable)() -> this.getElement().executeJs(this.getJsConnector() + ".setDayBoundaries($0, $1);", new Serializable[]{this.container, dayBoundaries.toJson()}));
    }

    public Configuration.DayBoundaries getDayBoundaries() {
        return this.configuration.getDayBoundaries();
    }

    public void setWeekOptions(Configuration.WeekOptions weekOptions) {
        this.configuration.setWeekOptions(weekOptions);
    }

    protected void updateWeekOptions(Configuration.WeekOptions weekOptions) {
        this.executeOnCalendarRendered((SerializableRunnable & Serializable)() -> this.getElement().executeJs(this.getJsConnector() + ".setWeekOptions($0, $1);", new Serializable[]{this.container, weekOptions.toJson()}));
    }

    public Configuration.WeekOptions getWeekOptions() {
        return this.configuration.getWeekOptions();
    }

    public void setCalendars(Map<String, Calendar> calendars) {
        this.executeOnCalendarRendered((SerializableRunnable & Serializable)() -> {
            this.getElement().executeJs(this.getJsConnector() + ".setCalendars($0, $1);", new Serializable[]{this.container, this.calendarsToJson()});
            this.calendars = calendars;
        });
    }

    public Map<String, Calendar> getCalendars() {
        return this.calendars;
    }

    public void setMinDate(LocalDate minDate) {
        this.configuration.setMaxDate(minDate);
    }

    protected void updateMinDate(LocalDate minDate) {
        this.executeOnCalendarRendered((SerializableRunnable & Serializable)() -> this.getElement().executeJs(this.getJsConnector() + ".setMinDate($0, $1);", new Serializable[]{this.container, minDate.format(DateTimeFormatUtils.DATE_FORMATTER)}));
    }

    public LocalDate getMinDate() {
        return this.configuration.getMinDate();
    }

    public void setMaxDate(LocalDate maxDate) {
        this.configuration.setMaxDate(maxDate);
    }

    protected void updateMaxDate(LocalDate maxDate) {
        this.executeOnCalendarRendered((SerializableRunnable & Serializable)() -> this.getElement().executeJs(this.getJsConnector() + ".setMaxDate($0, $1);", new Serializable[]{this.container, maxDate.format(DateTimeFormatUtils.DATE_FORMATTER)}));
    }

    public LocalDate getMaxDate() {
        return this.configuration.getMaxDate();
    }

    public void setMonthGridOptions(Configuration.MonthGridOptions monthGridOptions) {
        this.configuration.setMonthGridOptions(monthGridOptions);
    }

    protected void updateMonthGridOptions(Configuration.MonthGridOptions monthGridOptions) {
        this.executeOnCalendarRendered((SerializableRunnable & Serializable)() -> this.getElement().executeJs(this.getJsConnector() + ".setMonthGridOptions($0, $1);", new Serializable[]{this.container, monthGridOptions.toJson()}));
    }

    public Configuration.MonthGridOptions getMonthGridOptions() {
        return this.configuration.getMonthGridOptions();
    }

    private void executeOnCalendarRendered(SerializableRunnable runnable) {
        if (!this.calendarRendered) {
            this.addCalendarRenderedListener(runnable);
        } else {
            runnable.run();
        }
    }

    private void addCalendarRenderedListener(SerializableRunnable onRendered) {
        this.getElement().addEventListener("calendar-rendered", (DomEventListener & Serializable)ev -> {
            if (!this.calendarRendered) {
                this.calendarRendered = true;
                onRendered.run();
            }
        });
    }

    public void navigateForwards() {
        this.getElement().executeJs(this.getJsConnector() + ".navigateForwards($0)", new Serializable[]{this.container});
    }

    public void navigateBackwards() {
        this.getElement().executeJs(this.getJsConnector() + ".navigateBackwards($0)", new Serializable[]{this.container});
    }

    @ClientCallable
    private void onCalendarEventClick(String eventId, String start, String end) {
        String startFormatted = DateTimeFormatUtils.formatZonedDateTime(start);
        String endFormatted = DateTimeFormatUtils.formatZonedDateTime(end);
        ComponentUtil.fireEvent((Component)this, (ComponentEvent)new CalendarEventClickEvent(this, eventId, DateTimeFormatUtils.parseDate(startFormatted, false), DateTimeFormatUtils.parseDate(endFormatted, true), false));
    }

    public Registration addCalendarEventClickEventListener(ComponentEventListener<CalendarEventClickEvent> listener) {
        return this.addListener(CalendarEventClickEvent.class, listener);
    }

    @ClientCallable
    private void onSelectedDateUpdate(String selectedDate) {
        ComponentUtil.fireEvent((Component)this, (ComponentEvent)new SelectedDateUpdateEvent(this, LocalDate.parse(selectedDate), false));
    }

    public Registration addSelectedDateUpdateEventListener(ComponentEventListener<SelectedDateUpdateEvent> listener) {
        return this.addListener(SelectedDateUpdateEvent.class, listener);
    }

    public void addEvent(Event event) {
        this.executeOnCalendarRendered((SerializableRunnable & Serializable)() -> this.getElement().executeJs(this.getJsConnector() + ".addEvent($0, $1);", new Serializable[]{this.container, event.getJson()}));
    }

    public void removeEvent(String eventId) {
        this.getElement().executeJs(this.getJsConnector() + ".removeEvent($0, $1);", new Serializable[]{this.container, eventId});
    }

    public void updateEvent(Event event) {
        this.getElement().executeJs(this.getJsConnector() + ".updateEvent($0, $1);", new Serializable[]{this.container, event.getJson()});
    }

    public Registration addCalendarEventAddedEventListener(ComponentEventListener<CalendarEventAddedEvent> listener) {
        return this.addListener(CalendarEventAddedEvent.class, listener);
    }

    public Registration addCalendarEventRemovedEventListener(ComponentEventListener<CalendarEventRemovedEvent> listener) {
        return this.addListener(CalendarEventRemovedEvent.class, listener);
    }

    public Registration addCalendarEventUpdatedEventListener(ComponentEventListener<CalendarEventUpdatedEvent> listener) {
        return this.addListener(CalendarEventUpdatedEvent.class, listener);
    }

    @ClientCallable
    private void onEventUpdate(String eventId, String start, String end) {
        String startFormatted = DateTimeFormatUtils.formatZonedDateTime(start);
        String endFormatted = DateTimeFormatUtils.formatZonedDateTime(end);
        ComponentUtil.fireEvent((Component)this, (ComponentEvent)new EventUpdateEvent(this, eventId, LocalDateTime.parse(startFormatted, DateTimeFormatUtils.DATE_TIME_FORMATTER), LocalDateTime.parse(endFormatted, DateTimeFormatUtils.DATE_TIME_FORMATTER), false));
    }

    public Registration addEventUpdateEventListener(ComponentEventListener<EventUpdateEvent> listener) {
        return this.addListener(EventUpdateEvent.class, listener);
    }

    public void setDarkMode(boolean dark) {
        this.executeOnCalendarRendered((SerializableRunnable & Serializable)() -> this.container.getElement().executeJs("this.calendar.setTheme($0)", new Serializable[]{dark ? "dark" : "light"}));
    }

    public Registration addCalendarViewAndDateChangeEvent(ComponentEventListener<CalendarViewAndDateChangeEvent> listener) {
        return this.addListener(CalendarViewAndDateChangeEvent.class, listener);
    }

    private static ViewType parseViewType(String viewName) {
        return Optional.ofNullable(CalendarViewType.fromViewName(viewName)).map(ViewType.class::cast).orElseGet(() -> Optional.ofNullable(ResourceViewType.fromViewName(viewName)).map(ViewType.class::cast).orElseThrow(() -> new IllegalArgumentException("Unknown view type: " + viewName)));
    }

    public class CalendarEventClickEvent
    extends ComponentEvent<BaseScheduleXCalendar> {
        private final String eventId;
        private final LocalDateTime start;
        private final LocalDateTime end;

        public CalendarEventClickEvent(BaseScheduleXCalendar source, String eventId, LocalDateTime start, LocalDateTime end, boolean fromClient) {
            super((Component)source, fromClient);
            this.eventId = eventId;
            this.start = start;
            this.end = end;
        }

        public String getEventId() {
            return this.eventId;
        }

        public LocalDateTime getStart() {
            return this.start;
        }

        public LocalDateTime getEnd() {
            return this.end;
        }
    }

    public class SelectedDateUpdateEvent
    extends ComponentEvent<BaseScheduleXCalendar> {
        private final LocalDate selectedDate;

        public SelectedDateUpdateEvent(BaseScheduleXCalendar source, LocalDate selectedDate, boolean fromClient) {
            super((Component)source, fromClient);
            this.selectedDate = selectedDate;
        }

        public LocalDate getSelectedDate() {
            return this.selectedDate;
        }
    }

    @DomEvent(value="calendar-event-added")
    public static class CalendarEventAddedEvent
    extends ComponentEvent<BaseScheduleXCalendar> {
        private final String eventId;

        public CalendarEventAddedEvent(BaseScheduleXCalendar source, boolean fromClient, @EventData(value="event.detail.eventId") String eventId) {
            super((Component)source, fromClient);
            this.eventId = eventId;
        }

        public String getEventId() {
            return this.eventId;
        }
    }

    @DomEvent(value="calendar-event-removed")
    public static class CalendarEventRemovedEvent
    extends ComponentEvent<BaseScheduleXCalendar> {
        private final String eventId;

        public CalendarEventRemovedEvent(BaseScheduleXCalendar source, boolean fromClient, @EventData(value="event.detail.eventId") String eventId) {
            super((Component)source, fromClient);
            this.eventId = eventId;
        }

        public String getEventId() {
            return this.eventId;
        }
    }

    @DomEvent(value="calendar-event-updated")
    public static class CalendarEventUpdatedEvent
    extends ComponentEvent<BaseScheduleXCalendar> {
        private final String eventId;

        public CalendarEventUpdatedEvent(BaseScheduleXCalendar source, boolean fromClient, @EventData(value="event.detail.eventId") String eventId) {
            super((Component)source, fromClient);
            this.eventId = eventId;
        }

        public String getEventId() {
            return this.eventId;
        }
    }

    public class EventUpdateEvent
    extends ComponentEvent<BaseScheduleXCalendar> {
        private final String eventId;
        private final LocalDateTime startDate;
        private final LocalDateTime endDate;

        public EventUpdateEvent(BaseScheduleXCalendar source, String eventId, LocalDateTime startDate, LocalDateTime endDate, boolean fromClient) {
            super((Component)source, fromClient);
            this.eventId = eventId;
            this.startDate = startDate;
            this.endDate = endDate;
        }

        public String getEventId() {
            return this.eventId;
        }

        public LocalDateTime getStartDate() {
            return this.startDate;
        }

        public LocalDateTime getEndDate() {
            return this.endDate;
        }
    }

    @DomEvent(value="calendar-state-view-date-updated")
    public static class CalendarViewAndDateChangeEvent
    extends ComponentEvent<BaseScheduleXCalendar> {
        private final ViewType viewType;
        private final LocalDate selectedDate;

        public CalendarViewAndDateChangeEvent(BaseScheduleXCalendar source, boolean fromClient, @EventData(value="event.detail.viewName") String viewName, @EventData(value="event.detail.selectedDate") String selectedDate) {
            super((Component)source, fromClient);
            this.viewType = BaseScheduleXCalendar.parseViewType(viewName);
            this.selectedDate = LocalDate.parse(selectedDate);
        }

        public ViewType getViewType() {
            return this.viewType;
        }

        public LocalDate getSelectedDate() {
            return this.selectedDate;
        }
    }
}

