/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.componentfactory.schedulexcalendar.util;

import java.util.Locale;
import java.util.Set;

public class LocaleUtils {
    private static final Set<String> SUPPORTED_LOCALES = Set.of("ca-ES", "zh-CN", "zh-TW", "hr-HR", "cs-CZ", "da-DK", "nl-NL", "en-GB", "en-US", "et-EE", "fi-FI", "fr-FR", "fr-CH", "de-DE", "he-IL", "id-ID", "it-IT", "ja-JP", "ko-KR", "ky-KG", "lt-LT", "mk-MK", "pl-PL", "pt-BR", "ro-RO", "ru-RU", "sr-Latn-RS", "sr-RS", "sk-SK", "sl-SI", "es-ES", "sv-SE", "tr-TR", "uk-UA");

    public static void validateLocale(Locale locale) {
        String code = LocaleUtils.toScheduleXLocale(locale);
        if (!SUPPORTED_LOCALES.contains(code)) {
            throw new IllegalArgumentException("InvalidLocaleError: unsupported locale '" + code + "'");
        }
    }

    public static String toScheduleXLocale(Locale locale) {
        if ("sr".equals(locale.getLanguage()) && "Latn".equals(locale.getScript())) {
            return "sr-Latn-" + locale.getCountry();
        }
        return locale.toLanguageTag();
    }

    public static boolean isSupported(Locale locale) {
        return SUPPORTED_LOCALES.contains(LocaleUtils.toScheduleXLocale(locale));
    }
}

