/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.componentfactory.schedulexcalendar.model;

import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Optional;

public class Calendar
implements Serializable {
    private String colorName;
    private ColorDefinition lightColors;
    private ColorDefinition darkColors;

    public Calendar(String colorName) {
        this.colorName = colorName;
    }

    public Calendar(String colorName, ColorDefinition lightColors) {
        this(colorName);
        this.lightColors = lightColors;
    }

    public Calendar(String colorName, ColorDefinition lightColors, ColorDefinition darkColors) {
        this(colorName, lightColors);
        this.darkColors = darkColors;
    }

    public String getColorName() {
        return this.colorName;
    }

    public void setColorName(String colorName) {
        this.colorName = colorName;
    }

    public ColorDefinition getLightColors() {
        return this.lightColors;
    }

    public void setLightColors(ColorDefinition lightColors) {
        this.lightColors = lightColors;
    }

    public ColorDefinition getDarkColors() {
        return this.darkColors;
    }

    public void setDarkColors(ColorDefinition darkColors) {
        this.darkColors = darkColors;
    }

    public JsonObject toJsonObject() {
        JsonObject js = Json.createObject();
        js.put("colorName", this.colorName);
        Optional.ofNullable(this.lightColors).ifPresent(colors -> js.put("lightColors", (JsonValue)colors.toJsonObject()));
        Optional.ofNullable(this.darkColors).ifPresent(colors -> js.put("darkColors", (JsonValue)colors.toJsonObject()));
        return js;
    }

    public static class ColorDefinition
    implements Serializable {
        private String main;
        private String container;
        private String onContainer;

        public ColorDefinition(String main, String container, String onContainer) {
            this.main = main;
            this.container = container;
            this.onContainer = onContainer;
        }

        public String getMain() {
            return this.main;
        }

        public void setMain(String main) {
            this.main = main;
        }

        public String getContainer() {
            return this.container;
        }

        public void setContainer(String container) {
            this.container = container;
        }

        public String getOnContainer() {
            return this.onContainer;
        }

        public void setOnContainer(String onContainer) {
            this.onContainer = onContainer;
        }

        public JsonObject toJsonObject() {
            JsonObject js = Json.createObject();
            js.put("main", this.main);
            js.put("container", this.container);
            js.put("onContainer", this.onContainer);
            return js;
        }
    }
}

