/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.componentfactory.schedulexcalendar.model;

import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.vaadin.addons.componentfactory.schedulexcalendar.model.RecurrenceRule;
import org.vaadin.addons.componentfactory.schedulexcalendar.util.DateTimeFormatUtils;

public class Event
implements Serializable {
    private String id;
    private LocalDateTime start;
    private LocalDateTime end;
    private String title;
    private String description;
    private String location;
    private List<String> people;
    private String calendarId;
    private EventOptions options;
    private EventCustomContent customContent;
    private String resourceId;
    private RecurrenceRule recurrenceRule;
    private List<LocalDateTime> excludedDates;

    public Event(String id, LocalDateTime start, LocalDateTime end) {
        this.id = id;
        this.start = start;
        this.end = end;
    }

    public Event(String id, String start, String end) {
        this(id, DateTimeFormatUtils.parseDate(start, false), DateTimeFormatUtils.parseDate(end, true));
    }

    public Event(JsonValue json) {
        int i;
        JsonObject js = (JsonObject)json;
        this.id = js.getString("id");
        this.start = DateTimeFormatUtils.parseDate(js.getString("start"), false);
        this.end = DateTimeFormatUtils.parseDate(js.getString("end"), true);
        this.title = js.hasKey("title") ? js.getString("title") : null;
        this.description = js.hasKey("description") ? js.getString("description") : null;
        this.location = js.hasKey("location") ? js.getString("location") : null;
        this.calendarId = js.hasKey("calendarId") ? js.getString("calendarId") : null;
        String string = this.resourceId = js.hasKey("resourceId") ? js.getString("resourceId") : null;
        if (js.hasKey("people")) {
            JsonArray jsonPeople = js.getArray("people");
            for (i = 0; i < jsonPeople.length(); ++i) {
                this.people.add(jsonPeople.get(i).asString());
            }
        }
        if (js.hasKey("_options")) {
            this.options = new EventOptions();
            this.options.disableDND = js.getObject("_options").getBoolean("disableDND");
            this.options.disableResize = js.getObject("_options").getBoolean("disableResize");
            JsonArray additionalClasses = js.getObject("_options").getArray("additionalClasses");
            for (i = 0; i < additionalClasses.length(); ++i) {
                this.options.additionalClasses.add(additionalClasses.get(i).asString());
            }
        }
        if (js.hasKey("_customContent")) {
            this.customContent = new EventCustomContent();
            JsonObject jsonCustomContent = js.getObject("_customContent");
            this.customContent.timeGrid = jsonCustomContent.hasKey("timeGrid") ? jsonCustomContent.getString("timeGrid") : null;
            this.customContent.dateGrid = jsonCustomContent.hasKey("dateGrid") ? jsonCustomContent.getString("dateGrid") : null;
            this.customContent.monthGrid = jsonCustomContent.hasKey("monthGrid") ? jsonCustomContent.getString("monthGrid") : null;
            this.customContent.monthAgenda = jsonCustomContent.hasKey("monthAgenda") ? jsonCustomContent.getString("monthAgenda") : null;
        }
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.id, other.id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    public void setStart(LocalDateTime start) {
        this.start = start;
    }

    public LocalDateTime getEnd() {
        return this.end;
    }

    public void setEnd(LocalDateTime end) {
        this.end = end;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public List<String> getPeople() {
        return this.people;
    }

    public void setPeople(List<String> people) {
        this.people = people;
    }

    public String getCalendarId() {
        return this.calendarId;
    }

    public void setCalendarId(String calendarId) {
        this.calendarId = calendarId;
    }

    public EventOptions getOptions() {
        return this.options;
    }

    public void setOptions(EventOptions options) {
        this.options = options;
    }

    public EventCustomContent getCustomContent() {
        return this.customContent;
    }

    public void setCustomContent(EventCustomContent customContent) {
        this.customContent = customContent;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public RecurrenceRule getRecurrenceRule() {
        return this.recurrenceRule;
    }

    public void setRecurrenceRule(RecurrenceRule recurrenceRule) {
        this.recurrenceRule = recurrenceRule;
    }

    public List<LocalDateTime> getExcludedDates() {
        return this.excludedDates;
    }

    public void setExcludedDates(List<LocalDateTime> excludedDates) {
        this.excludedDates = excludedDates;
    }

    public String getJson() {
        int i;
        JsonObject js = Json.createObject();
        js.put("id", this.id);
        js.put("start", this.start.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        js.put("end", this.end.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        Optional.ofNullable(this.title).ifPresent(value -> js.put("title", value));
        Optional.ofNullable(this.description).ifPresent(value -> js.put("description", value));
        Optional.ofNullable(this.location).ifPresent(value -> js.put("location", value));
        Optional.ofNullable(this.calendarId).ifPresent(value -> js.put("calendarId", value));
        if (this.people != null && !this.people.isEmpty()) {
            JsonArray jsonPeople = Json.createArray();
            for (i = 0; i < this.people.size(); ++i) {
                jsonPeople.set(i, this.people.get(i));
            }
            js.put("people", (JsonValue)jsonPeople);
        }
        if (this.options != null) {
            js.put("_options", (JsonValue)this.options.toJson());
        }
        if (this.customContent != null) {
            JsonObject jsonCustomContent = Json.createObject();
            Optional.ofNullable(this.customContent.getTimeGrid()).ifPresent(v -> jsonCustomContent.put("timeGrid", v));
            Optional.ofNullable(this.customContent.getDateGrid()).ifPresent(v -> jsonCustomContent.put("dateGrid", v));
            Optional.ofNullable(this.customContent.getMonthGrid()).ifPresent(v -> jsonCustomContent.put("monthGrid", v));
            Optional.ofNullable(this.customContent.getMonthAgenda()).ifPresent(v -> jsonCustomContent.put("monthAgenda", v));
            js.put("_customContent", (JsonValue)jsonCustomContent);
        }
        Optional.ofNullable(this.resourceId).ifPresent(value -> js.put("resourceId", value));
        Optional.ofNullable(this.recurrenceRule).ifPresent(value -> js.put("rrule", value.getRule()));
        if (this.excludedDates != null && !this.excludedDates.isEmpty()) {
            JsonArray jsonExDates = Json.createArray();
            for (i = 0; i < this.excludedDates.size(); ++i) {
                jsonExDates.set(i, this.excludedDates.get(i).format(DateTimeFormatUtils.DATE_TIME_FORMATTER));
            }
            js.put("exdate", (JsonValue)jsonExDates);
        }
        return js.toJson();
    }

    public static class EventOptions
    implements Serializable {
        private Boolean disableDND;
        private Boolean disableResize;
        private List<String> additionalClasses;

        public Boolean getDisableDND() {
            return this.disableDND;
        }

        public void setDisableDND(Boolean disableDND) {
            this.disableDND = disableDND;
        }

        public Boolean getDisableResize() {
            return this.disableResize;
        }

        public void setDisableResize(Boolean disableResize) {
            this.disableResize = disableResize;
        }

        public List<String> getAdditionalClasses() {
            return this.additionalClasses;
        }

        public void setAdditionalClasses(List<String> additionalClasses) {
            this.additionalClasses = additionalClasses;
        }

        public JsonObject toJson() {
            JsonObject json = Json.createObject();
            Optional.ofNullable(this.disableDND).ifPresent(value -> json.put("disableDND", value.booleanValue()));
            Optional.ofNullable(this.disableResize).ifPresent(value -> json.put("disableResize", value.booleanValue()));
            if (this.additionalClasses != null && !this.additionalClasses.isEmpty()) {
                JsonArray jsonArray = Json.createArray();
                for (int i = 0; i < this.additionalClasses.size(); ++i) {
                    jsonArray.set(i, this.additionalClasses.get(i));
                }
                json.put("additionalClasses", (JsonValue)jsonArray);
            }
            return json;
        }
    }

    public static class EventCustomContent
    implements Serializable {
        private String timeGrid;
        private String dateGrid;
        private String monthGrid;
        private String monthAgenda;

        public String getTimeGrid() {
            return this.timeGrid;
        }

        public void setTimeGrid(String timeGrid) {
            this.timeGrid = timeGrid;
        }

        public String getDateGrid() {
            return this.dateGrid;
        }

        public void setDateGrid(String dateGrid) {
            this.dateGrid = dateGrid;
        }

        public String getMonthGrid() {
            return this.monthGrid;
        }

        public void setMonthGrid(String monthGrid) {
            this.monthGrid = monthGrid;
        }

        public String getMonthAgenda() {
            return this.monthAgenda;
        }

        public void setMonthAgenda(String monthAgenda) {
            this.monthAgenda = monthAgenda;
        }
    }
}

