/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.componentfactory.schedulexcalendar;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import org.vaadin.addons.componentfactory.schedulexcalendar.BaseScheduleXCalendar;
import org.vaadin.addons.componentfactory.schedulexcalendar.Configuration;
import org.vaadin.addons.componentfactory.schedulexcalendar.model.Calendar;
import org.vaadin.addons.componentfactory.schedulexcalendar.model.Event;
import org.vaadin.addons.componentfactory.schedulexcalendar.model.EventQueryFilter;
import org.vaadin.addons.componentfactory.schedulexcalendar.util.CalendarViewType;
import org.vaadin.addons.componentfactory.schedulexcalendar.util.DateTimeFormatUtils;

@NpmPackage(value="@sx-premium/draw", version="13.2.1")
@JsModule(value="./src/vcf-schedule-x-calendar.js")
public class ScheduleXCalendar
extends BaseScheduleXCalendar {
    private DrawnEventValidationCallback drawnEventValidationCallback;

    public ScheduleXCalendar(List<CalendarViewType> views, CallbackDataProvider<Event, EventQueryFilter> dataProvider, Configuration configuration) {
        super(views, dataProvider, configuration);
    }

    public ScheduleXCalendar(List<CalendarViewType> views, CallbackDataProvider<Event, EventQueryFilter> dataProvider, Configuration configuration, Map<String, Calendar> calendars) {
        super(views, dataProvider, configuration, calendars);
    }

    @Override
    protected String getJsConnector() {
        return "vcfschedulexcalendar";
    }

    @Override
    protected void initCalendar(boolean refreshView) {
        if (!refreshView) {
            this.getElement().executeJs(this.getJsConnector() + ".create($0, $1, $2, $3)", new Serializable[]{this.container, this.viewsToJson(), this.configurationToJson(), this.calendarsToJson()});
        } else {
            this.getElement().executeJs(this.getJsConnector() + ".create($0, $1, $2, $3, $4)", new Serializable[]{this.container, this.viewsToJson(), this.configurationToJson(), this.calendarsToJson(), this.getView().getName()});
        }
    }

    @ClientCallable
    void addEvent(JsonValue jsonValue) {
        Event event = new Event(jsonValue);
        this.fireEvent(new CalendarEventDrawnEvent(this, true, event));
    }

    public void scrollTo(LocalTime time) {
        this.getElement().executeJs("vcfschedulexcalendar.scrollTo($0, $1);", new Serializable[]{this.container, time.format(DateTimeFormatUtils.TIME_FORMATTER)});
    }

    public void setDrawnEventValidationCallback(DrawnEventValidationCallback drawnEventValidationCallback) {
        this.drawnEventValidationCallback = drawnEventValidationCallback;
    }

    @ClientCallable
    private boolean validateDrawnEvent(String eventId, String start, String end) {
        if (this.drawnEventValidationCallback != null) {
            return (Boolean)this.drawnEventValidationCallback.apply(new Event(eventId, start, end));
        }
        return true;
    }

    public Registration addCalendarEventDrawnEventListener(ComponentEventListener<CalendarEventDrawnEvent> listener) {
        return this.addListener(CalendarEventDrawnEvent.class, listener);
    }

    public static class CalendarEventDrawnEvent
    extends ComponentEvent<BaseScheduleXCalendar> {
        private final Event event;

        public CalendarEventDrawnEvent(BaseScheduleXCalendar source, boolean fromClient, Event event) {
            super((Component)source, fromClient);
            this.event = event;
        }

        public Event getEvent() {
            return this.event;
        }
    }

    @FunctionalInterface
    public static interface DrawnEventValidationCallback
    extends SerializableFunction<Event, Boolean> {
    }
}

