/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.componentfactory.schedulexcalendar;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.vaadin.addons.componentfactory.schedulexcalendar.BaseScheduleXCalendar;
import org.vaadin.addons.componentfactory.schedulexcalendar.Configuration;
import org.vaadin.addons.componentfactory.schedulexcalendar.ResourceSchedulerConfig;
import org.vaadin.addons.componentfactory.schedulexcalendar.SchedulingAssistantConfig;
import org.vaadin.addons.componentfactory.schedulexcalendar.model.Calendar;
import org.vaadin.addons.componentfactory.schedulexcalendar.model.Event;
import org.vaadin.addons.componentfactory.schedulexcalendar.model.EventQueryFilter;
import org.vaadin.addons.componentfactory.schedulexcalendar.util.ResourceViewType;

@NpmPackage.Container(value={@NpmPackage(value="preact", version="10.26.4"), @NpmPackage(value="@preact/signals", version="2.0.2"), @NpmPackage(value="@sx-premium/resource-scheduler", version="3.17.0"), @NpmPackage(value="@sx-premium/scheduling-assistant", version="3.17.0")})
@JsModule(value="./src/vcf-schedule-x-resource-scheduler.js")
public class ScheduleXResourceScheduler
extends BaseScheduleXCalendar {
    private ResourceSchedulerConfig resourceSchedulerConfig;
    private SchedulingAssistantConfig schedulingAssistantConfig;

    public ScheduleXResourceScheduler(List<ResourceViewType> views, CallbackDataProvider<Event, EventQueryFilter> dataProvider, Configuration configuration, ResourceSchedulerConfig resourceSchedulerConfig) {
        super(views, dataProvider, configuration);
        this.resourceSchedulerConfig = resourceSchedulerConfig;
        this.resourceSchedulerConfig.setCalendar(this);
    }

    public ScheduleXResourceScheduler(List<ResourceViewType> views, CallbackDataProvider<Event, EventQueryFilter> dataProvider, Configuration configuration, Map<String, Calendar> calendars, ResourceSchedulerConfig resourceSchedulerConfig) {
        super(views, dataProvider, configuration, calendars);
        this.resourceSchedulerConfig = resourceSchedulerConfig;
        this.resourceSchedulerConfig.setCalendar(this);
    }

    public ScheduleXResourceScheduler(List<ResourceViewType> views, CallbackDataProvider<Event, EventQueryFilter> dataProvider, Configuration configuration, Map<String, Calendar> calendars, ResourceSchedulerConfig resourceSchedulerConfig, SchedulingAssistantConfig schedulingAssistantConfig) {
        this(views, dataProvider, configuration, calendars, resourceSchedulerConfig);
        if (ResourceViewType.DAILY.equals(this.getView()) && schedulingAssistantConfig != null) {
            throw new IllegalArgumentException("Scheduling Assistant is not supported with ResourceViewType.DAILY. Use an ResourceViewType.HOURLY view instead.");
        }
        this.schedulingAssistantConfig = schedulingAssistantConfig;
        this.schedulingAssistantConfig.setCalendar(this);
    }

    @Override
    protected String getJsConnector() {
        return "vcfschedulexresourcescheduler";
    }

    @Override
    protected void initCalendar(boolean refreshView) {
        if (!refreshView) {
            this.getElement().executeJs(this.getJsConnector() + ".create($0, $1, $2, $3, $4, $5)", new Serializable[]{this.container, this.viewsToJson(), this.configurationToJson(), this.calendarsToJson(), this.resourceSchedulerConfigToJson(), this.schedulingAssistantConfigToJson()});
        } else {
            this.getElement().executeJs(this.getJsConnector() + ".create($0, $1, $2, $3, $4, $5, $6)", new Serializable[]{this.container, this.viewsToJson(), this.configurationToJson(), this.calendarsToJson(), this.resourceSchedulerConfigToJson(), this.schedulingAssistantConfigToJson(), this.getView().getName()});
        }
    }

    protected String resourceSchedulerConfigToJson() {
        return this.resourceSchedulerConfig != null ? this.resourceSchedulerConfig.getJson() : "{}";
    }

    protected String schedulingAssistantConfigToJson() {
        return this.schedulingAssistantConfig != null ? this.schedulingAssistantConfig.getJson() : "{}";
    }

    public ResourceSchedulerConfig getResourceSchedulerConfig() {
        return this.resourceSchedulerConfig;
    }

    public SchedulingAssistantConfig getSchedulingAssistantConfig() {
        return this.schedulingAssistantConfig;
    }

    public void setSchedulingAssistantConfig(SchedulingAssistantConfig schedulingAssistantConfig) {
        this.schedulingAssistantConfig = schedulingAssistantConfig;
        if (this.schedulingAssistantConfig != null) {
            this.schedulingAssistantConfig.setCalendar(this);
        }
        this.refreshCalendar();
    }

    public Registration addSchedulingAssistantUpdateListener(ComponentEventListener<SchedulingAssistantUpdateEvent> listener) {
        return this.addListener(SchedulingAssistantUpdateEvent.class, listener);
    }

    @DomEvent(value="scheduling-assistant-update")
    public static class SchedulingAssistantUpdateEvent
    extends ComponentEvent<ScheduleXResourceScheduler> {
        private final String currentStart;
        private final String currentEnd;
        private final boolean hasCollision;

        public SchedulingAssistantUpdateEvent(ScheduleXResourceScheduler source, boolean fromClient, @EventData(value="event.detail.currentStart") String currentStart, @EventData(value="event.detail.currentEnd") String currentEnd, @EventData(value="event.detail.hasCollision") boolean hasCollision) {
            super((Component)source, fromClient);
            this.currentStart = currentStart;
            this.currentEnd = currentEnd;
            this.hasCollision = hasCollision;
        }

        public String getCurrentStart() {
            return this.currentStart;
        }

        public String getCurrentEnd() {
            return this.currentEnd;
        }

        public boolean isHasCollision() {
            return this.hasCollision;
        }
    }
}

