/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory.pdfviewer;

import com.vaadin.componentfactory.pdfviewer.event.ThumbnailClickedEvent;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import java.io.Serializable;

@Tag(value="vcf-pdf-viewer")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin-component-factory/vcf-pdf-viewer", version="4.0.2"), @NpmPackage(value="print-js", version="1.6.0")})
@JsModule.Container(value={@JsModule(value="@vaadin-component-factory/vcf-pdf-viewer/vcf-pdf-viewer.js"), @JsModule(value="./src/pdf-print.js")})
@CssImport.Container(value={@CssImport(value="./styles/toolbar-button.css", themeFor="vaadin-button"), @CssImport(value="print-js/dist/print.css")})
public class PdfViewer
extends Div {
    private Button downloadButton;
    private boolean addDownloadButton = true;
    private Anchor downloadLink;
    private boolean addPrintButton = false;
    private Button printButton;
    private boolean addRotateClockwiseButton = false;
    private Button rotateClockwiseButton;
    private boolean addRotateCounterClockwiseButton = false;
    private Button rotateCounterClockwiseButton;
    private String printButtonTooltipText;
    private String downloadButtonTooltipText;
    private String rotateClockwiseButtonTooltipText;
    private String rotateCounterClockwiseButtonTooltipText;

    public String getSrc() {
        return this.getElement().getAttribute("src");
    }

    public void setSrc(String src) {
        this.getElement().setAttribute("src", src);
        this.updateDownloadSource();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public void setSrc(AbstractStreamResource src) {
        this.getElement().setAttribute("src", src);
        this.updateDownloadSource();
    }

    public void setSrc(DownloadHandler downloadHandler) {
        this.getElement().setAttribute("src", (ElementRequestHandler)downloadHandler);
        this.updateDownloadSource();
    }

    public String getZoom() {
        return this.getElement().getProperty("zoom");
    }

    public void setZoom(String zoom) {
        this.getElement().setProperty("zoom", zoom);
    }

    public void addThumbnailClickedListener(ComponentEventListener<ThumbnailClickedEvent> listener) {
        this.addListener(ThumbnailClickedEvent.class, listener);
    }

    public void openThumbnailsView() {
        this.getElement().executeJs("this.__openSidebar()", new Object[0]);
    }

    public void closeThumbnailsView() {
        this.getElement().executeJs("this.__closeSidebar()", new Object[0]);
    }

    @Synchronize(value={"currentPage-changed"})
    public String getCurrentPage() {
        return this.getElement().getProperty("currentPage");
    }

    public void setPage(Integer currentPage) {
        this.getElement().executeJs("this.setCurrentPage($0)", new Object[]{currentPage});
    }

    public void showFilenameOnly(boolean filenameOnly) {
        this.getElement().setProperty("toolbarOnlyFilename", filenameOnly);
    }

    public void setAutoZoomOptionLabel(String autoZoomOptionLabel) {
        this.getElement().setProperty("autoZoomOptionLabel", autoZoomOptionLabel);
    }

    public void setPageFitZoomOptionLabel(String fitZoomOptionLabel) {
        this.getElement().setProperty("fitZoomOptionLabel", fitZoomOptionLabel);
    }

    public boolean isAddDownloadButton() {
        return this.addDownloadButton;
    }

    public void setAddDownloadButton(boolean addDownloadButton) {
        this.addDownloadButton = addDownloadButton;
    }

    public String getCustomTitle() {
        return this.getElement().getProperty("customTitle");
    }

    public void setCustomTitle(String customTitle) {
        this.getElement().setProperty("customTitle", customTitle);
    }

    public boolean isAddPrintButton() {
        return this.addPrintButton;
    }

    public void setAddPrintButton(boolean addPrintButton) {
        this.addPrintButton = addPrintButton;
    }

    public void setRenderInteractiveForms(boolean renderInteractiveForms) {
        this.getElement().setProperty("renderInteractiveForms", renderInteractiveForms);
    }

    public void hideZoom(boolean hideZoom) {
        this.getElement().setProperty("hideZoom", hideZoom);
    }

    public void setPreviousPageTooltipText(String previousPageTooltipText) {
        this.getElement().setProperty("previousPageTooltip", previousPageTooltipText);
    }

    public String getPreviousPageTooltipText() {
        return this.getElement().getProperty("previousPageTooltip");
    }

    public void setNextPageTooltipText(String nextPageTooltipText) {
        this.getElement().setProperty("nextPageTooltip", nextPageTooltipText);
    }

    public String getNextPageTooltipText() {
        return this.getElement().getProperty("nextPageTooltip");
    }

    public void setSidebarToggleTooltipText(String sidebarToggleTooltipText) {
        this.getElement().setProperty("sidebarToggleTooltip", sidebarToggleTooltipText);
    }

    public String getSidebarToggleTooltipText() {
        return this.getElement().getProperty("sidebarToggleTooltip");
    }

    public void setPrintButtonTooltipText(String printButtonTooltipText) {
        this.printButtonTooltipText = printButtonTooltipText;
    }

    public String getPrintButtonTooltipText() {
        return this.printButtonTooltipText;
    }

    public void setDownloadButtonTooltipText(String downloadButtonTooltipText) {
        this.downloadButtonTooltipText = downloadButtonTooltipText;
    }

    public String getDownloadButtonTooltipText() {
        return this.downloadButtonTooltipText;
    }

    public boolean isAddRotateClockwiseButton() {
        return this.addRotateClockwiseButton;
    }

    public void setAddRotateClockwiseButton(boolean addRotateClockwiseButton) {
        this.addRotateClockwiseButton = addRotateClockwiseButton;
    }

    public boolean isAddRotateCounterClockwiseButton() {
        return this.addRotateCounterClockwiseButton;
    }

    public void setAddRotateCounterClockwiseButton(boolean addRotateCounterClockwiseButton) {
        this.addRotateCounterClockwiseButton = addRotateCounterClockwiseButton;
    }

    public void setRotateClockwiseButtonTooltipText(String rotateClockwiseButtonTooltipText) {
        this.rotateClockwiseButtonTooltipText = rotateClockwiseButtonTooltipText;
    }

    public String getRotateClockwiseButtonTooltipText() {
        return this.rotateClockwiseButtonTooltipText;
    }

    public void setRotateCounterClockwiseButtonTooltipText(String rotateCounterClockwiseButtonTooltipText) {
        this.rotateCounterClockwiseButtonTooltipText = rotateCounterClockwiseButtonTooltipText;
    }

    public String getRotateCounterClockwiseButtonTooltipText() {
        return this.rotateCounterClockwiseButtonTooltipText;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.addDownloadButton) {
            this.addDownloadButton();
        }
        if (this.addPrintButton) {
            this.addPrintButton();
        }
        if (this.addRotateClockwiseButton) {
            this.addRotateClockwiseButton();
        }
        if (this.addRotateCounterClockwiseButton) {
            this.addRotateCounterClockwiseButton();
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        if (this.addDownloadButton) {
            this.getElement().removeChild(new Element[]{this.downloadLink.getElement()});
        }
        if (this.addPrintButton) {
            this.getElement().removeChild(new Element[]{this.printButton.getElement()});
        }
        if (this.addRotateClockwiseButton) {
            this.getElement().removeChild(new Element[]{this.rotateClockwiseButton.getElement()});
        }
        if (this.addRotateCounterClockwiseButton) {
            this.getElement().removeChild(new Element[]{this.rotateCounterClockwiseButton.getElement()});
        }
    }

    private void addDownloadButton() {
        String src = this.getSrc();
        if (!this.isBlank(src)) {
            this.downloadLink = new Anchor(src, "");
        } else {
            this.downloadLink = new Anchor();
            this.downloadLink.setText("");
        }
        this.downloadLink.setTabIndex(-1);
        this.downloadButton = new Button();
        this.downloadButton.getElement().appendChild(new Element[]{new Icon(VaadinIcon.DOWNLOAD).getElement()});
        this.downloadButton.getElement().setAttribute("aria-label", "Download file");
        this.downloadButton.setThemeName("download-button");
        this.downloadButton.setEnabled(!this.isBlank(src));
        this.downloadButton.setTooltipText(this.getDownloadButtonTooltipText());
        this.downloadLink.add(new Component[]{this.downloadButton});
        this.downloadLink.getElement().setAttribute("download", true);
        this.getElement().appendChild(new Element[]{this.downloadLink.getElement()});
    }

    private void updateDownloadSource() {
        if (this.downloadLink != null) {
            String src = this.getSrc();
            this.downloadLink.setHref(src);
            this.downloadButton.setEnabled(!this.isBlank(src));
        }
    }

    private void addPrintButton() {
        this.printButton = new Button((Component)new Icon(VaadinIcon.PRINT));
        this.printButton.getElement().setAttribute("aria-label", "Print file");
        this.printButton.setThemeName("print-button");
        this.getElement().appendChild(new Element[]{this.printButton.getElement()});
        this.printButton.addClickListener((ComponentEventListener & Serializable)e -> this.getElement().executeJs("printPdf.printPdf($0)", new Object[]{this.getSrc()}));
        this.printButton.setTooltipText(this.getPrintButtonTooltipText());
    }

    private void addRotateClockwiseButton() {
        this.rotateClockwiseButton = new Button((Component)new Icon(VaadinIcon.ROTATE_RIGHT));
        this.rotateClockwiseButton.getElement().setAttribute("aria-label", "Rotate clockwise");
        this.rotateClockwiseButton.setThemeName("rotate-button");
        this.getElement().appendChild(new Element[]{this.rotateClockwiseButton.getElement()});
        this.rotateClockwiseButton.addClickListener((ComponentEventListener & Serializable)e -> this.getElement().executeJs("this.rotateCw()", new Object[0]));
        this.rotateClockwiseButton.setTooltipText(this.getRotateClockwiseButtonTooltipText());
    }

    private void addRotateCounterClockwiseButton() {
        this.rotateCounterClockwiseButton = new Button((Component)new Icon(VaadinIcon.ROTATE_LEFT));
        this.rotateCounterClockwiseButton.getElement().setAttribute("aria-label", "Rotate counterclockwise");
        this.rotateCounterClockwiseButton.setThemeName("rotate-button");
        this.getElement().appendChild(new Element[]{this.rotateCounterClockwiseButton.getElement()});
        this.rotateCounterClockwiseButton.addClickListener((ComponentEventListener & Serializable)e -> this.getElement().executeJs("this.rotateCcw()", new Object[0]));
        this.rotateCounterClockwiseButton.setTooltipText(this.getRotateCounterClockwiseButtonTooltipText());
    }

    private boolean isBlank(String str) {
        return str == null || str.isBlank();
    }
}

