/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.componentfactory.monthpicker;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasPlaceholder;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasAutoOpen;
import com.vaadin.flow.component.shared.HasClearButton;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.JsonNodeFactory;
import tools.jackson.databind.node.ObjectNode;

@Tag(value="vcf-month-picker")
@NpmPackage(value="@vaadin-component-factory/vcf-month-picker", version="3.0.0-beta1")
@JsModule(value="@vaadin-component-factory/vcf-month-picker/dist/src/vcf-month-picker.js")
public class MonthPicker
extends AbstractSinglePropertyField<MonthPicker, YearMonth>
implements HasLabel,
HasAutoOpen,
HasClearButton,
HasPlaceholder,
HasHelper,
HasValidation,
HasTooltip,
Focusable<MonthPicker> {
    private static final SerializableFunction<String, YearMonth> PARSER = (SerializableFunction & Serializable)s -> s == null || s.isEmpty() ? null : YearMonth.parse(s);
    private static final SerializableFunction<YearMonth, String> FORMATTER = (SerializableFunction & Serializable)ym -> ym == null ? "" : ym.toString();
    private MonthPickerI18n i18n;

    public MonthPicker() {
        this(null);
    }

    public MonthPicker(YearMonth initialYearMonth) {
        super("value", (Object)initialYearMonth, String.class, PARSER, FORMATTER);
    }

    public void setErrorMessage(String errorMessage) {
        this.getElement().setProperty("errorMessage", errorMessage);
    }

    public String getErrorMessage() {
        return this.getElement().getProperty("errorMessage", "");
    }

    public void setInvalid(boolean invalid) {
        this.getElement().setProperty("invalid", invalid);
        if (!invalid) {
            this.getElement().setProperty("errorMessage", "");
        }
    }

    public boolean isInvalid() {
        return this.getElement().getProperty("invalid", false);
    }

    public void setMinYear(int minYear) {
        this.getElement().setProperty("minYear", String.valueOf(minYear));
    }

    public int getMinYear() {
        return Optional.ofNullable(this.getElement().getProperty("minYear")).map(Integer::valueOf).orElse(0);
    }

    public void setMaxYear(int maxYear) {
        this.getElement().setProperty("maxYear", String.valueOf(maxYear));
    }

    public int getMaxYear() {
        return Optional.ofNullable(this.getElement().getProperty("maxYear")).map(Integer::valueOf).orElse(0);
    }

    public MonthPickerI18n getI18n() {
        return this.i18n;
    }

    public void seti18n(MonthPickerI18n i18n) {
        this.i18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
        ObjectNode i18nJson = this.getI18nJsonObject(i18n);
        this.getElement().setPropertyJson("i18n", (BaseJsonNode)i18nJson);
    }

    private ObjectNode getI18nJsonObject(MonthPickerI18n i18n) {
        ObjectNode i18nJson = JsonNodeFactory.instance.objectNode();
        MonthPicker.writeStringListAsJsonArray(i18n.getMonthNames(), i18nJson, "monthNames");
        MonthPicker.writeStringListAsJsonArray(i18n.getShortMonthNames(), i18nJson, "shortMonthNames");
        MonthPicker.writeStringListAsJsonArray(i18n.getMonthLabels(), i18nJson, "monthLabels");
        MonthPicker.writeStringListAsJsonArray(i18n.getFormats(), i18nJson, "formats");
        return i18nJson;
    }

    private static void writeStringListAsJsonArray(@Nullable List<String> stringList, ObjectNode jsonObject, String jsonProperty) {
        if (stringList != null) {
            ArrayNode monthNamesArray = JsonNodeFactory.instance.arrayNode();
            stringList.forEach(arg_0 -> ((ArrayNode)monthNamesArray).add(arg_0));
            jsonObject.set(jsonProperty, (JsonNode)monthNamesArray);
        }
    }

    @Synchronize(property="opened", value={"vcf-month-picker-opened-changed"})
    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent> listener) {
        return this.addListener(OpenedChangeEvent.class, listener);
    }

    public static class MonthPickerI18n
    implements Serializable {
        private List<String> monthNames;
        private List<String> monthLabels;
        private List<String> shortMonthNames;
        private List<String> formats;

        public List<String> getMonthNames() {
            return this.monthNames;
        }

        public MonthPickerI18n setMonthNames(List<String> monthNames) {
            this.monthNames = monthNames;
            return this;
        }

        public List<String> getMonthLabels() {
            return this.monthLabels;
        }

        public MonthPickerI18n setMonthLabels(List<String> monthLabels) {
            this.monthLabels = monthLabels;
            return this;
        }

        public List<String> getShortMonthNames() {
            return this.shortMonthNames;
        }

        public MonthPickerI18n setShortMonthNames(List<String> shortMonthNames) {
            this.shortMonthNames = shortMonthNames;
            return this;
        }

        public List<String> getFormats() {
            return this.formats;
        }

        public MonthPickerI18n setFormat(String format) {
            this.setFormats(format, new String[0]);
            return this;
        }

        public MonthPickerI18n setFormats(String primaryFormat, String ... additionalParsingFormats) {
            Objects.requireNonNull(additionalParsingFormats, "Additional parsing formats must not be null");
            if (primaryFormat == null) {
                this.formats = null;
            } else {
                this.formats = new ArrayList<String>();
                this.formats.add(primaryFormat);
                this.formats.addAll(Stream.of(additionalParsingFormats).filter(Objects::nonNull).toList());
            }
            return this;
        }
    }

    @DomEvent(value="vcf-month-picker-opened-changed")
    public static class OpenedChangeEvent
    extends ComponentEvent<MonthPicker> {
        private final boolean opened;

        public OpenedChangeEvent(MonthPicker source, boolean fromClient) {
            super((Component)source, fromClient);
            this.opened = source.isOpened();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }
}

