/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory.addons.inputmask;

import com.vaadin.componentfactory.addons.inputmask.InputMaskOption;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.ObjectMapper;

@Tag(value="input-mask")
@NpmPackage(value="imask", version="7.1.3")
@JsModule(value="./src/input-mask.js")
public class InputMask
extends AbstractSinglePropertyField<InputMask, String>
implements HasValidation {
    private static final Logger logger = LoggerFactory.getLogger(InputMask.class);
    static final String TAG_NAME = "input-mask";
    private WeakReference<Component> extended;
    private Registration attachRegistration = null;
    private Registration valueChangeRegistration;
    private List<InputMaskOption> options = new ArrayList<InputMaskOption>();

    public InputMask(String mask, InputMaskOption ... options) {
        this(mask, false, options);
    }

    public InputMask(String mask, boolean evalMask, InputMaskOption ... options) {
        super("unmaskedValue", (Object)"", false);
        this.options.add(InputMaskOption.option("mask", mask, evalMask));
        if (options != null) {
            this.options.addAll(Arrays.asList(options));
        }
    }

    public void extend(Component component) {
        this.extended = new WeakReference<Component>(component);
        if (component.getUI().isPresent()) {
            this.extend(component, (UI)component.getUI().get());
        } else {
            this.attachRegistration = component.addAttachListener((ComponentEventListener & Serializable)event -> this.extend(component, event.getUI()));
            component.addDetachListener((ComponentEventListener & Serializable)event -> this.remove());
        }
    }

    private void extend(Component component, UI ui) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            this.getElement().setProperty("options", objectMapper.writeValueAsString(this.options));
            Element componentElement = component.getElement();
            componentElement.getChildren().filter(child -> TAG_NAME.equalsIgnoreCase(child.getTag())).findAny().ifPresent(xva$0 -> {
                Element cfr_ignored_0 = (Element)componentElement.removeChild(new Element[]{xva$0});
            });
            componentElement.appendChild(new Element[]{this.getElement()});
            if (HasValue.class.isAssignableFrom(component.getClass())) {
                this.valueChangeRegistration = ((HasValue)HasValue.class.cast(component)).addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                    if (!e.isFromClient()) {
                        this.getElement().executeJs("this.setValue($0.inputElement ? $0.inputElement.value : '')", new Object[]{component.getElement()});
                    }
                });
            }
        }
        catch (JacksonException ex) {
            logger.error("Error serializing InputMask options", (Throwable)ex);
        }
    }

    public void remove() {
        if (this.attachRegistration != null) {
            this.attachRegistration.remove();
            this.attachRegistration = null;
        }
        if (this.valueChangeRegistration != null) {
            this.valueChangeRegistration.remove();
            this.valueChangeRegistration = null;
        }
        if (this.extended != null) {
            this.getElement().removeFromParent();
            this.extended.clear();
        }
        this.extended = null;
    }

    public void getUnmaskedValue(SerializableConsumer<String> consumer) {
        this.getElement().executeJs("return this.getUnmaskedValue()", new Object[0]).then(String.class, (SerializableConsumer & Serializable)value -> consumer.accept(value));
    }

    public void getMaskedValue(SerializableConsumer<String> consumer) {
        this.getElement().executeJs("return this.getMaskedValue()", new Object[0]).then(String.class, (SerializableConsumer & Serializable)value -> consumer.accept(value));
    }

    public void setErrorMessage(String errorMessage) {
        if (this.extendedHasValidation()) {
            ((HasValidation)this.extended.get()).setErrorMessage(errorMessage);
        }
    }

    public String getErrorMessage() {
        return this.extendedHasValidation() ? ((HasValidation)this.extended.get()).getErrorMessage() : null;
    }

    public void setInvalid(boolean invalid) {
        if (this.extendedHasValidation()) {
            ((HasValidation)this.extended.get()).setInvalid(invalid);
        }
    }

    public boolean isInvalid() {
        return this.extendedHasValidation() && ((HasValidation)this.extended.get()).isInvalid();
    }

    private boolean extendedHasValidation() {
        return this.extended != null && this.extended.get() != null && this.extended.get() instanceof HasValidation;
    }

    protected void setPresentationValue(String newPresentationValue) {
        if (this.extended != null && this.extended.get() != null) {
            if (!TextField.class.isAssignableFrom(((Component)this.extended.get()).getClass())) {
                throw new IllegalArgumentException("Only TextField is supported for unmasked value binding.");
            }
            ((TextField)TextField.class.cast(this.extended.get())).setValue(newPresentationValue);
        }
        super.setPresentationValue((Object)newPresentationValue);
    }
}

