/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.componentfactory;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.data.binder.BeanPropertySet;
import com.vaadin.flow.data.binder.PropertySet;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

@StyleSheet.Container(value={@StyleSheet(value="context://c3/c3.min.css"), @StyleSheet(value="context://pivottable/dist/pivot.css")})
@JavaScript.Container(value={@JavaScript(value="context://jquery/dist/jquery.min.js"), @JavaScript(value="context://jqueryui/jquery-ui.min.js"), @JavaScript(value="context://d3/build/d3.min.js"), @JavaScript(value="context://c3/c3.min.js"), @JavaScript(value="context://pivottable/dist/pivot.min.js"), @JavaScript(value="context://pivottable/dist/c3_renderers.min.js"), @JavaScript(value="context://pivottable/dist/export_renderers.min.js"), @JavaScript(value="context://tabletojson/lib/jquery.tabletojson.min.js"), @JavaScript(value="./pivot_connector.js")})
@CssImport(value="./lumo-pivot.css")
public class PivotTable
extends Composite<Div> {
    private String dataJson;
    private String optionsJson;
    private PivotMode pivotMode;
    private Random rand = new Random();
    private String id;
    private PivotOptions options;
    private PivotTableI18n i18n;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public PivotTable(PivotData pivotData, PivotOptions pivotOptions) {
        this(pivotData, pivotOptions, PivotMode.NONINTERACTIVE);
    }

    public PivotTable(AbstractPivotData pivotData, PivotOptions pivotOptions, PivotMode mode) {
        this.pivotMode = mode;
        this.id = this.randomId(10);
        this.setId(this.id);
        String optionsArray = pivotOptions.toJson();
        this.options = pivotOptions;
        this.dataJson = pivotData.toJson();
        this.optionsJson = optionsArray;
    }

    protected void onAttach(AttachEvent event) {
        super.onAttach(event);
        if (this.options.charts) {
            String cols = this.options.cols != null ? this.options.cols.stream().collect(Collectors.joining(",")) : null;
            String rows = this.options.rows != null ? this.options.rows.stream().collect(Collectors.joining(",")) : null;
            String disabledRenderers = this.options.disabledRerenders != null ? this.options.disabledRerenders.stream().collect(Collectors.joining(",")) : null;
            event.getUI().getPage().executeJs("window.drawChartPivotUI($0, $1, $2, $3, $4, $5, $6, $7, $8, $9);", new Object[]{this.id, this.dataJson, cols, rows, disabledRenderers, this.options.renderer, this.options.aggregator, this.options.column, this.options.fieldsDisabled, this.pivotMode != PivotMode.INTERACTIVE});
        } else {
            event.getUI().getPage().executeJs("window.drawPivotUI($0, $1, $2, $3, $4, $5, $6, $7);", new Object[]{this.id, this.dataJson, this.optionsJson, this.options.renderer, this.options.aggregator, this.options.column, this.options.fieldsDisabled, this.pivotMode != PivotMode.INTERACTIVE});
        }
    }

    public void fetchResult(SerializableConsumer<JsonNode> callback) {
        Objects.requireNonNull(callback, "Url consumer callback should not be null.");
        this.getElement().executeJs("return window.getPivotTableResult($0);", new Object[]{this.id}).then(arg_0 -> callback.accept(arg_0));
    }

    private String randomId(int chars) {
        int limit = (int)(Math.pow(10.0, chars) - 1.0);
        Object key = "" + this.rand.nextInt(limit);
        key = String.format("%" + chars + "s", key).replace(' ', '0');
        return "pivot-" + (String)key;
    }

    public Registration addPivotReftreshedListener(ComponentEventListener<PivotRefreshedEvent<PivotTable>> listener) {
        return this.addListener(PivotRefreshedEvent.class, listener);
    }

    public void setI18n(PivotTableI18n i18n) {
        this.i18n = i18n;
        this.getElement().executeJs("window.setPivotTableI18n($0, $1);", new Object[]{this.id, i18n.toJson()});
    }

    public PivotTableI18n getI18n() {
        return this.i18n;
    }

    public static enum PivotMode {
        INTERACTIVE,
        NONINTERACTIVE;

    }

    public static abstract class AbstractPivotData
    implements Serializable {
        LinkedHashMap<String, Class<?>> columns = new LinkedHashMap();
        List<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();

        public void addColumn(String name, Class<?> type) {
            if (type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Double.class) || type.isAssignableFrom(Integer.class) || type.isAssignableFrom(String.class)) {
                this.columns.put(name, type);
            } else {
                this.columns.put(name, String.class);
            }
        }

        public void addRow(Map<String, Object> row) {
            assert (row.keySet().stream().allMatch(key -> this.columns.containsKey(key))) : "Column key missing from configured columns.";
            this.rows.add(row);
        }

        String toJson() {
            ObjectMapper mapper = MAPPER;
            ArrayNode array = mapper.createArrayNode();
            this.rows.forEach(row -> {
                ObjectNode obj = mapper.createObjectNode();
                this.columns.forEach((name, type) -> {
                    Object value = row.get(name);
                    if (value == null) {
                        obj.putNull(name);
                    } else if (type.isAssignableFrom(Boolean.class)) {
                        obj.put(name, (Boolean)value);
                    } else if (type.isAssignableFrom(Double.class)) {
                        obj.put(name, (Double)value);
                    } else if (type.isAssignableFrom(Integer.class)) {
                        obj.put(name, Double.valueOf(((Integer)value).intValue()));
                    } else if (type.isAssignableFrom(String.class)) {
                        obj.put(name, value.toString());
                    } else {
                        obj.put(name, value.toString());
                    }
                });
                array.add((JsonNode)obj);
            });
            return array.toString();
        }
    }

    public static class PivotOptions
    implements Serializable {
        List<String> cols;
        List<String> rows;
        List<String> disabledRerenders;
        String renderer;
        String aggregator;
        String column;
        boolean charts;
        boolean fieldsDisabled;

        public void setCols(String ... cols) {
            this.cols = Arrays.asList(cols);
        }

        public void setRows(String ... rows) {
            this.rows = Arrays.asList(rows);
        }

        public void setDisabledRenderers(String ... renderers) {
            this.disabledRerenders = Arrays.asList(renderers);
        }

        public void setRenderer(String renderer) {
            this.renderer = renderer;
        }

        public void setAggregator(String aggregator, String column) {
            this.aggregator = aggregator;
            this.column = column;
        }

        public void setFieldsDisabled(boolean fieldsDisabled) {
            this.fieldsDisabled = fieldsDisabled;
        }

        public void setCharts(boolean charts) {
            this.charts = charts;
        }

        String toJson() {
            ObjectMapper mapper = MAPPER;
            ObjectNode object = mapper.createObjectNode();
            if (this.cols != null) {
                ArrayNode colsArray = object.putArray("cols");
                this.cols.forEach(arg_0 -> ((ArrayNode)colsArray).add(arg_0));
            }
            if (this.rows != null) {
                ArrayNode rowsArray = object.putArray("rows");
                this.rows.forEach(arg_0 -> ((ArrayNode)rowsArray).add(arg_0));
            }
            return object.toString();
        }
    }

    @DomEvent(value="pivot-refreshed")
    public static class PivotRefreshedEvent<R extends PivotTable>
    extends ComponentEvent<PivotTable> {
        public PivotRefreshedEvent(PivotTable source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    public static class PivotTableI18n
    implements Serializable {
        Map<String, String> texts;

        public PivotTableI18n(Map<String, String> texts) {
            Objects.requireNonNull(texts, "Map of localized texts cannot be null");
            this.texts = texts;
        }

        String toJson() {
            ObjectMapper mapper = MAPPER;
            ArrayNode textArray = mapper.createArrayNode();
            this.texts.forEach((key, text) -> {
                ObjectNode textObj = mapper.createObjectNode();
                textObj.put("key", key);
                textObj.put("text", text);
                textArray.add((JsonNode)textObj);
            });
            return textArray.toString();
        }
    }

    public static class JsonPivotData
    extends AbstractPivotData {
        private String json;

        public JsonPivotData(String json) {
            this.json = json;
        }

        @Override
        public String toJson() {
            return this.json;
        }
    }

    public static class PivotData
    extends AbstractPivotData {
        public void addRow(Object ... datas) {
            if (datas.length != this.columns.size()) {
                throw new IllegalArgumentException("Number of datas do not match with number of columns.");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            int i = 0;
            for (String key : this.columns.keySet()) {
                map.put(key, datas[i]);
                ++i;
            }
            this.addRow(map);
        }
    }

    public static class BeanPivotData<T>
    extends AbstractPivotData {
        PropertySet<T> propertySet;

        public BeanPivotData(Class<T> beanType, Collection<T> data) {
            this.propertySet = BeanPropertySet.get(beanType);
            this.propertySet.getProperties().filter(property -> !property.isSubProperty()).sorted((prop1, prop2) -> prop1.getName().compareTo(prop2.getName())).forEach(prop -> this.addColumn(prop.getName(), prop.getType()));
            data.forEach(item -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                this.propertySet.getProperties().filter(property -> !property.isSubProperty()).sorted((prop1, prop2) -> prop1.getName().compareTo(prop2.getName())).forEach(prop -> map.put(prop.getName(), prop.getGetter().apply(item)));
                this.addRow(map);
            });
        }
    }

    public final class Aggregator {
        public static final String COUNT = "Count";
        public static final String COUNT_UNIQUE_VALUES = "Count Unique Values";
        public static final String LIST_UNIQUE_VALUES = "List Unique Values";
        public static final String SUM = "Sum";
        public static final String INTEGER_SUM = "Integer Sum";
        public static final String AVERAGE = "Average";
        public static final String MEDIAN = "Median";
        public static final String SAMPLE_VARIANCE = "Sample Variance";
        public static final String SAMPLE_STANDARD_DEVIATION = "Sample Standard Deviation";
        public static final String MINIMUM = "Minimum";
        public static final String MAXIMUM = "Maximum";
        public static final String FIRST = "First";
        public static final String LAST = "Last";
        public static final String SUM_OVER_SUM = "Sum over Sum";
        public static final String UPPER_BOUND = "80% Upper Bound";
        public static final String LOWER_BOUND = "80% Lower Bound";
        public static final String SUM_FRACTION_OF_TOTAL = "Sum as Fraction of Total";
        public static final String SUM_FRACTION_OF_ROWS = "Sum as Fraction of Rows";
        public static final String SUM_FRACTION_OF_COLS = "Sum as Fraction of Columns";
        public static final String COUNT_FRACTION_OF_TOTAL = "Count as Fraction of Total";
        public static final String COUNT_FRACTION_OF_ROWS = "Count as Fraction of Rows";
        public static final String COUNT_FRACTION_OF_COLS = "Count as Fraction of Columns";

        public Aggregator(PivotTable this$0) {
        }
    }

    public final class Renderer {
        public static final String TABLE = "Table";
        public static final String TABLE_BARCHART = "Table Barchart";
        public static final String TABLE_HEATMAP = "Heatmap";
        public static final String ROW_HEATMAP = "Row Heatmap";
        public static final String COL_HEATMAP = "Col Heatmap";
        public static final String HORIZONTAL_BAR_CHART = "Horizontal Bar Chart";
        public static final String HORIZONTAL_STACKED_BAR_CHART = "Horizontal Stacked Bar Chart";
        public static final String BAR_CHART = "Bar Chart";
        public static final String STACKED_BAR_CHART = "Stacked Bar Chart";
        public static final String LINE_CHART = "Line Chart";
        public static final String AREA_CHART = "Area Chart";
        public static final String SCATTER_CHART = "Scatter Chart";
        public static final String TSV_EXPORT = "TSV Export";

        public Renderer(PivotTable this$0) {
        }
    }
}

