/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.componentfactory;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import java.io.Serializable;

@Tag(value="paper-slider")
@NpmPackage(value="@polymer/paper-slider", version="3.0.1")
@JsModule(value="@polymer/paper-slider/paper-slider.js")
@CssImport(value="./paper-slider.css")
class PaperSliderComponent
extends AbstractSinglePropertyField<PaperSliderComponent, Integer>
implements HasSize,
HasTheme,
Focusable<PaperSliderComponent> {
    public PaperSliderComponent() {
        this(0);
    }

    public PaperSliderComponent(Integer defaultValue) {
        super("value", (Object)defaultValue, true);
        this.getElement().executeJs("this.$.sliderContainer.style.marginLeft = 'var(--lumo-space-xs)'", new Serializable[0]);
        this.getElement().executeJs("this.$.sliderKnob.addEventListener('click', function() { $0.$server.setMinValueIfClickedInitially();})", new Serializable[]{this.getElement()});
    }

    @ClientCallable
    public void setMinValueIfClickedInitially() {
        if ((Integer)this.getValue() < this.getMin()) {
            this.setValue(this.getMin());
        }
    }

    public void setMin(int min) {
        this.getElement().setProperty("min", (double)min);
        this.getElement().setProperty("secondaryProgress", (double)min);
    }

    public int getMin() {
        return this.getElement().getProperty("min", 0);
    }

    public void setMax(int max) {
        this.getElement().setProperty("max", (double)max);
    }

    public int getMax() {
        return this.getElement().getProperty("max", 0);
    }

    public void setSecondaryProgress(int secondary) {
        this.getElement().setProperty("secondaryProgress", (double)secondary);
    }

    public int getSecondaryProgress() {
        return this.getElement().getProperty("secondaryProgress", 0);
    }

    public void setPinned(boolean pin) {
        this.getElement().setAttribute("pin", pin);
    }

    public boolean isPinned() {
        return this.getElement().getAttribute("pin") != null;
    }

    public void setSnaps(boolean snaps) {
        this.getElement().setAttribute("snaps", snaps);
    }

    public boolean hasSnaps() {
        return this.getElement().getProperty("snaps", false);
    }

    public void setMaxMarkers(int markers) {
        this.getElement().setProperty("maxMarkers", (double)markers);
    }

    public int setMaxMarkers() {
        return this.getElement().getProperty("maxMarkers", 0);
    }
}

