/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.componentfactory;

import com.vaadin.flow.component.BlurNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.FocusNotifier;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.dependency.CssImport;
import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vaadin.addons.componentfactory.PaperSliderComponent;
import org.vaadin.addons.componentfactory.PaperSliderVariant;

@CssImport(value="./paper-slider-field.css")
public class PaperSlider
extends CustomField<Integer> {
    PaperSliderComponent slider = new PaperSliderComponent();
    private Integer emptyValue = 0;

    public PaperSlider() {
        this(null);
    }

    public PaperSlider(String label) {
        this.setLabel(label);
        this.addClassName("paper-slider");
        this.slider.setWidth("100%");
        this.add(new Component[]{this.slider});
        this.slider.addFocusListener((ComponentEventListener & Serializable)e -> this.fireEvent((ComponentEvent)new FocusNotifier.FocusEvent((Component)this, e.isFromClient(), Boolean.valueOf(e.isFromClient()))));
        this.slider.addBlurListener((ComponentEventListener & Serializable)e -> this.fireEvent((ComponentEvent)new BlurNotifier.BlurEvent((Component)this, e.isFromClient(), Boolean.valueOf(e.isFromClient()))));
        this.setMin(0);
        this.setMax(100);
    }

    public void setMin(int min) {
        this.slider.setMin(min);
    }

    public int getMin() {
        return this.slider.getMin();
    }

    public void setMax(int max) {
        this.slider.setMax(max);
    }

    public int getMax() {
        return this.slider.getMax();
    }

    public void setSecondaryProgress(int secondary) {
        if (secondary < this.getMin() || secondary > this.getMax()) {
            throw new IllegalArgumentException("Value " + secondary + " is not in min " + this.getMin() + " - max " + this.getMax() + " range");
        }
        this.slider.setSecondaryProgress(secondary);
    }

    public int getSecondaryProgress() {
        return this.slider.getSecondaryProgress();
    }

    public void setPinned(boolean pin) {
        this.slider.setPinned(pin);
    }

    public void isPinned(boolean pin) {
        this.slider.isPinned();
    }

    public void setSnaps(boolean snaps) {
        this.slider.setSnaps(snaps);
    }

    public boolean hasSnaps() {
        return this.slider.hasSnaps();
    }

    public void setMaxMarkers(int markers) {
        if (markers < 0 || markers > this.getMax() - this.getMin()) {
            throw new IllegalArgumentException("Value " + markers + " is not in min 0 - " + (this.getMax() - this.getMin()) + " range");
        }
        this.slider.setMaxMarkers(markers);
    }

    public int getMaxMarkers() {
        return this.slider.setMaxMarkers();
    }

    protected Integer generateModelValue() {
        return (Integer)this.slider.getValue();
    }

    protected void setPresentationValue(Integer value) {
        this.slider.setValue(value);
    }

    public void setValue(Integer value) {
        if (value == null) {
            value = 0;
        }
        if (value < this.getMin() || value > this.getMax()) {
            throw new IllegalArgumentException("Value " + value + " is not in min " + this.getMin() + " - max " + this.getMax() + " range");
        }
        super.setValue((Object)value);
        this.slider.setValue(value);
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.getElement().setAttribute("readonly", readOnly);
        this.slider.getElement().setAttribute("disabled", readOnly);
    }

    public void addThemeVariants(PaperSliderVariant ... variants) {
        this.slider.getThemeNames().addAll((Collection)Stream.of(variants).map(PaperSliderVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(PaperSliderVariant ... variants) {
        this.slider.getThemeNames().removeAll((Collection)Stream.of(variants).map(PaperSliderVariant::getVariantName).collect(Collectors.toList()));
    }

    public void setEmptyValue(Integer emptyValue) {
        this.emptyValue = emptyValue;
    }

    public Integer getEmptyValue() {
        return this.emptyValue;
    }

    public void focus() {
        this.slider.focus();
    }

    public void blur() {
        this.slider.blur();
    }
}

