/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.componentfactory;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.binder.HasDataProvider;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.vaadin.addons.componentfactory.AbstractComboBox;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.JsonNodeFactory;
import tools.jackson.databind.node.ObjectNode;

public class ComboBoxLight<T>
extends AbstractComboBox<ComboBoxLight<T>, T>
implements HasSize,
HasValidation,
HasDataProvider<T>,
HasHelper {
    private DataProvider<T, ?> dataProvider = new DataCommunicator.EmptyDataProvider();
    private Registration dataProviderListenerRegistration;
    private ItemLabelGenerator<T> itemLabelGenerator = String::valueOf;
    private final KeyMapper<T> keyMapper = new KeyMapper();
    private static final String PROP_AUTO_OPEN_DISABLED = "autoOpenDisabled";
    private static final String PROP_INPUT_ELEMENT_VALUE = "_inputElementValue";
    private int customValueListenersCount;
    private ComboBoxLightRenderManager<T> renderManager;
    private final CompositeDataGenerator<T> dataGenerator = new CompositeDataGenerator();
    private boolean autoselect = true;
    private boolean resetAfterChange = true;

    private static <T> T presentationToModel(ComboBoxLight<T> comboBox, String presentation) {
        KeyMapper<T> keyMapper = comboBox.getKeyMapper();
        if (presentation == null || keyMapper == null) {
            return (T)comboBox.getEmptyValue();
        }
        return (T)keyMapper.get(presentation);
    }

    private static <T> String modelToPresentation(ComboBoxLight<T> comboBox, T model) {
        KeyMapper<T> keyMapper = comboBox.getKeyMapper();
        if (model == null || keyMapper == null) {
            return null;
        }
        return keyMapper.key(model);
    }

    public ComboBoxLight() {
        super(null, null, String.class, ComboBoxLight::presentationToModel, ComboBoxLight::modelToPresentation, true);
        this.setItemValuePath("key");
        this.setItemIdPath("key");
        this.renderManager = new ComboBoxLightRenderManager(this);
        super.addCustomValueSetListener((ComponentEventListener & Serializable)e -> this.getElement().setProperty(PROP_INPUT_ELEMENT_VALUE, e.getDetail()));
        super.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.updateSelectedKey());
        this.addFilterChangeListener((ComponentEventListener & Serializable)e -> {
            if (e.isFromClient() && e.getFilter() != null && !e.getFilter().isEmpty() && this.getDataProvider() instanceof BackEndDataProvider) {
                this.reset();
            }
        });
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (!this.resetAfterChange || !e.isFromClient()) {
                return;
            }
            if (this.dataProvider instanceof BackEndDataProvider) {
                this.setFilter("");
                this.reset();
                if (e.getValue() == null) {
                    return;
                }
                if (this.keyMapper.has(e.getValue())) {
                    this.getElement().executeJs("return 0;", new Serializable[0]).then((SerializableConsumer & Serializable)res -> this.updateSelectedKey());
                }
            }
        });
    }

    private void updateSelectedKey() {
        Object value = this.getValue();
        this.getElement().setProperty("value", value != null && this.keyMapper.has(value) ? this.keyMapper.key(value) : "");
    }

    public void setItemLabelGenerator(ItemLabelGenerator<T> itemLabelGenerator) {
        Objects.requireNonNull(itemLabelGenerator, "The item label generator can not be null");
        this.itemLabelGenerator = itemLabelGenerator;
        this.reset();
    }

    public ItemLabelGenerator<T> getItemLabelGenerator() {
        return this.itemLabelGenerator;
    }

    private void reset() {
        String key;
        Object object;
        this.keyMapper.removeAll();
        this.dataGenerator.destroyAllData();
        String filter = this.getFilterString();
        DataProvider<T, ?> dataProvider = this.getDataProvider();
        Query query = filter == null || filter.trim().isEmpty() ? new Query() : new Query((Object)filter.trim());
        List<String> items = dataProvider.fetch(query).map(arg_0 -> this.keyMapper.key(arg_0)).toList();
        JsonNodeFactory factory = JsonNodeFactory.instance;
        ArrayNode jsonItems = factory.arrayNode();
        for (String string : items) {
            ObjectNode object2 = factory.objectNode();
            object2.put("key", string);
            object2.put("label", this.getItemLabelGenerator().apply(this.keyMapper.get(string)));
            this.dataGenerator.generateData(this.keyMapper.get(string), object2);
            jsonItems.add((JsonNode)object2);
        }
        this.getElement().setPropertyJson("items", (BaseJsonNode)jsonItems);
        if (this.autoselect && dataProvider instanceof BackEndDataProvider && items.size() == 1 && (object = this.keyMapper.get(key = items.getFirst())) != null) {
            this.setModelValue(object, true);
        }
        if (dataProvider instanceof BackEndDataProvider) {
            this.setFilter(filter);
        }
        if (!(dataProvider instanceof BackEndDataProvider)) {
            this.updateSelectedKey();
        }
    }

    public void setAutoOpen(boolean autoOpen) {
        this.getElement().setProperty(PROP_AUTO_OPEN_DISABLED, !autoOpen);
    }

    public boolean isAutoOpen() {
        return !this.getElement().getProperty(PROP_AUTO_OPEN_DISABLED, false);
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        super.setAutofocus(autofocus);
    }

    public boolean isAutofocus() {
        return this.isAutofocusBoolean();
    }

    @Override
    public void setPreventInvalidInput(boolean preventInvalidInput) {
        super.setPreventInvalidInput(preventInvalidInput);
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return this.getLabelString();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public String getErrorMessage() {
        return super.getErrorMessageString();
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    public boolean isInvalid() {
        return super.isInvalidBoolean();
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public void setClearButtonVisible(boolean clearButtonVisible) {
        this.getElement().setProperty("clearButtonVisible", clearButtonVisible);
    }

    public boolean isClearButtonVisible() {
        return this.getElement().getProperty("clearButtonVisible", false);
    }

    @Override
    public void setOpened(boolean opened) {
        super.setOpened(opened);
    }

    public boolean isOpened() {
        return this.isOpenedBoolean();
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    public String getPlaceholder() {
        return this.getPlaceholderString();
    }

    @Override
    public void setPattern(String pattern) {
        super.setPattern(pattern);
    }

    public String getPattern() {
        return this.getPatternString();
    }

    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        this.dataProvider = Objects.requireNonNull(dataProvider, "Data provider must not be null");
        this.keyMapper.setIdentifierGetter(arg_0 -> dataProvider.getId(arg_0));
        this.reset();
        this.renderManager.scheduleRender();
        this.setupDataProviderListener(dataProvider);
    }

    private void setupDataProviderListener(DataProvider<T, ?> dataProvider) {
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
        }
        this.dataProviderListenerRegistration = dataProvider.addDataProviderListener((DataProviderListener & Serializable)event -> this.reset());
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.getDataProvider() != null && this.dataProviderListenerRegistration == null) {
            this.setupDataProviderListener(this.getDataProvider());
        }
    }

    public DataProvider<T, ?> getDataProvider() {
        return this.dataProvider;
    }

    protected void onDetach(DetachEvent detachEvent) {
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
            this.dataProviderListenerRegistration = null;
        }
        super.onDetach(detachEvent);
    }

    @Override
    public void setAllowCustomValue(boolean allowCustomValue) {
        super.setAllowCustomValue(allowCustomValue);
    }

    public boolean isAllowCustomValue() {
        return this.isAllowCustomValueBoolean();
    }

    @Override
    public Registration addCustomValueSetListener(ComponentEventListener<AbstractComboBox.CustomValueSetEvent<ComboBoxLight<T>>> listener) {
        this.setAllowCustomValue(true);
        ++this.customValueListenersCount;
        Registration registration = super.addCustomValueSetListener(listener);
        return new CustomValueRegistration(registration);
    }

    public void setRenderer(Renderer<T> renderer) {
        Objects.requireNonNull(renderer, "The renderer must not be null");
        this.renderManager.setRenderer(renderer);
    }

    public void setDisableBackendAutoselect(boolean disableBackendAutoslect) {
        this.autoselect = !disableBackendAutoslect;
    }

    public void setDisableResetAfterChange(boolean disableResetAfterChange) {
        this.resetAfterChange = !disableResetAfterChange;
    }

    protected CompositeDataGenerator<T> getDataGenerator() {
        return this.dataGenerator;
    }

    protected KeyMapper<T> getKeyMapper() {
        return this.keyMapper;
    }

    class ComboBoxLightRenderManager<T>
    implements Serializable {
        private final ComboBoxLight<T> comboBox;
        private Renderer<T> renderer;
        private boolean renderScheduled;
        private final List<Registration> renderingRegistrations = new ArrayList<Registration>();

        ComboBoxLightRenderManager(ComboBoxLight<T> comboBox) {
            this.comboBox = comboBox;
        }

        void setRenderer(Renderer<T> renderer) {
            Objects.requireNonNull(renderer, "The renderer must not be null");
            this.renderer = renderer;
            this.scheduleRender();
        }

        void scheduleRender() {
            if (this.renderScheduled || this.renderer == null) {
                return;
            }
            this.renderScheduled = true;
            ComboBoxLight.this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
                this.render();
                this.renderScheduled = false;
            });
        }

        private void render() {
            this.renderingRegistrations.forEach(Registration::remove);
            this.renderingRegistrations.clear();
            Rendering rendering = this.renderer.render(this.comboBox.getElement(), ComboBoxLight.this.keyMapper);
            rendering.getDataGenerator().ifPresent(renderingDataGenerator -> {
                Registration renderingDataGeneratorRegistration = this.comboBox.getDataGenerator().addDataGenerator(renderingDataGenerator);
                this.renderingRegistrations.add(renderingDataGeneratorRegistration);
            });
            this.renderingRegistrations.add(rendering.getRegistration());
            ComboBoxLight.this.reset();
        }
    }

    private class CustomValueRegistration
    implements Registration {
        private Registration delegate;

        private CustomValueRegistration(Registration delegate) {
            this.delegate = delegate;
        }

        public void remove() {
            if (this.delegate != null) {
                this.delegate.remove();
                --ComboBoxLight.this.customValueListenersCount;
                if (ComboBoxLight.this.customValueListenersCount == 0) {
                    ComboBoxLight.this.setAllowCustomValue(false);
                }
                this.delegate = null;
            }
        }
    }
}

