/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.autoselectcombobox;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import java.io.Serializable;
import java.util.Collection;

@Tag(value="vcf-auto-select-combo-box")
@NpmPackage(value="@vaadin-component-factory/vcf-auto-select-combobox", version="24.1.0")
@JsModule(value="@vaadin-component-factory/vcf-auto-select-combobox/src/vcf-auto-select-combobox.js")
public class AutoSelectComboBox<T>
extends ComboBox<T> {
    public AutoSelectComboBox() {
        this.init();
    }

    public AutoSelectComboBox(int pageSize) {
        super(pageSize);
        this.init();
    }

    public AutoSelectComboBox(String label, Collection<T> items) {
        super(label, items);
        this.init();
    }

    public AutoSelectComboBox(String label, T ... items) {
        super(label, (Object[])items);
        this.init();
    }

    public AutoSelectComboBox(String label) {
        super(label);
        this.init();
    }

    private void init() {
        this.addCustomValueSetListener((ComponentEventListener & Serializable)e -> {
            this.setValue(null);
            this.getElement().executeJs("this.inputElement.value = $0;", new Serializable[]{e.getDetail()});
        });
    }

    public void setInvalid(boolean invalid) {
        this.getElement().setProperty("invalidExternal", invalid);
    }

    public void setAllowCustomValue(boolean allowCustomValue) {
        if (allowCustomValue) {
            super.setAllowCustomValue(true);
            return;
        }
        throw new UnsupportedOperationException("AutoSelectComboBox does not support custom values. Please remove the call to comboBox.setAllowCustomValue(..)");
    }
}

