/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.clock;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vaadin.addons.clock.ClockVariant;

@Tag(value="vaadin-clock")
@JsModule(value="./vaadin-clock/vaadin-clock.js")
public class Clock
extends AbstractSinglePropertyField<Clock, LocalTime>
implements Focusable<Clock>,
HasAriaLabel,
HasSize,
HasStyle,
HasTheme {
    private static final SerializableFunction<String, LocalTime> PARSER = (SerializableFunction & Serializable)valueFromClient -> valueFromClient == null || valueFromClient.isEmpty() ? null : LocalTime.parse(valueFromClient);
    private static final SerializableFunction<LocalTime, String> FORMATTER = (SerializableFunction & Serializable)valueFromModel -> valueFromModel == null ? "" : valueFromModel.toString();
    private LocalTime min;
    private LocalTime max;
    private Duration step;

    public Clock() {
        this((LocalTime)null);
    }

    public Clock(LocalTime time) {
        super("value", null, String.class, PARSER, FORMATTER);
        if (time != null) {
            this.setValue(time);
        }
    }

    public Clock(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<Clock, LocalTime>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public Clock(LocalTime time, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<Clock, LocalTime>> listener) {
        this(time);
        this.addValueChangeListener(listener);
    }

    public void setLabel(String label) {
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    public String getLabel() {
        return this.getElement().getProperty("label");
    }

    public void setAriaLabel(String ariaLabel) {
        this.getElement().setProperty("accessibleName", ariaLabel);
    }

    public Optional<String> getAriaLabel() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleName"));
    }

    public void setAriaLabelledBy(String labelledBy) {
        this.getElement().setProperty("accessibleNameRef", labelledBy);
    }

    public Optional<String> getAriaLabelledBy() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleNameRef"));
    }

    public void setValue(LocalTime value) {
        if (value != null) {
            value = value.truncatedTo(ChronoUnit.SECONDS);
        }
        super.setValue((Object)value);
    }

    public LocalTime getValue() {
        return (LocalTime)super.getValue();
    }

    public void setMin(LocalTime min) {
        this.min = min;
        String minString = min != null ? min.toString() : "";
        this.getElement().setProperty("min", minString);
    }

    public LocalTime getMin() {
        return this.min;
    }

    public void setMax(LocalTime max) {
        this.max = max;
        String maxString = max != null ? max.toString() : "";
        this.getElement().setProperty("max", maxString);
    }

    public LocalTime getMax() {
        return this.max;
    }

    public void setDisabled(boolean disabled) {
        this.getElement().setProperty("disabled", disabled);
    }

    public boolean isDisabled() {
        return this.getElement().getProperty("disabled", false);
    }

    public void setReadonly(boolean readonly) {
        this.getElement().setProperty("readonly", readonly);
    }

    public boolean isReadonly() {
        return this.getElement().getProperty("readonly", false);
    }

    public void setAdjustable(boolean adjustable) {
        this.getElement().setProperty("adjustable", adjustable);
    }

    public boolean isAdjustable() {
        return this.getElement().getProperty("adjustable", true);
    }

    public void setStep(Duration step) {
        Objects.requireNonNull(step, "Step cannot be null");
        if (step.isNegative() || step.isZero()) {
            throw new IllegalArgumentException("Step must be a positive duration");
        }
        long daySeconds = 86400L;
        long stepSeconds = step.toSeconds();
        if (daySeconds % stepSeconds != 0L) {
            throw new IllegalArgumentException("Step must evenly divide a day");
        }
        this.step = step;
        this.getElement().setProperty("step", (double)stepSeconds);
    }

    public Duration getStep() {
        return this.step;
    }

    public void setClockSize(String size) {
        Objects.requireNonNull(size, "Size cannot be null");
        this.getElement().getStyle().set("--vaadin-clock-size", size);
    }

    public void setRunning(boolean running) {
        boolean wasRunning = this.isRunning();
        this.getElement().setProperty("running", running);
        if (wasRunning && !running) {
            this.getElement().executeJs("return this.getValue()", new Serializable[0]).then(String.class, (SerializableConsumer & Serializable)currentValue -> {
                if (currentValue != null && !currentValue.isEmpty()) {
                    LocalTime time = LocalTime.parse(currentValue);
                    this.setModelValue(time, false);
                }
            });
        }
    }

    public boolean isRunning() {
        return this.getElement().getProperty("running", false);
    }

    public void addThemeVariants(ClockVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(ClockVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(ClockVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(ClockVariant::getVariantName).collect(Collectors.toList()));
    }
}

