/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.antlerflow.tour;

import com.google.gson.Gson;
import com.vaadin.flow.component.Component;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.vaadin.addons.antlerflow.tour.TourStep;

public interface TourEngine {
    public static final Gson GSON = new Gson();

    public String getId();

    default public void start(Component host, List<TourStep> steps, Map<Object, Object> options) {
        try {
            host.getUI().ifPresentOrElse(ui -> ui.getPage().executeJs("return window.AntlerTour.start($0, JSON.parse($1), JSON.parse($2));", new Serializable[]{this.getId(), GSON.toJson((Object)steps), GSON.toJson((Object)options)}), () -> {
                throw new IllegalStateException("Component must be attached to a UI");
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public void cancel(Component host) {
        try {
            host.getUI().ifPresentOrElse(ui -> ui.getPage().executeJs("return window.AntlerTour.cancel();", new Serializable[0]), () -> {
                throw new IllegalStateException("Component must be attached to a UI");
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public void wireEvents(Component host) {
        host.getUI().ifPresent(ui -> ui.getPage().executeJs("window.AntlerTour.on('complete', () => $0.$server.onCompleted());\nwindow.AntlerTour.on('cancel', () => $0.$server.onCanceled());\n", new Serializable[]{host.getElement()}));
    }
}

