/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.antlerflow.tour;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.shared.Registration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.vaadin.addons.antlerflow.tour.EngineType;
import org.vaadin.addons.antlerflow.tour.TourEngine;
import org.vaadin.addons.antlerflow.tour.TourStep;
import org.vaadin.addons.antlerflow.tour.events.TourCanceledEvent;
import org.vaadin.addons.antlerflow.tour.events.TourCompletedEvent;

@Tag(value="antler-tour")
@JsModule(value="./antlerflow/tour/core/tour-facade.ts")
public class Tour
extends Component {
    private List<TourStep> steps;
    private boolean showCancelButton;
    private boolean allowClose;
    private final Map<Object, Object> options;
    private EngineType engineType;
    private TourEngine engine;

    public void start() {
        this.engine = this.findEngine(this.engineType).orElseThrow(() -> new IllegalStateException("Tour engine not found: " + this.engineType.getId()));
        this.engine.wireEvents(this);
        this.engine.start(this, this.steps, this.unifyOptions());
    }

    public void cancel() {
        if (this.engine == null) {
            return;
        }
        this.engine.cancel(this);
    }

    public Registration addTourCanceledListener(ComponentEventListener<TourCanceledEvent> listener) {
        return this.addListener(TourCanceledEvent.class, listener);
    }

    public Registration addTourCompletedListener(ComponentEventListener<TourCompletedEvent> listener) {
        return this.addListener(TourCompletedEvent.class, listener);
    }

    @ClientCallable
    private void onCanceled() {
        this.fireEvent(new TourCanceledEvent(this, false));
    }

    @ClientCallable
    private void onCompleted() {
        this.fireEvent(new TourCompletedEvent(this, false));
    }

    private Optional<TourEngine> findEngine(EngineType engineType) {
        return Optional.ofNullable(engineType).map(EngineType::getEngineInstance);
    }

    private Map<Object, Object> unifyOptions() {
        HashMap<Object, Object> unifiedOptions = new HashMap<Object, Object>(this.options);
        unifiedOptions.put("showCancelButton", this.showCancelButton);
        unifiedOptions.put("allowClose", this.allowClose);
        return unifiedOptions;
    }

    @Generated
    private static List<TourStep> $default$steps() {
        return new ArrayList<TourStep>();
    }

    @Generated
    private static boolean $default$showCancelButton() {
        return true;
    }

    @Generated
    private static boolean $default$allowClose() {
        return false;
    }

    @Generated
    private static Map<Object, Object> $default$options() {
        return new HashMap<Object, Object>();
    }

    @Generated
    private static EngineType $default$engineType() {
        return EngineType.DRIVER;
    }

    @Generated
    Tour(List<TourStep> steps, boolean showCancelButton, boolean allowClose, Map<Object, Object> options, EngineType engineType, TourEngine engine) {
        this.steps = steps;
        this.showCancelButton = showCancelButton;
        this.allowClose = allowClose;
        this.options = options;
        this.engineType = engineType;
        this.engine = engine;
    }

    @Generated
    public static TourBuilder builder() {
        return new TourBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tour)) {
            return false;
        }
        Tour other = (Tour)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isShowCancelButton() != other.isShowCancelButton()) {
            return false;
        }
        if (this.isAllowClose() != other.isAllowClose()) {
            return false;
        }
        List<TourStep> this$steps = this.getSteps();
        List<TourStep> other$steps = other.getSteps();
        if (this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps)) {
            return false;
        }
        Map<Object, Object> this$options = this.getOptions();
        Map<Object, Object> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        EngineType this$engineType = this.getEngineType();
        EngineType other$engineType = other.getEngineType();
        if (this$engineType == null ? other$engineType != null : !((Object)((Object)this$engineType)).equals((Object)other$engineType)) {
            return false;
        }
        TourEngine this$engine = this.getEngine();
        TourEngine other$engine = other.getEngine();
        return !(this$engine == null ? other$engine != null : !this$engine.equals(other$engine));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Tour;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShowCancelButton() ? 79 : 97);
        result = result * 59 + (this.isAllowClose() ? 79 : 97);
        List<TourStep> $steps = this.getSteps();
        result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
        Map<Object, Object> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        EngineType $engineType = this.getEngineType();
        result = result * 59 + ($engineType == null ? 43 : ((Object)((Object)$engineType)).hashCode());
        TourEngine $engine = this.getEngine();
        result = result * 59 + ($engine == null ? 43 : $engine.hashCode());
        return result;
    }

    @Generated
    public List<TourStep> getSteps() {
        return this.steps;
    }

    @Generated
    public boolean isShowCancelButton() {
        return this.showCancelButton;
    }

    @Generated
    public boolean isAllowClose() {
        return this.allowClose;
    }

    @Generated
    public Map<Object, Object> getOptions() {
        return this.options;
    }

    @Generated
    public EngineType getEngineType() {
        return this.engineType;
    }

    @Generated
    public TourEngine getEngine() {
        return this.engine;
    }

    @Generated
    public void setSteps(List<TourStep> steps) {
        this.steps = steps;
    }

    @Generated
    public void setShowCancelButton(boolean showCancelButton) {
        this.showCancelButton = showCancelButton;
    }

    @Generated
    public void setAllowClose(boolean allowClose) {
        this.allowClose = allowClose;
    }

    @Generated
    public void setEngineType(EngineType engineType) {
        this.engineType = engineType;
    }

    @Generated
    public void setEngine(TourEngine engine) {
        this.engine = engine;
    }

    @Generated
    public String toString() {
        return "Tour(steps=" + String.valueOf(this.getSteps()) + ", showCancelButton=" + this.isShowCancelButton() + ", allowClose=" + this.isAllowClose() + ", options=" + String.valueOf(this.getOptions()) + ", engineType=" + String.valueOf((Object)this.getEngineType()) + ", engine=" + String.valueOf(this.getEngine()) + ")";
    }

    @Generated
    public static class TourBuilder {
        @Generated
        private boolean steps$set;
        @Generated
        private List<TourStep> steps$value;
        @Generated
        private boolean showCancelButton$set;
        @Generated
        private boolean showCancelButton$value;
        @Generated
        private boolean allowClose$set;
        @Generated
        private boolean allowClose$value;
        @Generated
        private boolean options$set;
        @Generated
        private Map<Object, Object> options$value;
        @Generated
        private boolean engineType$set;
        @Generated
        private EngineType engineType$value;
        @Generated
        private TourEngine engine;

        @Generated
        TourBuilder() {
        }

        @Generated
        public TourBuilder steps(List<TourStep> steps) {
            this.steps$value = steps;
            this.steps$set = true;
            return this;
        }

        @Generated
        public TourBuilder showCancelButton(boolean showCancelButton) {
            this.showCancelButton$value = showCancelButton;
            this.showCancelButton$set = true;
            return this;
        }

        @Generated
        public TourBuilder allowClose(boolean allowClose) {
            this.allowClose$value = allowClose;
            this.allowClose$set = true;
            return this;
        }

        @Generated
        public TourBuilder options(Map<Object, Object> options) {
            this.options$value = options;
            this.options$set = true;
            return this;
        }

        @Generated
        public TourBuilder engineType(EngineType engineType) {
            this.engineType$value = engineType;
            this.engineType$set = true;
            return this;
        }

        @Generated
        public TourBuilder engine(TourEngine engine) {
            this.engine = engine;
            return this;
        }

        @Generated
        public Tour build() {
            List<TourStep> steps$value = this.steps$value;
            if (!this.steps$set) {
                steps$value = Tour.$default$steps();
            }
            boolean showCancelButton$value = this.showCancelButton$value;
            if (!this.showCancelButton$set) {
                showCancelButton$value = Tour.$default$showCancelButton();
            }
            boolean allowClose$value = this.allowClose$value;
            if (!this.allowClose$set) {
                allowClose$value = Tour.$default$allowClose();
            }
            Map<Object, Object> options$value = this.options$value;
            if (!this.options$set) {
                options$value = Tour.$default$options();
            }
            EngineType engineType$value = this.engineType$value;
            if (!this.engineType$set) {
                engineType$value = Tour.$default$engineType();
            }
            return new Tour(steps$value, showCancelButton$value, allowClose$value, options$value, engineType$value, this.engine);
        }

        @Generated
        public String toString() {
            return "Tour.TourBuilder(steps$value=" + String.valueOf(this.steps$value) + ", showCancelButton$value=" + this.showCancelButton$value + ", allowClose$value=" + this.allowClose$value + ", options$value=" + String.valueOf(this.options$value) + ", engineType$value=" + String.valueOf((Object)this.engineType$value) + ", engine=" + String.valueOf(this.engine) + ")";
        }
    }
}

