/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.antlerflow.grid.pagination;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.shared.Registration;
import lombok.Generated;

@Tag(value="af-paginator")
@JsModule(value="./antlerflow/advanced-grid/pagination/paginator.ts")
public class Paginator
extends Component {
    public static final String PAGE_CHANGE_EVENT = "page-change";

    @Synchronize(value={"page-change"})
    public int getPage() {
        return this.getElement().getProperty("page", 1);
    }

    public void setPage(int page) {
        this.gotoPage(page);
    }

    @Synchronize(value={"page-change"})
    public int getPageSize() {
        return this.getElement().getProperty("pageSize", 25);
    }

    public void setPageSize(int pageSize) {
        this.getElement().setProperty("pageSize", (double)pageSize);
    }

    public void gotoPage(int page) {
        this.getElement().callJsFunction("gotoPage", new Object[]{page});
    }

    @Synchronize(value={"page-change"})
    public String getPageSizeOptions() {
        return this.getElement().getProperty("pageSizeOptions");
    }

    public void setPageSizeOptions(String pageSizeOptions) {
        this.getElement().setProperty("pageSizeOptions", pageSizeOptions);
    }

    @Synchronize(value={"page-change"})
    public int getOffset() {
        int page = this.getPage();
        int pageSize = this.getPageSize();
        return Math.max(0, (page - 1) * pageSize);
    }

    @Synchronize(value={"page-change"})
    public long getTotalItems() {
        return this.getElement().getProperty("totalItems", 0);
    }

    public void setTotalItems(long totalItems) {
        this.getElement().setProperty("totalItems", (double)totalItems);
    }

    @Synchronize(value={"page-change"})
    public int getTotalPages() {
        return this.getElement().getProperty("totalPages", 0);
    }

    public void setTotalPages(int totalPages) {
        this.getElement().setProperty("totalPages", (double)totalPages);
    }

    public void setMaxButtons(int maxButtons) {
        this.getElement().setProperty("maxButtons", (double)maxButtons);
    }

    public void setHideEdges(boolean hideEdges) {
        this.getElement().setProperty("hideEdges", hideEdges);
    }

    public void showPageSize(boolean showPageSize) {
        this.getElement().setProperty("showPageSize", showPageSize);
    }

    public void showSummaryText(boolean showSummaryText) {
        this.getElement().setProperty("showSummaryText", showSummaryText);
    }

    public void showPageJump(boolean showPageJump) {
        this.getElement().setProperty("showPageJump", showPageJump);
    }

    public void setEnabled(boolean enabled) {
        this.getElement().setProperty("disabled", !enabled);
    }

    public Registration addPageChangeListener(ComponentEventListener<PageChangeEvent> listener) {
        return this.addListener(PageChangeEvent.class, listener);
    }

    @DomEvent(value="page-change")
    public static class PageChangeEvent
    extends ComponentEvent<Paginator> {
        private final int page;
        private final int pageSize;
        private final int totalPages;
        private final int offset;
        private final int limit;

        public PageChangeEvent(Paginator source, boolean fromClient, @EventData(value="event.detail.page") int page, @EventData(value="event.detail.pageSize") int pageSize, @EventData(value="event.detail.totalPages") int totalPages, @EventData(value="event.detail.offset") int offset, @EventData(value="event.detail.limit") int limit) {
            super((Component)source, fromClient);
            this.page = page;
            this.pageSize = pageSize;
            this.totalPages = totalPages;
            this.offset = offset;
            this.limit = limit;
        }

        @Generated
        public int getPage() {
            return this.page;
        }

        @Generated
        public int getPageSize() {
            return this.pageSize;
        }

        @Generated
        public int getTotalPages() {
            return this.totalPages;
        }

        @Generated
        public int getOffset() {
            return this.offset;
        }

        @Generated
        public int getLimit() {
            return this.limit;
        }
    }
}

