/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.antlerflow.grid.dataprovider;

import com.vaadin.flow.data.provider.AbstractBackEndDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.spring.data.VaadinSpringDataHelpers;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class SpringPageableDataProvider<T, F>
extends AbstractBackEndDataProvider<T, F> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringPageableDataProvider.class);
    private final BiFunction<Optional<F>, Pageable, Page<T>> dataSupplier;
    private volatile CacheEntry<T> cache;
    private volatile CountCacheEntry countCache;
    private volatile F filter;

    public SpringPageableDataProvider(BiFunction<Optional<F>, Pageable, Page<T>> dataSupplier) {
        this.dataSupplier = Objects.requireNonNull(dataSupplier, "dataSupplier");
    }

    public F getFilter() {
        return this.filter;
    }

    public void setFilter(F filter) {
        this.filter = filter;
        this.clearCache();
    }

    protected Stream<T> fetchFromBackEnd(Query<T, F> query) {
        return this.getCacheableResult(query).getContent().stream();
    }

    protected int sizeInBackEnd(Query<T, F> query) {
        long total = this.getCachedTotalElements(query);
        return total > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)total;
    }

    public void refreshAll() {
        this.clearCache();
        super.refreshAll();
    }

    private void clearCache() {
        this.cache = null;
        this.countCache = null;
    }

    private long getCachedTotalElements(Query<T, F> query) {
        String countKey = this.generateCountCacheKey(query);
        CountCacheEntry local = this.countCache;
        if (local != null && local.key().equals(countKey)) {
            log.debug("Loading total count from cache");
            return local.totalElements();
        }
        log.debug("Fetching total count from backend");
        long total = this.getCacheableResult(query).getTotalElements();
        this.countCache = new CountCacheEntry(countKey, total);
        return total;
    }

    private Page<T> getCacheableResult(Query<T, F> query) {
        String key = this.generateCacheKey(query);
        CacheEntry<T> local = this.cache;
        if (local != null && local.key().equals(key)) {
            log.debug("Loading data from cache");
            return local.page();
        }
        log.debug("Fetching data from backend");
        Page<T> page = this.dataSupplier.apply(this.getEffectiveFilter(query), this.toSpringPageable(query));
        this.cache = new CacheEntry<T>(key, page);
        long total = page == null ? 0L : page.getTotalElements();
        this.countCache = new CountCacheEntry(this.generateCountCacheKey(query), total);
        return page;
    }

    private Optional<F> getEffectiveFilter(Query<T, F> query) {
        return Optional.ofNullable(query.getFilter().orElse(this.filter));
    }

    private Pageable toSpringPageable(Query<T, F> query) {
        return VaadinSpringDataHelpers.toSpringPageRequest(query);
    }

    private String generateCacheKey(Query<T, F> query) {
        String rawKey = "p=" + query.getPage() + ";ps=" + query.getPageSize() + ";f=" + this.stableString(this.getEffectiveFilter(query).orElse(null)) + ";sort=" + this.stableSortString(query.getSortOrders());
        return this.hashToUrlSafeBase64(rawKey);
    }

    private String generateCountCacheKey(Query<T, F> query) {
        String rawKey = "f=" + this.stableString(this.getEffectiveFilter(query).orElse(null)) + ";sort=" + this.stableSortString(query.getSortOrders());
        return this.hashToUrlSafeBase64(rawKey);
    }

    protected String stableSortString(List<QuerySortOrder> sortOrders) {
        if (sortOrders == null || sortOrders.isEmpty()) {
            return "";
        }
        return sortOrders.stream().map(so -> (String)so.getSorted() + ":" + String.valueOf(so.getDirection())).collect(Collectors.joining(","));
    }

    protected String stableString(Object o) {
        return o == null ? "" : String.valueOf(o);
    }

    private String hashToUrlSafeBase64(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(input.getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
        }
        catch (Exception e) {
            return input;
        }
    }

    private record CacheEntry<T>(String key, Page<T> page) {
        private CacheEntry {
            Objects.requireNonNull(key, "key");
            page = page == null ? Page.empty() : page;
        }
    }

    private record CountCacheEntry(String key, long totalElements) {
        private CountCacheEntry {
            Objects.requireNonNull(key, "key");
        }
    }
}

