/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.antlerflow.grid;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.vaadin.addons.antlerflow.grid.exporter.GridExportConfig;
import org.vaadin.addons.antlerflow.grid.exporter.GridExportHandler;
import org.vaadin.addons.antlerflow.grid.exporter.xdevsoftware.XDEVSoftwareGridExportHandler;
import org.vaadin.addons.antlerflow.grid.pagination.Paginator;

@Tag(value="af-advanced-grid")
@JsModule(value="./antlerflow/advanced-grid/advanced-grid.ts")
public class AdvancedGrid<T>
extends Component
implements HasComponents,
HasSize,
HasStyle {
    private Grid<T> innerGrid;
    private Paginator paginator;
    private GridExportConfig<T> exportConfig;
    private GridExportHandler<T> exportHandler = new XDEVSoftwareGridExportHandler();
    private SortedSet<Integer> pageSizes = new TreeSet<Integer>(List.of(Integer.valueOf(25), Integer.valueOf(50), Integer.valueOf(100)));
    private DataProvider<T, ?> externalDataProvider;
    private DataProvider<T, ?> originalInnerGridDataProvider;
    private boolean paginated = false;
    private final List<Registration> registrations = new ArrayList<Registration>();
    private Button exportButton;

    public AdvancedGrid() {
        this(new Grid());
    }

    public AdvancedGrid(Grid<T> grid) {
        this.initPagination();
        this.setInnerGrid(grid);
    }

    public AdvancedGrid(DataProvider<T, Void> dataProvider) {
        this(new Grid(dataProvider));
    }

    public AdvancedGrid(BackEndDataProvider<T, Void> dataProvider) {
        this(new Grid(dataProvider));
    }

    public AdvancedGrid(InMemoryDataProvider<T> inMemoryDataProvider) {
        this(new Grid(inMemoryDataProvider));
    }

    public AdvancedGrid(ListDataProvider<T> dataProvider) {
        this(new Grid(dataProvider));
    }

    public AdvancedGrid(Collection<T> items) {
        this(new Grid(items));
    }

    public AdvancedGrid(int pageSize) {
        this(new Grid(pageSize));
    }

    public AdvancedGrid(Class<T> beanType, boolean autoCreateColumns) {
        this(new Grid(beanType, autoCreateColumns));
    }

    public AdvancedGrid(Class<T> beanType) {
        this(beanType, true);
    }

    private void initPagination() {
        this.paginator = new Paginator();
        this.paginator.setVisible(false);
        this.paginator.getElement().setAttribute("slot", "paginator");
        this.setPageSizes(this.pageSizes.toArray(new Integer[0]));
        this.paginator.addPageChangeListener((ComponentEventListener<Paginator.PageChangeEvent>)(ComponentEventListener & Serializable)e -> this.refreshGridData());
        this.add(new Component[]{this.paginator});
    }

    public void setInnerGrid(Grid<T> innerGrid) {
        Objects.requireNonNull(innerGrid, "grid must not be null");
        if (this.innerGrid != null) {
            this.innerGrid.getElement().removeAttribute("slot");
            this.innerGrid.removeFromParent();
        }
        this.innerGrid = innerGrid;
        this.innerGrid.setSizeFull();
        this.innerGrid.getElement().setAttribute("slot", "grid");
        this.originalInnerGridDataProvider = this.innerGrid.getDataProvider();
        this.innerGrid.addSortListener((ComponentEventListener & Serializable)e -> this.resetPagination());
        this.registerDataProviderListeners(this.getBaseDataProvider());
        this.recalcTotalItems();
        this.refreshGridData();
        this.add(new Component[]{this.innerGrid});
    }

    private void resetPagination() {
        this.paginator.setPage(1);
        this.refreshGridData();
    }

    public void setItems(List<T> items) {
        Objects.requireNonNull(items, "items must not be null");
        this.setDataProvider((DataProvider<T, ?>)new ListDataProvider(items));
    }

    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        Objects.requireNonNull(dataProvider, "dataProvider must not be null");
        this.externalDataProvider = dataProvider;
        this.registerDataProviderListeners(dataProvider);
        if (!this.paginated) {
            this.innerGrid.setDataProvider(dataProvider);
        }
        this.recalcTotalItems();
        this.resetPagination();
    }

    private void registerDataProviderListeners(DataProvider<T, ?> dataProvider) {
        this.clearRegistrations();
        if (dataProvider != null) {
            this.registrations.add(dataProvider.addDataProviderListener((DataProviderListener & Serializable)e -> this.resetPagination()));
        }
    }

    private void clearRegistrations() {
        this.registrations.forEach(Registration::remove);
        this.registrations.clear();
    }

    private void recalcTotalItems() {
        if (!this.paginated) {
            return;
        }
        DataProvider<T, ?> base = this.getBaseDataProvider();
        if (base == null) {
            this.paginator.setTotalItems(0L);
            return;
        }
        Query<T, Object> query = this.buildQuery(this.paginator.getOffset(), this.paginator.getPageSize());
        this.paginator.setTotalItems(base.size(query));
    }

    public void setPageSizes(Integer ... pageSizes) {
        this.pageSizes = new TreeSet<Integer>(List.of(pageSizes));
        this.paginator.setPageSizeOptions(this.pageSizes.stream().map(String::valueOf).collect(Collectors.joining(",")));
    }

    public void setPageSize(int pageSize) {
        if (!this.pageSizes.contains(pageSize)) {
            this.pageSizes.add(pageSize);
            this.setPageSizes(this.pageSizes.toArray(new Integer[0]));
        }
        this.innerGrid.setPageSize(pageSize);
        this.paginator.setPageSize(pageSize);
        this.resetPagination();
    }

    public void enableExport(boolean exportEnabled) {
        if (exportEnabled) {
            if (this.exportButton == null) {
                this.exportButton = new Button((Component)VaadinIcon.DOWNLOAD.create());
                this.exportButton.getElement().setAttribute("slot", "export");
                this.exportButton.addClickListener((ComponentEventListener & Serializable)event -> this.exportHandler.handleExport(this.innerGrid, this.getBaseDataProvider(), this.exportConfig));
                this.add(new Component[]{this.exportButton});
            }
        } else if (this.exportButton != null) {
            this.exportButton.removeFromParent();
            this.exportButton = null;
        }
    }

    public void setPaginationVisibility(boolean visibility) {
        this.paginated = visibility;
        this.paginator.setVisible(visibility);
        if (!visibility) {
            this.restoreBaseDataProviderToGrid();
        } else {
            this.resetPagination();
        }
    }

    public void addToFilters(Component ... components) {
        for (Component c : components) {
            c.getElement().setAttribute("slot", "filter");
            this.add(new Component[]{c});
        }
    }

    public void addToActions(Component ... components) {
        for (Component c : components) {
            c.getElement().setAttribute("slot", "action");
            this.add(new Component[]{c});
        }
    }

    public void addToFooter(Component ... components) {
        for (Component c : components) {
            c.getElement().setAttribute("slot", "footer");
            this.add(new Component[]{c});
        }
    }

    private void refreshGridData() {
        DataProvider<T, ?> base = this.getBaseDataProvider();
        if (base == null || this.innerGrid == null) {
            return;
        }
        if (!this.paginated) {
            this.restoreBaseDataProviderToGrid();
            this.recalcTotalItems();
            return;
        }
        int offset = this.paginator.getOffset();
        int limit = this.paginator.getPageSize();
        Query<T, Object> query = this.buildQuery(offset, limit);
        ListDataProvider pageProvider = DataProvider.fromStream((Stream)base.fetch(query));
        this.innerGrid.setDataProvider((DataProvider)pageProvider);
        this.recalcTotalItems();
    }

    private void restoreBaseDataProviderToGrid() {
        DataProvider<T, ?> base = this.getBaseDataProvider();
        if (base != null) {
            this.innerGrid.setDataProvider(base);
        }
    }

    private DataProvider<T, ?> getBaseDataProvider() {
        return this.externalDataProvider != null ? this.externalDataProvider : this.originalInnerGridDataProvider;
    }

    private Query<T, Object> buildQuery(int offset, int pageSize) {
        return this.innerGrid.getDataCommunicator().buildQuery(offset, pageSize);
    }

    @Generated
    public Grid<T> getInnerGrid() {
        return this.innerGrid;
    }

    @Generated
    public Paginator getPaginator() {
        return this.paginator;
    }

    @Generated
    public GridExportConfig<T> getExportConfig() {
        return this.exportConfig;
    }

    @Generated
    public void setExportConfig(GridExportConfig<T> exportConfig) {
        this.exportConfig = exportConfig;
    }

    @Generated
    public GridExportHandler<T> getExportHandler() {
        return this.exportHandler;
    }

    @Generated
    public void setExportHandler(GridExportHandler<T> exportHandler) {
        this.exportHandler = exportHandler;
    }

    @Generated
    public Button getExportButton() {
        return this.exportButton;
    }
}

