/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.antlerflow.grid.exporter.xdevsoftware;

import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.provider.DataProvider;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.vaadin.addons.antlerflow.grid.exporter.ExportSize;
import org.vaadin.addons.antlerflow.grid.exporter.GridExportConfig;
import org.vaadin.addons.antlerflow.grid.exporter.GridExportHandler;
import org.vaadin.addons.antlerflow.grid.exporter.xdevsoftware.XDEVSoftwareFormat;
import software.xdev.vaadin.grid_exporter.GridExportLocalizationConfig;
import software.xdev.vaadin.grid_exporter.GridExporter;
import software.xdev.vaadin.grid_exporter.GridExporterProvider;
import software.xdev.vaadin.grid_exporter.column.ColumnConfigurationBuilder;
import software.xdev.vaadin.grid_exporter.column.ColumnConfigurationHeaderResolvingStrategyBuilder;
import software.xdev.vaadin.grid_exporter.grid.GridDataExtractor;
import software.xdev.vaadin.grid_exporter.jasper.JasperGridExporterProvider;

public class XDEVSoftwareGridExportHandler<T>
implements GridExportHandler<T> {
    @Override
    public void handleExport(Grid<T> grid, DataProvider<T, ?> dataProvider, GridExportConfig<T> config) {
        Objects.requireNonNull(grid, "grid must not be null");
        GridExporter exporter = new GridExporter(grid).loadFromProvider(Objects.requireNonNull(this.getProvider(), "GridExporterProvider must not be null")).withColumnConfigurationBuilder(this.getColumnConfigurationBuilder());
        this.applyLocalization(exporter);
        this.applyConfig(exporter, grid, dataProvider, config);
        exporter.open();
    }

    protected GridExporterProvider getProvider() {
        return new JasperGridExporterProvider();
    }

    protected ColumnConfigurationBuilder getColumnConfigurationBuilder() {
        return new ColumnConfigurationBuilder().withColumnConfigHeaderResolvingStrategyBuilder(ColumnConfigurationHeaderResolvingStrategyBuilder::withVaadinInternalHeaderStrategy);
    }

    protected GridExportLocalizationConfig getLocalizationConfig() {
        return null;
    }

    private void applyLocalization(GridExporter<T> exporter) {
        Optional.ofNullable(this.getLocalizationConfig()).ifPresent(arg_0 -> exporter.withLocalizationConfig(arg_0));
    }

    private void applyConfig(GridExporter<T> exporter, Grid<T> grid, DataProvider<T, ?> dataProvider, GridExportConfig<T> config) {
        if (config == null) {
            return;
        }
        Optional.ofNullable(config.getFileName()).ifPresent(arg_0 -> exporter.withFileName(arg_0));
        Optional.ofNullable(config.getFormats()).map(formats -> formats.stream().map(XDEVSoftwareFormat::fromString).filter(Objects::nonNull).map(XDEVSoftwareFormat::getFormat).toList()).ifPresent(arg_0 -> exporter.withAvailableFormats(arg_0));
        Optional.ofNullable(config.getPreSelectedFormat()).map(XDEVSoftwareFormat::fromString).map(XDEVSoftwareFormat::getFormat).ifPresent(arg_0 -> exporter.withPreSelectedFormat(arg_0));
        Optional.ofNullable(config.getColumnFilter()).ifPresent(arg_0 -> exporter.withColumnFilter(arg_0));
        exporter.withGridDataExtractorSupplier(tGrid -> this.getGridDataExtractor((Grid<T>)tGrid, dataProvider, config));
    }

    protected GridDataExtractor<T> getGridDataExtractor(Grid<T> grid, final DataProvider<T, ?> dataProvider, final GridExportConfig<T> config) {
        if (config != null && config.getSize() == ExportSize.ALL) {
            Objects.requireNonNull(dataProvider, "dataProvider must not be null");
            return new GridDataExtractor<T>(this, grid){

                protected Stream<T> getSortedAndFilteredData(Grid<T> grid) {
                    int limit = Optional.ofNullable(config.getLimit()).orElse(Integer.MAX_VALUE);
                    return dataProvider.fetch(grid.getDataCommunicator().buildQuery(0, limit));
                }
            };
        }
        return new GridDataExtractor(grid);
    }
}

