/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.idle;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.parttio.vaadinjsloader.JSLoader;

public class Idle {
    private static final WeakHashMap<UI, Idle> UI_REGISTRATIONS = new WeakHashMap();
    public static final long DEFAULT_TIMEOUT = 5000L;
    private final List<UserInactiveListener> inactiveListeners = new CopyOnWriteArrayList<UserInactiveListener>();
    private final List<UserActiveListener> activeListeners = new CopyOnWriteArrayList<UserActiveListener>();
    private final WeakReference<UI> ui;
    private long timeout;
    private boolean updateCssClass;
    private DomListenerRegistration activeDomListener;
    private DomListenerRegistration inactiveDomListener;
    private final String jsSingletonName;

    public Idle(UI ui) throws IllegalArgumentException {
        this.checkNotTracked(ui);
        this.loadResources(ui);
        this.jsSingletonName = "window." + Idle.class.getCanonicalName().replace('.', '_') + "_instance";
        UI_REGISTRATIONS.put(ui, this);
        this.ui = new WeakReference<UI>(ui);
        this.trackUI(ui, 5000L);
    }

    protected void loadResources(UI ui) {
        JSLoader.loadJavaResource((UI)ui, Idle.class, (String)"idle-addon", (String[])new String[]{"idle.js", "idle.css"});
    }

    public Idle(UI ui, long timeoutMs) throws IllegalArgumentException {
        this(ui);
        this.setTimeout(timeoutMs);
    }

    public Idle(UI ui, long timeoutMs, boolean updateCssClass) throws IllegalArgumentException {
        this(ui);
        this.setTimeout(timeoutMs);
        this.setUpdateCss(updateCssClass);
    }

    public static Idle get(UI ui) {
        Objects.requireNonNull(ui, "UI must not be null");
        return UI_REGISTRATIONS.get(ui);
    }

    public static Idle track(UI ui) throws IllegalArgumentException {
        return new Idle(ui);
    }

    public static Idle track(UI ui, long timeoutMs) throws IllegalArgumentException {
        assert (ui != null);
        return new Idle(ui, timeoutMs);
    }

    public static Idle track(UI ui, long timeoutMs, boolean updateCssClass) throws IllegalArgumentException {
        assert (ui != null);
        return new Idle(ui, timeoutMs, updateCssClass);
    }

    protected void trackUI(UI ui, long timeout) {
        assert (ui != null);
        this.setTimeout(timeout);
        this.callInstanceMethod("register()");
    }

    private void callInstanceMethod(String methodCall) {
        UI ui = (UI)this.ui.get();
        if (ui != null) {
            ui.getElement().executeJs(this.jsSingletonName + "." + methodCall + ";", new Serializable[0]);
        }
    }

    protected void checkNotTracked(UI ui) throws IllegalArgumentException {
        assert (ui != null);
        if (UI_REGISTRATIONS.containsKey(ui)) {
            throw new IllegalArgumentException("This UI is already monitored by Idle");
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout >= 0L ? timeout : 0L;
        this.callInstanceMethod("setTimeout(%d)".formatted(this.timeout));
    }

    public boolean isUpdateCss() {
        return this.updateCssClass;
    }

    public void setUpdateCss(boolean updateCssClass) {
        this.updateCssClass = updateCssClass;
        this.callInstanceMethod("setUpdateCssClass(%b)".formatted(this.updateCssClass));
    }

    protected void fireUserActive() {
        this.activeListeners.forEach(l -> l.userActive(new UserActiveEvent(this)));
    }

    public Registration addUserActiveListener(UserActiveListener listener) {
        UI ui;
        this.activeListeners.add(listener);
        if (this.activeDomListener == null && (ui = (UI)this.ui.get()) != null) {
            this.activeDomListener = ui.getElement().addEventListener("user-active", (DomEventListener & Serializable)e -> this.fireUserActive());
        }
        return (Registration & Serializable)() -> {
            this.activeListeners.remove(listener);
            if (this.activeListeners.isEmpty()) {
                this.activeDomListener.remove();
                this.activeDomListener = null;
            }
        };
    }

    protected void fireUserInactive() {
        this.inactiveListeners.forEach(l -> l.userInactive(new UserInactiveEvent(this)));
    }

    public Registration addUserInactiveListener(UserInactiveListener listener) {
        UI ui;
        this.inactiveListeners.add(listener);
        if (this.inactiveDomListener == null && (ui = (UI)this.ui.get()) != null) {
            this.inactiveDomListener = ui.getElement().addEventListener("user-inactive", (DomEventListener & Serializable)e -> this.fireUserInactive());
        }
        return (Registration & Serializable)() -> {
            this.inactiveListeners.remove(listener);
            if (this.inactiveListeners.isEmpty()) {
                this.inactiveDomListener.remove();
                this.inactiveDomListener = null;
            }
        };
    }

    public void untrackUI() {
        UI ui = (UI)this.ui.get();
        this.callInstanceMethod("unregister()");
        UI_REGISTRATIONS.remove(ui);
        this.ui.clear();
    }

    @FunctionalInterface
    public static interface UserActiveListener
    extends Serializable {
        public void userActive(UserActiveEvent var1);
    }

    @FunctionalInterface
    public static interface UserInactiveListener
    extends Serializable {
        public void userInactive(UserInactiveEvent var1);
    }

    public static class UserInactiveEvent
    extends IdleEvent {
        public UserInactiveEvent(Idle idle) {
            super(idle);
        }
    }

    public static class UserActiveEvent
    extends IdleEvent {
        public UserActiveEvent(Idle idle) {
            super(idle);
        }
    }

    public static class IdleEvent
    extends EventObject {
        public IdleEvent(Idle idle) {
            super(idle);
        }

        public Idle getIdle() {
            return (Idle)this.getSource();
        }
    }
}

