/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addon.audio.shared;

import java.io.Serializable;

public class PCMFormat
implements Serializable {
    private final int numChannels;
    private final int sampleRate;
    private final int byteRate;
    private final int blockAlign;
    private final int bitsPerSample;

    public PCMFormat(int numChannels, int sampleRate, int bitsPerSample) {
        this.numChannels = numChannels;
        this.sampleRate = sampleRate;
        this.bitsPerSample = bitsPerSample;
        this.blockAlign = numChannels * (bitsPerSample / 8);
        this.byteRate = this.blockAlign * sampleRate;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getByteRate() {
        return this.byteRate;
    }

    public int getBlockAlign() {
        return this.blockAlign;
    }

    public int getSampleSize() {
        return this.blockAlign;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("numChannels: ").append(this.numChannels).append("\n\r");
        sb.append("sampleRate: ").append(this.sampleRate).append("\n\r");
        sb.append("byteRate: ").append(this.byteRate).append("\n\r");
        sb.append("blockAlign: ").append(this.blockAlign).append("\n\r");
        sb.append("bitsPerSample: ").append(this.bitsPerSample).append("\n\r");
        return sb.toString();
    }
}

