/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addon.audio.server.util;

import java.nio.ByteBuffer;
import org.vaadin.addon.audio.server.util.Endian;
import org.vaadin.addon.audio.shared.PCMFormat;

public final class WaveUtil {
    public static PCMFormat getDataFormat(ByteBuffer buf) {
        int channels = Endian.readLE(buf, 22, 2);
        int sampleRate = Endian.readLE(buf, 24, 4);
        int bitsPerSample = Endian.readLE(buf, 34, 2);
        return new PCMFormat(channels, sampleRate, bitsPerSample);
    }

    public static int getFmtChunkStart(ByteBuffer waveFileBytes) {
        return 12;
    }

    public static int getFmtChunkSize(ByteBuffer waveFileBytes) {
        return Endian.readLE(waveFileBytes, 16, 4);
    }

    public static int getDataChunkStart(ByteBuffer waveFileBytes) {
        return WaveUtil.getFmtChunkStart(waveFileBytes) + WaveUtil.getFmtChunkSize(waveFileBytes) + 8;
    }

    public static int getDataLength(ByteBuffer waveFileBytes) {
        int dataLengthByte = WaveUtil.getDataChunkStart(waveFileBytes) + 4;
        return Endian.readLE(waveFileBytes, dataLengthByte, 4);
    }

    public static int getDataStartOffset(ByteBuffer waveFileBytes) {
        return WaveUtil.getDataChunkStart(waveFileBytes) + 8;
    }

    public static byte[] generateHeader(PCMFormat format, int numSamples) {
        byte[] header = new byte[44];
        ByteBuffer buf = ByteBuffer.wrap(header);
        buf.position(0);
        buf.put((byte)82);
        buf.put((byte)73);
        buf.put((byte)70);
        buf.put((byte)70);
        buf.position(8);
        buf.put((byte)87);
        buf.put((byte)65);
        buf.put((byte)86);
        buf.put((byte)69);
        buf.position(12);
        buf.put((byte)102);
        buf.put((byte)109);
        buf.put((byte)116);
        buf.put((byte)32);
        Endian.writeLE(16, buf, 16, 4);
        Endian.writeLE(1, buf, 20, 2);
        Endian.writeLE(format.getNumChannels(), buf, 22, 2);
        Endian.writeLE(format.getSampleRate(), buf, 24, 4);
        Endian.writeLE(format.getByteRate(), buf, 28, 4);
        Endian.writeLE(format.getBlockAlign(), buf, 32, 2);
        Endian.writeLE(format.getBitsPerSample(), buf, 34, 2);
        buf.position(36);
        buf.put((byte)100);
        buf.put((byte)97);
        buf.put((byte)116);
        buf.put((byte)97);
        int dataSize = numSamples * format.getSampleSize();
        Endian.writeLE(dataSize, buf, 40, 4);
        Endian.writeLE(36 + dataSize, buf, 4, 4);
        return buf.array();
    }
}

