/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addon.audio.server.util;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.WebBrowser;

public class FeatureSupport {
    public static WebBrowser browser;

    public static boolean isAudioElementSupported() {
        browser = FeatureSupport.getBrowser();
        if (browser.isChrome()) {
            return browser.getBrowserMajorVersion() >= 3;
        }
        if (browser.isEdge()) {
            return true;
        }
        if (browser.isIE()) {
            return browser.getBrowserMajorVersion() >= 9;
        }
        if (browser.isFirefox()) {
            return browser.getBrowserMajorVersion() > 3 || browser.getBrowserMajorVersion() == 3 && browser.getBrowserMinorVersion() >= 5;
        }
        if (browser.isSafari()) {
            return browser.getBrowserMajorVersion() > 3 || browser.getBrowserMajorVersion() == 3 && browser.getBrowserMinorVersion() >= 1;
        }
        if (browser.isOpera()) {
            return browser.getBrowserMajorVersion() > 10 || browser.getBrowserMajorVersion() == 10 && browser.getBrowserMinorVersion() >= 5;
        }
        return false;
    }

    public static boolean isMp3Supported() {
        return FeatureSupport.isAudioElementSupported();
    }

    public static boolean isOggSupported() {
        browser = FeatureSupport.getBrowser();
        return FeatureSupport.isAudioElementSupported() && !browser.isSafari() && !browser.isIE();
    }

    private static WebBrowser getBrowser() {
        if (browser == null) {
            browser = UI.getCurrent().getSession().getBrowser();
        }
        return browser;
    }
}

