/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addon.audio.server.util;

import java.nio.ByteBuffer;

public final class Endian {
    public static int readLE(ByteBuffer buffer, int offset, int bytes) {
        assert (bytes > 0 && bytes < 5);
        int value = 0;
        int shift = 0;
        if (buffer != null) {
            for (int b = 0; b < bytes; ++b) {
                value |= (buffer.get(offset + b) & 0xFF) << shift;
                shift += 8;
            }
        }
        return value;
    }

    public static void writeLE(int value, ByteBuffer buffer, int offset, int bytes) {
        assert (bytes > 0 && bytes < 5);
        int shift = 0;
        for (int b = 0; b < bytes; ++b) {
            buffer.put(offset + b, (byte)(value >>> shift & 0xFF));
            shift += 8;
        }
    }

    public static int readBE(ByteBuffer buffer, int offset, int bytes) {
        assert (bytes > 0 && bytes < 5);
        int value = 0;
        int shift = (bytes - 1) * 8;
        for (int b = 0; b < bytes; ++b) {
            value |= (buffer.get(offset + b) & 0xFF) << shift;
            shift -= 8;
        }
        return value;
    }

    public static void writeBE(int value, ByteBuffer buffer, int offset, int bytes) {
        assert (bytes > 0 && bytes < 5);
        int shift = (bytes - 1) * 8;
        for (int b = 0; b < bytes; ++b) {
            buffer.put(offset + b, (byte)(value >>> shift & 0xFF));
            shift -= 8;
        }
    }
}

