/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addon.audio.server;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.vaadin.addon.audio.server.Encoder;
import org.vaadin.addon.audio.server.state.StreamState;
import org.vaadin.addon.audio.server.state.StreamStateCallback;
import org.vaadin.addon.audio.shared.ChunkDescriptor;
import org.vaadin.addon.audio.shared.PCMFormat;

public class Stream {
    private static final int CHUNK_LENGTH_MILLIS_DEFAULT = 5000;
    private static final int CHUNK_OVERLAP_MILLIS = 0;
    private List<StreamStateCallback> stateCallbacks = new ArrayList<StreamStateCallback>();
    private List<ChunkDescriptor> chunks = new ArrayList<ChunkDescriptor>();
    private PCMFormat format = null;
    private ByteBuffer buffer = null;
    private Encoder encoder = null;
    private StreamState streamState = StreamState.IDLE;
    private final int chunkLength;
    private final int chunkOverlapLength = 0;
    private boolean compression = false;
    private int sampleCount = 0;
    private int duration = 0;

    public Stream(ByteBuffer pcmBuffer, PCMFormat format, Encoder encoder) {
        this(pcmBuffer, format, encoder, 5000);
    }

    public Stream(ByteBuffer pcmBuffer, PCMFormat format, Encoder encoder, int millisPerChunk) {
        int to_sample;
        this.buffer = pcmBuffer;
        this.format = format;
        this.encoder = encoder;
        this.chunkLength = millisPerChunk;
        encoder.setInput(pcmBuffer, format);
        int buffersize = pcmBuffer.capacity();
        int samples = this.sampleCount = buffersize / format.getSampleSize();
        double samplesPerMillis = (double)format.getSampleRate() / 1000.0;
        this.duration = (int)((double)samples / samplesPerMillis);
        int chunkSampleSize = (int)(samplesPerMillis * (double)this.chunkLength);
        int chunkOverlapSampleSize = (int)(samplesPerMillis * 0.0);
        int chunk = 0;
        do {
            int from_sample = (int)((double)(chunk * this.chunkLength) * samplesPerMillis);
            from_sample = Math.max(0, from_sample);
            to_sample = (int)((double)((chunk + 1) * this.chunkLength + 0) * samplesPerMillis);
            to_sample = Math.min(samples, to_sample);
            int time_lead_in = (int)Math.max((double)(chunk * this.chunkLength) - (double)from_sample / samplesPerMillis, 0.0);
            int time_lead_out = (int)Math.max((double)to_sample / samplesPerMillis - (double)((chunk + 1) * this.chunkLength), 0.0);
            int time_start_offset = (int)((double)from_sample / samplesPerMillis + (double)time_lead_in);
            int time_end_offset = (int)((double)to_sample / samplesPerMillis - (double)time_lead_out);
            if (time_lead_out < 0) {
                time_end_offset = (int)((double)to_sample / samplesPerMillis);
                time_lead_out = 0;
            }
            ChunkDescriptor cd = new ChunkDescriptor();
            cd.setId(chunk);
            cd.setStartSampleOffset(from_sample);
            cd.setEndSampleOffset(to_sample);
            cd.setLeadInDuration(time_lead_in);
            cd.setLeadOutDuration(time_lead_out);
            cd.setStartTimeOffset(time_start_offset);
            cd.setEndTimeOffset(time_end_offset);
            cd.setOverlapTime(0);
            this.chunks.add(cd);
            ++chunk;
        } while (to_sample < samples);
        ChunkDescriptor cd = new ChunkDescriptor();
        cd.setId(0);
        cd.setStartSampleOffset(0);
        cd.setEndSampleOffset(Math.min(chunkSampleSize + chunkOverlapSampleSize, samples));
        cd.setLeadInDuration(0);
        cd.setLeadOutDuration(chunkOverlapSampleSize);
        cd.setStartTimeOffset(0);
        cd.setEndTimeOffset(this.chunkLength);
    }

    public void addStateChangeListener(StreamStateCallback cb) {
        this.stateCallbacks.add(cb);
    }

    public void removeStateChangeListener(StreamStateCallback cb) {
        this.stateCallbacks.remove(cb);
    }

    private void setStreamState(StreamState s) {
        if (this.streamState == s) {
            return;
        }
        this.streamState = s;
        for (StreamStateCallback cb : this.stateCallbacks) {
            cb.onStateChanged(s);
        }
    }

    public StreamState getState() {
        return this.streamState;
    }

    public int getChunkLength() {
        return this.chunkLength;
    }

    public List<ChunkDescriptor> getChunks() {
        return this.chunks;
    }

    public ByteBuffer getInputBuffer() {
        return this.buffer;
    }

    public PCMFormat getInputFormat() {
        return this.format;
    }

    public void setCompression(boolean enable) {
        this.compression = enable;
    }

    public boolean isCompressionEnabled() {
        return this.compression;
    }

    public void getChunkData(ChunkDescriptor chunk, Callback callback) {
        this.setStreamState(StreamState.READING);
        int startOffset = chunk.getStartSampleOffset();
        int endOffset = chunk.getEndSampleOffset();
        int length = endOffset - startOffset;
        this.setStreamState(StreamState.ENCODING);
        byte[] bytes = this.encoder.encode(startOffset, length);
        callback.onComplete(bytes);
        this.setStreamState(StreamState.IDLE);
    }

    public ChunkDescriptor findChunk(int position_millis) {
        for (ChunkDescriptor c : this.chunks) {
            if (c.getStartTimeOffset() < position_millis || c.getEndTimeOffset() > position_millis) continue;
            return c;
        }
        return null;
    }

    public ChunkDescriptor getChunkById(int chunkID) {
        ChunkDescriptor c = this.chunks.get(chunkID);
        return c;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getDurationString() {
        int days = this.duration / 1000 / 60 / 60 / 24;
        int hours = this.duration / 1000 / 60 / 60 % 24;
        int minutes = this.duration / 1000 / 60 % 60;
        int seconds = this.duration / 1000 % 60;
        int millis = this.duration % 1000;
        Object text = "";
        if (days > 0) {
            text = (String)text + days + "d";
        }
        if (hours > 0) {
            if (!((String)text).isEmpty()) {
                text = (String)text + ", ";
            }
            text = (String)text + hours + "h";
        }
        if (minutes > 0) {
            if (!((String)text).isEmpty()) {
                text = (String)text + ", ";
            }
            text = (String)text + minutes + "m";
        }
        if (seconds > 0) {
            if (!((String)text).isEmpty()) {
                text = (String)text + ", ";
            }
            text = (String)text + seconds + "s";
        }
        if (millis > 0) {
            if (!((String)text).isEmpty()) {
                text = (String)text + ", ";
            }
            text = (String)text + millis + "ms";
        }
        return text;
    }

    public static interface Callback {
        public void onComplete(byte[] var1);
    }
}

