/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addon.audio.server;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamRegistration;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.StreamResourceWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.vaadin.addon.audio.server.Effect;
import org.vaadin.addon.audio.server.Stream;
import org.vaadin.addon.audio.server.state.PlaybackState;
import org.vaadin.addon.audio.server.state.StateChangeCallback;
import org.vaadin.addon.audio.server.state.VolumeChangeCallback;
import org.vaadin.addon.audio.server.util.OnEndOfRange;
import org.vaadin.addon.audio.server.util.StringFormatter;
import org.vaadin.addon.audio.shared.ChunkDescriptor;
import org.vaadin.addon.audio.shared.SharedEffect;
import org.vaadin.addon.audio.shared.util.Log;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.JsonNodeFactory;
import tools.jackson.databind.node.ObjectNode;

@Tag(value="audio-player")
@JsModule(value="./audio-player.js")
public class AudioPlayer
extends Component {
    private Stream stream = null;
    private PlaybackState playbackState = PlaybackState.STOPPED;
    private int currentPosition = 0;
    private double volume = 1.0;
    private double[] channelVolumes = new double[0];
    private List<StreamRegistration> chunkRegistrations = new ArrayList<StreamRegistration>();
    private final List<StateChangeCallback> stateCallbacks = new ArrayList<StateChangeCallback>();
    private final List<VolumeChangeCallback> volumeCallbacks = new ArrayList<VolumeChangeCallback>();
    public int chunkTimeMillis;
    public int numChunksPreload;
    public int duration;
    public int reportPositionRepeatTime = 500;
    public final List<SharedEffect> effects = new ArrayList<SharedEffect>();
    public int startRange;
    public int endRange;
    public OnEndOfRange onEndOfRange;

    public AudioPlayer(Stream stream) {
        this.setupAudioPlayer(stream);
    }

    public AudioPlayer(Stream stream, int reportPositionRepeatTime) {
        this.reportPositionRepeatTime = reportPositionRepeatTime;
        this.setupAudioPlayer(stream);
    }

    private void setupAudioPlayer(Stream stream) {
        this.setStream(stream);
        this.getElement().setProperty("reportPositionRepeatTime", (double)this.reportPositionRepeatTime);
        this.setStartRange(0);
        this.setEndRange(this.duration);
        this.setOnEndOfRange(OnEndOfRange.STOP_POSITION_END);
    }

    @ClientCallable
    public void reportPlaybackPosition(int position_millis) {
        Log.message(this, "received position report: " + position_millis);
        if (position_millis != this.currentPosition) {
            this.currentPosition = position_millis;
            for (StateChangeCallback cb : this.stateCallbacks) {
                cb.playbackPositionChanged(position_millis);
            }
        }
    }

    @ClientCallable
    public void reportPlaybackStarted() {
        Log.message(this, "received playback state change to PLAYING");
        this.playbackState = PlaybackState.PLAYING;
        for (StateChangeCallback cb : this.stateCallbacks) {
            cb.playbackStateChanged(this.playbackState);
        }
    }

    @ClientCallable
    public void reportPlaybackPaused() {
        Log.message(this, "received playback state change to PAUSED");
        this.playbackState = PlaybackState.PAUSED;
        for (StateChangeCallback cb : this.stateCallbacks) {
            cb.playbackStateChanged(this.playbackState);
        }
    }

    @ClientCallable
    public void reportPlaybackStopped() {
        Log.message(this, "received playback state change to STOPPED");
        this.playbackState = PlaybackState.STOPPED;
        for (StateChangeCallback cb : this.stateCallbacks) {
            cb.playbackStateChanged(this.playbackState);
        }
    }

    @ClientCallable
    public void reportVolumeChange(double volume, double[] channelVolumes) {
        Log.message(this, "volume change reported from client");
        this.volume = volume;
        this.channelVolumes = channelVolumes;
        for (VolumeChangeCallback cb : this.volumeCallbacks) {
            cb.onVolumeChange(volume, channelVolumes);
        }
    }

    public void destroy() {
    }

    public Stream getStream() {
        return this.stream;
    }

    public Stream setStream(Stream stream) {
        this.unregisterStreamChunks();
        this.stream = stream;
        this.registerStreamChunks();
        ArrayNode chunksJson = new ArrayNode(JsonNodeFactory.instance);
        List<ChunkDescriptor> chunks = stream.getChunks();
        for (int i = 0; i < chunks.size(); ++i) {
            ChunkDescriptor chunk = chunks.get(i);
            ObjectNode chunkDescriptor = JsonNodeFactory.instance.objectNode();
            chunkDescriptor.put("id", chunk.getId());
            chunkDescriptor.put("startTimeOffset", chunk.getStartTimeOffset());
            chunkDescriptor.put("endTimeOffset", chunk.getEndTimeOffset());
            chunkDescriptor.put("leadInDuration", chunk.getLeadInDuration());
            chunkDescriptor.put("leadOutDuration", chunk.getLeadOutDuration());
            chunkDescriptor.put("overlapTime", chunk.getOverlapTime());
            chunkDescriptor.put("startSampleOffset", chunk.getStartSampleOffset());
            chunkDescriptor.put("endSampleOffset", chunk.getEndSampleOffset());
            chunkDescriptor.put("url", chunk.getUrl().toASCIIString());
            chunksJson.add((JsonNode)chunkDescriptor);
        }
        this.getElement().setPropertyJson("chunks", (BaseJsonNode)chunksJson);
        this.duration = stream.getDuration();
        this.getElement().setProperty("duration", (double)this.duration);
        this.chunkTimeMillis = stream.getChunkLength();
        this.getElement().setProperty("chunkTimeMillis", (double)this.chunkTimeMillis);
        return stream;
    }

    private void unregisterStreamChunks() {
        for (int i = 0; i < this.chunkRegistrations.size(); ++i) {
            this.chunkRegistrations.get(i).unregister();
        }
        this.chunkRegistrations.clear();
    }

    private void registerStreamChunks() {
        if (this.stream == null) {
            return;
        }
        List<ChunkDescriptor> chunks = this.stream.getChunks();
        for (int i = 0; i < chunks.size(); ++i) {
            this.registerChunkResource(chunks.get(i));
        }
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.stream != null && this.chunkRegistrations.isEmpty()) {
            this.registerStreamChunks();
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        this.unregisterStreamChunks();
    }

    private void registerChunkResource(ChunkDescriptor chunk) {
        StreamResource resource = new StreamResource("audio", (StreamResourceWriter & Serializable)(outputStream, session) -> this.stream.getChunkData(chunk, bytes -> {
            try {
                outputStream.write(bytes);
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException e) {
                Log.message(this, "could not register audio chunk with id: " + chunk.getId());
            }
        }));
        StreamResourceRegistry registry = UI.getCurrent().getSession().getResourceRegistry();
        StreamRegistration registration = registry.registerResource((AbstractStreamResource)resource);
        this.chunkRegistrations.add(registration);
        chunk.setUrl(registration.getResourceUri());
    }

    public int getDuration() {
        return this.stream.getDuration();
    }

    public int getPosition() {
        return this.currentPosition;
    }

    public void setPosition(int millis) {
        if (millis == this.currentPosition) {
            return;
        }
        this.currentPosition = millis;
        this.getElement().callJsFunction("setPlaybackPosition", new Object[]{millis});
        Log.message(this, "set playback position: " + millis);
    }

    public void skip(int millis) {
        Log.message(this, "skip " + millis + " milliseconds");
    }

    public void play() {
        this.getElement().callJsFunction("startPlayback", new Object[0]);
        Log.message(this, "start or restart playback");
    }

    public void play(int offset_millis) {
        Log.message(this, "start playback at time offset");
    }

    public void pause() {
        this.getElement().callJsFunction("pausePlayback", new Object[0]);
        Log.message(this, "pause playback");
    }

    public void resume() {
        this.getElement().callJsFunction("resumePlayback", new Object[0]);
        Log.message(this, "resume playback");
    }

    public void stop() {
        this.getElement().callJsFunction("stopPlayback", new Object[0]);
        Log.message(this, "stop playback");
    }

    public boolean isPlaying() {
        return this.playbackState == PlaybackState.PLAYING;
    }

    public boolean isPaused() {
        return this.playbackState == PlaybackState.PAUSED;
    }

    public boolean isStopped() {
        return this.playbackState == PlaybackState.STOPPED;
    }

    public void setVolume(double volume) {
        this.getElement().callJsFunction("setVolume", new Object[]{volume});
        Log.message(this, "setting volume to " + volume);
    }

    public void setVolumeOnChannel(double volume, int channel) {
        this.getElement().callJsFunction("setVolumeOnChannel", new Object[]{volume, channel});
        Log.message(this, "setting volume to " + volume + " on channel " + channel);
    }

    public double getVolume() {
        return this.volume;
    }

    public double getVolumeOnChannel(int channel) {
        if (this.channelVolumes.length > channel) {
            return this.channelVolumes[channel];
        }
        return -1.0;
    }

    public double getNumberOfChannels() {
        return this.channelVolumes.length;
    }

    public void setPlaybackSpeed(double playbackSpeed) {
        this.getElement().callJsFunction("setPlaybackSpeed", new Object[]{playbackSpeed});
        Log.message(this, "setting playback speed to " + playbackSpeed);
    }

    public void setBalance(double balance) {
        this.getElement().callJsFunction("setBalance", new Object[]{balance});
    }

    public void setNumberChunksToPreload(int numChunksPreload) {
    }

    public int getNumberChunksToPreload() {
        return this.numChunksPreload;
    }

    protected ChunkDescriptor getChunkDescriptor(int chunkId) {
        return null;
    }

    public String getPositionString() {
        return StringFormatter.msToPlayerTimeStamp(this.getPosition());
    }

    public String getDurationString() {
        return StringFormatter.msToPlayerTimeStamp(this.getDuration());
    }

    public int getStartRange() {
        return this.startRange;
    }

    public void setStartRange(int startRange) {
        if (startRange >= 0 && startRange < this.getDuration()) {
            this.startRange = startRange;
            this.getElement().setProperty("startRange", (double)startRange);
            Log.message(this, "setting start range to " + startRange);
        }
    }

    public int getEndRange() {
        return this.endRange;
    }

    public void setEndRange(int endRange) {
        if (endRange > 0 && endRange <= this.getDuration()) {
            this.endRange = endRange;
            this.getElement().setProperty("endRange", (double)endRange);
            Log.message(this, "setting end range to " + endRange);
        }
    }

    public OnEndOfRange getOnEndOfRange() {
        return this.onEndOfRange;
    }

    public void setOnEndOfRange(OnEndOfRange onEndOfRange) {
        this.onEndOfRange = onEndOfRange;
        this.getElement().setProperty("onEndOfRange", (double)onEndOfRange.getAction());
        Log.message(this, "setting action to do when reaching end of range to " + String.valueOf((Object)onEndOfRange));
    }

    public void addEffect(Effect effect) {
        this.effects.add(effect.getSharedEffectObject());
    }

    public void removeEffect(Effect effect) {
        for (SharedEffect e : this.effects) {
            if (!effect.getID().equals(e.getID())) continue;
            Log.message(this, "removing effect: " + e.getName().name());
            this.effects.remove(e);
        }
    }

    public void updateEffect(Effect effect) {
        for (SharedEffect e : this.effects) {
            if (!effect.getID().equals(e.getID())) continue;
            Log.message(this, "updating effect: " + e.getName().name());
            e.setProperties(effect.getSharedEffectObject().getProperties());
        }
    }

    public void addStateChangeListener(StateChangeCallback cb) {
        this.stateCallbacks.add(cb);
    }

    public void removeStateChangeListener(StateChangeCallback cb) {
        this.stateCallbacks.remove(cb);
    }

    public void addValueChangeListener(VolumeChangeCallback cb) {
        this.volumeCallbacks.add(cb);
    }

    public void removeValueChangeListener(VolumeChangeCallback cb) {
        this.volumeCallbacks.remove(cb);
    }
}

