/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.vaadin.component.login;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.rapidpm.dependencies.core.logger.HasLogger;
import org.rapidpm.vaadin.addons.framework.ComponentIDGenerator;

public abstract class LoginView
extends Composite<HorizontalLayout>
implements HasLogger {
    public static final String BTN_LOGIN_ID = (String)ComponentIDGenerator.buttonID().apply(LoginView.class, "btn-login");
    public static final String BTN_CANCEL_ID = (String)ComponentIDGenerator.buttonID().apply(LoginView.class, "btn-cancel");
    public static final String TF_USERNAME_ID = (String)ComponentIDGenerator.textfieldID().apply(LoginView.class, "tf-username");
    public static final String PF_PASSWORD_ID = (String)ComponentIDGenerator.passwordID().apply(LoginView.class, "pf-password");
    public static final String CB_REMEMBER_ME_ID = (String)ComponentIDGenerator.genericID().apply(LoginView.class, Checkbox.class, (Object)"cb-remember-me");
    private final TextField username = new TextField(){
        {
            this.setId(TF_USERNAME_ID);
            this.setPlaceholder("username");
        }
    };
    private final PasswordField password = new PasswordField(){
        {
            this.setId(PF_PASSWORD_ID);
            this.setRequired(true);
            this.setPlaceholder("password");
        }
    };
    private final Checkbox rememberMe = new Checkbox(){
        {
            this.setId(CB_REMEMBER_ME_ID);
            this.setLabel("remember me");
            this.setIndeterminate(false);
        }
    };
    private final Button btnLogin = new Button(){
        {
            this.setId(BTN_LOGIN_ID);
            this.setText("Login");
            this.addClickListener((ComponentEventListener & Serializable)e -> LoginView.this.validate());
        }
    };
    private final Button btnCancel = new Button(){
        {
            this.setId(BTN_CANCEL_ID);
            this.setText("Cancel");
            this.addClickListener((ComponentEventListener & Serializable)e -> LoginView.this.clearFields());
        }
    };
    private final VerticalLayout layout = new VerticalLayout(new Component[]{new HorizontalLayout(new Component[]{this.username, this.password}), this.rememberMe, new HorizontalLayout(new Component[]{this.btnLogin, this.btnCancel})}){
        {
            this.setDefaultHorizontalComponentAlignment(FlexComponent.Alignment.START);
            this.setSizeUndefined();
        }
    };

    public LoginView() {
        this.logger().info("setting now the login ui content..");
        HorizontalLayout wrappedLayout = (HorizontalLayout)this.getContent();
        wrappedLayout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
        wrappedLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        wrappedLayout.add(new Component[]{this.layout});
        wrappedLayout.setSizeFull();
    }

    private void clearFields() {
        this.username.clear();
        this.password.clear();
    }

    public String username() {
        return (String)this.username.getValue();
    }

    public String password() {
        return (String)this.password.getValue();
    }

    private void validate() {
        boolean isValid = this.checkCredentials();
        if (isValid) {
            this.logger().info("Login was accepted .. " + LocalDateTime.now());
            this.navigateToApp();
        } else {
            this.logger().warning("Login was not accepted .. " + LocalDateTime.now());
            this.reactOnFailedLogin();
        }
        this.clearFields();
    }

    public abstract void reactOnFailedLogin();

    public abstract void navigateToApp();

    public abstract boolean checkCredentials();
}

