/*
 * Decompiled with CFR 0.152.
 */
package org.mikotin.googlesignin;

import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.ui.LoadMode;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.mikotin.googlesignin.events.UserLoginEvent;
import org.mikotin.googlesignin.events.internal.InternalSignInEvent;
import org.mikotin.googlesignin.events.internal.InternalSignOutEvent;

@Tag(value="google-signin")
@HtmlImport(value="bower_components/google-signin/google-signin.html", loadMode=LoadMode.LAZY)
public class GoogleSignin
extends Component {
    private final GoogleIdTokenVerifier tokenVerifier;
    private String clientId;
    private Brand brand;
    private Width width;
    private Height height;
    private Theme theme;
    private boolean autoLogout = true;
    private List<Consumer<UserLoginEvent>> loginListeners;
    private List<Runnable> logoutListeners;

    public GoogleSignin(String clientId) {
        this.clientId = clientId;
        this.tokenVerifier = new GoogleIdTokenVerifier.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)JacksonFactory.getDefaultInstance()).setAudience(Collections.singleton(clientId)).build();
        this.loginListeners = new ArrayList<Consumer<UserLoginEvent>>();
        this.logoutListeners = new ArrayList<Runnable>();
        this.getElement().setProperty("clientId", clientId);
        this.setWidth(Width.WIDE);
        this.setHeight(Height.STANDARD);
        this.setBrand(Brand.GOOGLE);
        this.setTheme(Theme.DARK);
        this.addListener(InternalSignInEvent.class, this::handleLogin);
        this.addListener(InternalSignOutEvent.class, this::handleLogout);
    }

    private void handleLogin(InternalSignInEvent event) {
        try {
            GoogleIdToken idToken = this.tokenVerifier.verify(event.getIdToken());
            if (idToken != null) {
                GoogleIdToken.Payload payload = idToken.getPayload();
                String userId = payload.getSubject();
                String email = payload.getEmail();
                String name = (String)payload.get((Object)"name");
                String pictureUrl = (String)payload.get((Object)"picture");
                String locale = (String)payload.get((Object)"locale");
                String familyName = (String)payload.get((Object)"family_name");
                String givenName = (String)payload.get((Object)"given_name");
                UserLoginEvent userEvent = new UserLoginEvent(userId, email, name, pictureUrl, locale, givenName, familyName, event.getIdToken());
                this.fireEvent(userEvent);
                if (this.autoLogout) {
                    this.logout();
                }
            }
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void fireEvent(UserLoginEvent event) {
        this.loginListeners.forEach(consumer -> consumer.accept(event));
    }

    private void handleLogout(InternalSignOutEvent event) {
        if (!this.autoLogout) {
            this.logoutListeners.forEach(Runnable::run);
        }
    }

    public Registration addLoginListener(Consumer<UserLoginEvent> consumer) {
        this.loginListeners.add(consumer);
        return (Registration & Serializable)() -> this.loginListeners.remove(consumer);
    }

    public Registration addLogoutListener(Runnable action) {
        this.logoutListeners.add(action);
        return (Registration & Serializable)() -> this.logoutListeners.remove(action);
    }

    public void logout() {
        this.getElement().callFunction("signOut", new Serializable[0]);
    }

    public boolean isAutoLogout() {
        return this.autoLogout;
    }

    public void setAutoLogout(boolean autoLogout) {
        this.autoLogout = autoLogout;
    }

    public Brand getBrand() {
        return this.brand;
    }

    public void setBrand(Brand brand) {
        this.brand = brand;
        this.getElement().setProperty("brand", brand.getValue());
    }

    public Width getWidth() {
        return this.width;
    }

    public void setWidth(Width width) {
        this.width = width;
        this.getElement().setProperty("width", width.getValue());
    }

    public Height getHeight() {
        return this.height;
    }

    public void setHeight(Height height) {
        this.height = height;
        this.getElement().setProperty("height", height.getValue());
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
        this.getElement().setProperty("theme", theme.getValue());
    }

    public String getAppPackageName() {
        return this.getElement().getProperty("appPackageName");
    }

    public void setAppPackageName(String value) {
        this.getElement().setProperty("appPackageName", value);
    }

    public String getCookiePolicy() {
        return this.getElement().getProperty("cookiePolicy");
    }

    public void setCookiePolicy(String value) {
        this.getElement().setProperty("cookiePolicy", value);
    }

    public boolean getFill() {
        return this.getElement().getProperty("fill", true);
    }

    public void setFill(boolean value) {
        this.getElement().setProperty("fill", value);
    }

    public String getLabelAdditional() {
        return this.getElement().getProperty("labelAdditional");
    }

    public void setLabelAdditional(String value) {
        this.getElement().setProperty("labelAdditional", value);
    }

    public String getLabelSignin() {
        return this.getElement().getProperty("labelSignin");
    }

    public void setLabelSignin(String value) {
        this.getElement().setProperty("labelSignin", value);
    }

    public String getLabelSignout() {
        return this.getElement().getProperty("labelSignout");
    }

    public void setLabelSignout(String value) {
        this.getElement().setProperty("labelSignout", value);
    }

    public boolean getRaised() {
        return this.getElement().getProperty("raised", false);
    }

    public void setRaised(boolean value) {
        this.getElement().setProperty("raised", value);
    }

    public String getScopes() {
        return this.getElement().getProperty("scopes");
    }

    public void setScopes(String value) {
        this.getElement().setProperty("scopes", value);
    }

    public static enum Theme {
        DARK("dark"),
        LIGHT("light");

        private String value;

        private Theme(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Height {
        TALL("tall"),
        STANDARD("standard"),
        SHORT("short");

        private String value;

        private Height(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Width {
        WIDE("wide"),
        ICON("inconOnly");

        private String value;

        private Width(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Brand {
        GOOGLE("google"),
        GOOGLEPLUS("google-plus");

        private String value;

        private Brand(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

