/*
 * Decompiled with CFR 0.152.
 */
package de.f0rce.signaturepad;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.shared.Registration;
import de.f0rce.signaturepad.ImageEncode;
import de.f0rce.signaturepad.ValueChangedEvent;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

@Tag(value="lit-signature-pad")
@JsModule(value="./@f0rce/signature-widget.js")
@NpmPackage(value="signature_pad", version="4.1.5")
public class SignaturePad
extends Component
implements HasSize {
    private static final long serialVersionUID = -1080064546349497798L;
    private double dotSize;
    private double lineMinWidth = 0.5;
    private double lineMaxWidth = 2.5;
    private int throttle = 16;
    private int minDistance = 5;
    private String backgroundColor = "#ffffff";
    private String penColor = "#000000";
    private double velocityFilterWeight = 0.7;
    private String imageUri = "";
    private String type = "image/png";
    private boolean readOnly = false;
    private double encoderQuality = 0.85;
    private boolean isEmpty = true;
    private boolean clearButtonVisible = true;

    public SignaturePad() {
        super.addListener(ImageEncode.class, this::updateImage);
        this.setHeight("100px");
        this.setWidth("300px");
    }

    private void updateImage(ImageEncode event) {
        this.imageUri = event.getImage();
        this.type = event.getType();
        this.isEmpty = event.isEmpty();
        if (!this.imageUri.equals(event.getImage())) {
            this.fireEvent(new ValueChangedEvent((SignaturePad)event.getSource(), true, event.getImage(), event.getType(), event.isEmpty()));
        }
    }

    public void clear() {
        this.getElement().callJsFunction("clear", new Object[0]);
    }

    public void setDotSize(int dotSize) {
        double dotSizeD = dotSize;
        this.getElement().setProperty("dotSize", dotSizeD);
        this.dotSize = dotSizeD;
    }

    public void setDotSize(double dotSize) {
        this.getElement().setProperty("dotSize", dotSize);
        this.dotSize = dotSize;
    }

    public double getDotSize() {
        return this.dotSize;
    }

    public void setLineMinWidth(int lineMinWidth) {
        double lineMinWidthD = lineMinWidth;
        this.getElement().setProperty("minWidth", lineMinWidthD);
        this.lineMinWidth = lineMinWidthD;
    }

    public void setLineMinWidth(double lineMinWidth) {
        this.getElement().setProperty("minWidth", lineMinWidth);
        this.lineMinWidth = lineMinWidth;
    }

    public double getLineMinWidth() {
        return this.lineMinWidth;
    }

    public void setLineMaxWidth(int lineMaxWidth) {
        double lineMaxWidthD = lineMaxWidth;
        this.getElement().setProperty("maxWidth", lineMaxWidthD);
        this.lineMaxWidth = lineMaxWidthD;
    }

    public void setLineMaxWidth(double lineMaxWidth) {
        this.getElement().setProperty("maxWidth", lineMaxWidth);
        this.lineMaxWidth = lineMaxWidth;
    }

    public double getLineMaxWidth() {
        return this.lineMaxWidth;
    }

    public void setThrottle(int throttle) {
        this.getElement().setProperty("throttle", (double)throttle);
        this.throttle = throttle;
    }

    public int getThrottle() {
        return this.throttle;
    }

    public void setMinDistance(int minDistance) {
        this.getElement().setProperty("minDistance", (double)minDistance);
        this.minDistance = minDistance;
    }

    public int getMinDistance() {
        return this.minDistance;
    }

    public void setBackgroundColor(int red, int green, int blue) {
        String rgb = "rgb(" + red + ", " + green + ", " + blue + ")";
        this.getElement().setProperty("backgroundColor", rgb);
        this.backgroundColor = rgb;
    }

    public void setBackgroundColor(int red, int green, int blue, int alpha) {
        String rgba = "rgba(" + red + ", " + green + ", " + blue + ", " + alpha + ")";
        this.getElement().setProperty("backgroundColor", rgba);
        this.backgroundColor = rgba;
    }

    public void setBackgroundColor(String hex) {
        this.getElement().setProperty("backgroundColor", hex);
        this.backgroundColor = hex;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setPenColor(int red, int green, int blue) {
        String rgb = "rgb(" + red + ", " + green + ", " + blue + ")";
        this.getElement().setProperty("penColor", rgb);
        this.penColor = rgb;
    }

    public void setPenColor(String hex) {
        this.getElement().setProperty("penColor", hex);
        this.penColor = hex;
    }

    public String getPenColor() {
        return this.penColor;
    }

    public void setVelocityFilterWeight(int velocityFilterWeight) {
        double velocityFilterWeightD = velocityFilterWeight;
        this.getElement().getProperty("velocityFilterWeight", velocityFilterWeightD);
        this.velocityFilterWeight = velocityFilterWeightD;
    }

    public void setVelocityFilterWeight(double velocityFilterWeight) {
        this.getElement().getProperty("velocityFilterWeight", velocityFilterWeight);
        this.velocityFilterWeight = velocityFilterWeight;
    }

    public double getVelocityFilterWeight() {
        return this.velocityFilterWeight;
    }

    public String getImageURI() {
        return this.imageUri;
    }

    public byte[] getImageBase64() {
        if (this.imageUri.equals("")) {
            return null;
        }
        String split = this.imageUri.split(",")[1];
        return Base64.getDecoder().decode(split.getBytes(StandardCharsets.UTF_8));
    }

    public void setType(String type) {
        if (!type.contains("image/")) {
            type = "image/png";
        }
        this.getElement().setProperty("type", type);
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setReadOnly(boolean readOnly) {
        this.getElement().setProperty("readOnly", readOnly);
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setImage(String uri) {
        this.getElement().setProperty("img", uri);
        if (!this.imageUri.equals(uri)) {
            this.fireEvent(new ValueChangedEvent(this, false, uri, this.type, false));
        }
        this.imageUri = uri;
        this.isEmpty = false;
    }

    public void setEncoderQuality(double encoderQuality) {
        double x = Math.abs(encoderQuality);
        if (x > 1.0) {
            x = 1.0;
        }
        this.getElement().setProperty("encoderOptions", x);
        this.encoderQuality = x;
    }

    public double getEncoderQuality() {
        return this.encoderQuality;
    }

    public void undo() {
        this.getElement().callJsFunction("undo", new Object[0]);
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void setTransparentBackground() {
        this.getElement().setProperty("backgroundColor", "rgb(255, 255, 255)");
    }

    public void setClearButtonVisible(boolean clearButtonVisible) {
        this.getElement().setProperty("clearButtonVisible", clearButtonVisible);
        this.clearButtonVisible = clearButtonVisible;
    }

    public boolean isClearButtonVisible() {
        return this.clearButtonVisible;
    }

    public Registration addValueChangeListener(ComponentEventListener<ValueChangedEvent> listener) {
        return this.addListener(ValueChangedEvent.class, listener);
    }
}

