/*
 * Decompiled with CFR 0.152.
 */
package de.f0rce.ace.util;

import java.io.Serializable;
import tools.jackson.databind.JsonNode;

public class AceSelection
implements Serializable {
    private int startRow;
    private int startColumn;
    private int endRow;
    private int endColumn;
    private int startIndex;
    private int endIndex;
    private String selectedText;

    public AceSelection() {
        this.startRow = 0;
        this.startColumn = 0;
        this.endRow = 0;
        this.endColumn = 0;
        this.startIndex = 0;
        this.endIndex = 0;
        this.selectedText = "";
    }

    public AceSelection(JsonNode selectionObject) {
        JsonNode startObject = selectionObject.get("start");
        this.startRow = startObject.get("row").asInt();
        this.startColumn = startObject.get("column").asInt();
        JsonNode endObject = selectionObject.get("end");
        this.endRow = endObject.get("row").asInt();
        this.endColumn = endObject.get("column").asInt();
        JsonNode indexObject = selectionObject.get("index");
        this.startIndex = indexObject.get("start").asInt();
        this.endIndex = indexObject.get("end").asInt();
        this.selectedText = selectionObject.get("selectedText").asString();
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public String getSelectedText() {
        return this.selectedText;
    }

    public boolean compareTo(AceSelection a) {
        return a.getStartRow() == this.startRow && a.getStartColumn() == this.startColumn && a.getStartIndex() == this.startIndex && a.getEndRow() == this.endRow && a.getEndColumn() == this.endColumn && a.getEndIndex() == this.endIndex && a.getSelectedText().equals(this.selectedText);
    }
}

