/*
 * Decompiled with CFR 0.152.
 */
package de.f0rce.ace;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.shared.Registration;
import de.f0rce.ace.enums.AceExportType;
import de.f0rce.ace.enums.AceMarkerColor;
import de.f0rce.ace.enums.AceMode;
import de.f0rce.ace.enums.AceStatusbarIndexing;
import de.f0rce.ace.enums.AceTheme;
import de.f0rce.ace.events.AceBlurChanged;
import de.f0rce.ace.events.AceChanged;
import de.f0rce.ace.events.AceForceSyncDomEvent;
import de.f0rce.ace.events.AceForceSyncEvent;
import de.f0rce.ace.events.AceHTMLGeneratedEvent;
import de.f0rce.ace.events.AceReady;
import de.f0rce.ace.events.AceSelectionChanged;
import de.f0rce.ace.events.AceValueChanged;
import de.f0rce.ace.interfaces.IAceWordCompleter;
import de.f0rce.ace.util.AceCursorPosition;
import de.f0rce.ace.util.AceCustomMode;
import de.f0rce.ace.util.AceDynamicWordCompleter;
import de.f0rce.ace.util.AceJSON;
import de.f0rce.ace.util.AceMarker;
import de.f0rce.ace.util.AceSelection;
import de.f0rce.ace.util.AceStaticWordCompleter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import tools.jackson.databind.ObjectMapper;

@Tag(value="lit-ace")
@NpmPackage(value="@f0rce/lit-ace", version="1.11.1")
@JsModule(value="./@f0rce/lit-ace/lit-ace.js")
public class AceEditor
extends Component
implements HasSize,
HasStyle,
Focusable<AceEditor> {
    public static final String DEFAULT_STATIC_CATEGORY = "keyword";
    public static final String DEFAULT_DYNAMIC_CATEGORY = "dynamic";
    private AceTheme theme = AceTheme.eclipse;
    private AceMode mode = AceMode.javascript;
    private String value = "";
    private String baseUrl = "ace-builds/src-min-noconflict/";
    private int fontSize = 14;
    private boolean softTabs = true;
    private int tabSize = 4;
    private boolean wrap = false;
    private boolean autoComplete = false;
    private boolean initialFocus = false;
    private String placeHolder = "";
    private boolean readOnly = false;
    private boolean printMargin = false;
    private boolean showInvisibles = false;
    private boolean showGutter = true;
    private boolean hightlightActiveLine = true;
    private boolean displayIndentGuides = false;
    private boolean highlightSelectedWord = false;
    private AceSelection selection = new AceSelection();
    private AceCursorPosition cursorPosition = new AceCursorPosition();
    private boolean useWorker = false;
    private boolean liveAutocompletion = false;
    private boolean enableSnippets = false;
    private List<AceMarker> markers = new ArrayList<AceMarker>();
    private boolean statusbarEnabled = true;
    private AceStatusbarIndexing statusbarIndexing = AceStatusbarIndexing.ONE_BASED;
    private List<IAceWordCompleter> customWordCompleter = new ArrayList<IAceWordCompleter>();
    private Map<String, AceCustomMode> customModes = new HashMap<String, AceCustomMode>();
    private String customMode = "";
    private ObjectMapper objectMapper = new ObjectMapper();
    private boolean hasBeenDetached = false;

    public AceEditor() {
        super.addListener(AceBlurChanged.class, this::updateEditor);
        super.addListener(AceForceSyncDomEvent.class, this::onForceSyncDomEvent);
        this.setHeight("300px");
        this.setWidth("100%");
    }

    public AceEditor(String height, String width) {
        super.addListener(AceBlurChanged.class, this::updateEditor);
        super.addListener(AceForceSyncDomEvent.class, this::onForceSyncDomEvent);
        this.setHeight(height);
        this.setWidth(width);
    }

    public AceEditor(AceTheme theme, AceMode mode, String height, String width) {
        super.addListener(AceBlurChanged.class, this::updateEditor);
        super.addListener(AceForceSyncDomEvent.class, this::onForceSyncDomEvent);
        this.setTheme(theme);
        this.setMode(mode);
        this.setHeight(height);
        this.setWidth(width);
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.hasBeenDetached) {
            if (!this.value.equals("")) {
                this.setValue(this.value);
                if (!this.selection.compareTo(new AceSelection())) {
                    this.setSelection(this.selection);
                }
            }
            if (this.statusbarIndexing != AceStatusbarIndexing.ONE_BASED) {
                this.setStatusbarIndexing(this.statusbarIndexing);
            }
            if (!this.customWordCompleter.isEmpty()) {
                for (IAceWordCompleter completer : this.customWordCompleter) {
                    if (completer instanceof AceStaticWordCompleter) {
                        AceStaticWordCompleter aceStaticWordCompleter = (AceStaticWordCompleter)completer;
                        this.getElement().callJsFunction("addStaticWordCompleter", new Object[]{aceStaticWordCompleter.toJSON()});
                        continue;
                    }
                    if (!(completer instanceof AceDynamicWordCompleter)) continue;
                    AceDynamicWordCompleter aceDynamicWordCompleter = (AceDynamicWordCompleter)completer;
                    this.getElement().callJsFunction("addDynamicWordCompleter", new Object[]{aceDynamicWordCompleter.toJSON()});
                }
            }
            if (!this.customModes.isEmpty()) {
                for (String key : this.customModes.keySet()) {
                    AceCustomMode value = this.customModes.get(key);
                    this.getElement().callJsFunction("addCustomMode", new Object[]{key, this.objectMapper.writeValueAsString((Object)value)});
                }
            }
            if (!this.customMode.isBlank() && !this.customMode.isEmpty() && this.mode == AceMode.custom) {
                this.setCustomMode(this.customMode);
            }
            this.hasBeenDetached = false;
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        this.hasBeenDetached = true;
    }

    private void updateEditor(AceBlurChanged event) {
        this.selection = event.getSelection();
        this.cursorPosition = event.getCursorPosition();
        if (!this.value.equals(event.getValue())) {
            this.fireEvent(new AceValueChanged((AceEditor)event.getSource(), true, event.getValue()));
        }
        this.value = event.getValue();
    }

    private void onForceSyncDomEvent(AceForceSyncDomEvent event) {
        this.selection = event.getSelection();
        this.cursorPosition = event.getCursorPosition();
        if (!this.value.equals(event.getValue())) {
            this.fireEvent(new AceValueChanged((AceEditor)event.getSource(), true, event.getValue()));
        }
        this.value = event.getValue();
        this.fireEvent(new AceForceSyncEvent((AceEditor)event.getSource(), event.isFromClient(), event.getValue(), event.getSelection(), event.getCursorPosition()));
    }

    public void setMode(AceMode mode) {
        this.getElement().setProperty("mode", mode.toString());
        this.mode = mode;
        if (mode != AceMode.custom) {
            this.customMode = "";
        }
    }

    public AceMode getMode() {
        return this.mode;
    }

    public void setTheme(AceTheme theme) {
        this.getElement().setProperty("theme", theme.toString());
        this.theme = theme;
    }

    public AceTheme getTheme() {
        return this.theme;
    }

    public void setBaseUrl(String baseUrl) {
        this.getElement().setProperty("baseUrl", baseUrl);
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void clear() {
        this.getElement().callJsFunction("setValue", new Object[]{""});
        if (!this.value.equals("")) {
            this.fireEvent(new AceValueChanged(this, false, ""));
        }
        this.value = "";
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        this.getElement().callJsFunction("setValue", new Object[]{value});
        if (!this.value.equals(value)) {
            this.fireEvent(new AceValueChanged(this, false, value));
        }
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setFontSize(int value) {
        this.getElement().setProperty("fontSize", (double)value);
        this.fontSize = value;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setSofttabs(boolean value) {
        this.getElement().setProperty("softtabs", value);
        this.softTabs = value;
    }

    public boolean isSofttabs() {
        return this.softTabs;
    }

    public void setTabSize(int value) {
        this.getElement().setProperty("tabSize", String.valueOf(value));
        this.tabSize = value;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setWrap(boolean wrap) {
        this.getElement().setProperty("wrap", wrap);
        this.wrap = wrap;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setAutoComplete(boolean value) {
        this.getElement().setProperty("enableAutocompletion", value);
        this.autoComplete = value;
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    public void setInitialFocus(boolean value) {
        this.getElement().setProperty("initialFocus", value);
        this.initialFocus = value;
    }

    public boolean isInitialFocus() {
        return this.initialFocus;
    }

    public void setPlaceholder(String value) {
        this.getElement().setProperty("placeholder", value);
        this.placeHolder = value;
    }

    public String getPlaceholder() {
        return this.placeHolder;
    }

    public void setReadOnly(boolean value) {
        this.getElement().setProperty("readonly", value);
        this.readOnly = value;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setShowPrintMargin(boolean value) {
        this.getElement().setProperty("showPrintMargin", value);
        this.printMargin = value;
    }

    public boolean isShowPrintMargin() {
        return this.printMargin;
    }

    public void setShowInvisibles(boolean value) {
        this.getElement().setProperty("showInvisibles", value);
        this.showInvisibles = value;
    }

    public boolean isShowInvisibles() {
        return this.showInvisibles;
    }

    public void setShowGutter(boolean value) {
        this.getElement().setProperty("showGutter", value);
        this.showGutter = value;
    }

    public boolean isShowGutter() {
        return this.showGutter;
    }

    public void setHighlightActiveLine(boolean value) {
        this.getElement().setProperty("highlightActiveLine", value);
        this.hightlightActiveLine = value;
    }

    public boolean isHightlightActiveLine() {
        return this.hightlightActiveLine;
    }

    public void setDisplayIndentGuides(boolean value) {
        this.getElement().setProperty("displayIndentGuides", value);
        this.displayIndentGuides = value;
    }

    public boolean isDisplayIndentGuides() {
        return this.displayIndentGuides;
    }

    public void setHighlightSelectedWord(boolean value) {
        this.getElement().setProperty("highlightSelectedWord", value);
        this.highlightSelectedWord = value;
    }

    public boolean isHightlightSelectedWord() {
        return this.highlightSelectedWord;
    }

    public void setSelection(int startRow, int startColumn, int endRow, int endColumn) {
        int tmp;
        startRow = Math.abs(startRow);
        startColumn = Math.abs(startColumn);
        endRow = Math.abs(endRow);
        if ((endColumn = Math.abs(endColumn)) < startColumn) {
            tmp = startColumn;
            startColumn = endColumn;
            endColumn = tmp;
        }
        if (endRow < startRow) {
            tmp = startRow;
            startRow = endRow;
            endRow = tmp;
        }
        String json = AceJSON.generateSelectionJSON(startRow, startColumn, endRow, endColumn);
        this.getElement().callJsFunction("setSelection", new Object[]{json});
    }

    public void setSelection(int startRow, int startColumn, int endRow, int endColumn, boolean focus) {
        this.setSelection(startRow, startColumn, endRow, endColumn);
        if (focus) {
            this.focus();
        }
    }

    public void setSelection(int startIndex, int endIndex) {
        if (endIndex < startIndex) {
            int tmp = startIndex;
            startIndex = endIndex;
            endIndex = tmp;
        }
        this.getElement().callJsFunction("calculateSelectionByIndices", new Object[]{startIndex, endIndex});
    }

    public void setSelection(int startIndex, int endIndex, boolean focus) {
        this.setSelection(startIndex, endIndex);
        if (focus) {
            this.focus();
        }
    }

    public void setSelection(AceSelection selection) {
        String json = AceJSON.generateSelectionJSON(selection);
        this.getElement().callJsFunction("setSelection", new Object[]{json});
    }

    public void setSelection(AceSelection selection, boolean focus) {
        this.setSelection(selection);
        if (focus) {
            this.focus();
        }
    }

    public AceSelection getSelection() {
        return this.selection;
    }

    public void setUseWorker(boolean value) {
        this.getElement().setProperty("useWorker", value);
        this.useWorker = value;
    }

    public boolean isUseWorker() {
        return this.useWorker;
    }

    public void setCursorPosition(int row, int column) {
        row = Math.abs(row);
        column = Math.abs(column);
        String json = AceJSON.generateCursorPositionJSON(row, column);
        this.getElement().callJsFunction("setCursorPosition", new Object[]{json});
    }

    public void setCursorPosition(int row, int column, boolean focus) {
        this.setCursorPosition(row, column);
        if (focus) {
            this.focus();
        }
    }

    public void setCursorPosition(int index) {
        this.getElement().callJsFunction("calculateCursorPositionFromIndex", new Object[]{index});
    }

    public void setCursorPosition(int index, boolean focus) {
        this.setCursorPosition(index);
        if (focus) {
            this.focus();
        }
    }

    public void setCursorPosition(AceCursorPosition cursorPosition) {
        String json = AceJSON.generateCursorPositionJSON(cursorPosition);
        this.getElement().callJsFunction("setCursorPosition", new Object[]{json});
    }

    public void setCursorPosition(AceCursorPosition cursorPosition, boolean focus) {
        this.setCursorPosition(cursorPosition);
        if (focus) {
            this.focus();
        }
    }

    public AceCursorPosition getCursorPosition() {
        return this.cursorPosition;
    }

    public void setLiveAutocompletion(boolean value) {
        this.getElement().setProperty("enableLiveAutocompletion", value);
        this.liveAutocompletion = value;
    }

    public boolean isLiveAutocompletion() {
        return this.liveAutocompletion;
    }

    public void setEnableSnippets(boolean value) {
        this.getElement().setProperty("enableSnippets", value);
        this.enableSnippets = value;
    }

    public boolean isEnableSnippets() {
        return this.enableSnippets;
    }

    @Deprecated(forRemoval=false)
    public void setCustomAutocompletion(List<String> wordList) {
        this.addStaticWordCompleter(wordList);
    }

    @Deprecated(forRemoval=false)
    public void setCustomAutocompletion(List<String> wordList, boolean keepCurrentCompleters) {
        this.addStaticWordCompleter(wordList, keepCurrentCompleters);
    }

    @Deprecated(forRemoval=false)
    public void setCustomAutocompletion(List<String> wordList, String category) {
        this.addStaticWordCompleter(wordList, category);
    }

    @Deprecated(forRemoval=false)
    public void setCustomAutocompletion(List<String> wordList, String category, boolean keepCurrentCompleters) {
        this.addStaticWordCompleter(wordList, category, keepCurrentCompleters);
    }

    @Deprecated(forRemoval=false)
    public List<String> getCustomAutocompletion() {
        ArrayList<String> words = new ArrayList<String>();
        for (IAceWordCompleter completer : this.customWordCompleter) {
            if (!(completer instanceof AceStaticWordCompleter)) continue;
            AceStaticWordCompleter aswc = (AceStaticWordCompleter)completer;
            words.addAll(aswc.getWords());
        }
        return words;
    }

    public void addStaticWordCompleter(List<String> words) {
        if (words.isEmpty()) {
            return;
        }
        AceStaticWordCompleter aswc = new AceStaticWordCompleter(words);
        this.getElement().callJsFunction("addStaticWordCompleter", new Object[]{aswc.toJSON()});
        this.customWordCompleter = new ArrayList<AceStaticWordCompleter>(Arrays.asList(aswc));
    }

    public void addStaticWordCompleter(List<String> words, boolean keepCompleters) {
        if (words.isEmpty()) {
            return;
        }
        AceStaticWordCompleter aswc = new AceStaticWordCompleter(words, keepCompleters);
        this.getElement().callJsFunction("addStaticWordCompleter", new Object[]{aswc.toJSON()});
        if (keepCompleters) {
            this.customWordCompleter.add(aswc);
        } else {
            this.customWordCompleter = new ArrayList<AceStaticWordCompleter>(Arrays.asList(aswc));
        }
    }

    public void addStaticWordCompleter(List<String> words, String category) {
        if (words.isEmpty()) {
            return;
        }
        AceStaticWordCompleter aswc = new AceStaticWordCompleter(words, category);
        this.getElement().callJsFunction("addStaticWordCompleter", new Object[]{aswc.toJSON()});
        this.customWordCompleter = new ArrayList<AceStaticWordCompleter>(Arrays.asList(aswc));
    }

    public void addStaticWordCompleter(List<String> words, String category, boolean keepCompleters) {
        if (words.isEmpty()) {
            return;
        }
        AceStaticWordCompleter aswc = new AceStaticWordCompleter(words, category, keepCompleters);
        this.getElement().callJsFunction("addStaticWordCompleter", new Object[]{aswc.toJSON()});
        if (keepCompleters) {
            this.customWordCompleter.add(aswc);
        } else {
            this.customWordCompleter = new ArrayList<AceStaticWordCompleter>(Arrays.asList(aswc));
        }
    }

    public void addStaticWordCompleter(AceStaticWordCompleter staticWordCompleter) {
        if (staticWordCompleter.getWords().isEmpty()) {
            return;
        }
        this.getElement().callJsFunction("addStaticWordCompleter", new Object[]{staticWordCompleter.toJSON()});
        if (staticWordCompleter.isKeepCompleters()) {
            this.customWordCompleter.add(staticWordCompleter);
        } else {
            this.customWordCompleter = new ArrayList<AceStaticWordCompleter>(Arrays.asList(staticWordCompleter));
        }
    }

    public List<AceStaticWordCompleter> getStaticWordCompleter() {
        ArrayList<AceStaticWordCompleter> staticCompleter = new ArrayList<AceStaticWordCompleter>();
        for (IAceWordCompleter completer : this.customWordCompleter) {
            if (!(completer instanceof AceStaticWordCompleter)) continue;
            AceStaticWordCompleter aceStaticWordCompleter = (AceStaticWordCompleter)completer;
            staticCompleter.add(aceStaticWordCompleter);
        }
        return staticCompleter;
    }

    public void disableCustomAutocompletion() {
        this.disableCustomAutocompletion(true);
    }

    public void disableCustomAutocompletion(boolean useDefault) {
        this.getElement().callJsFunction("disableCustomAutocompletion", new Object[]{useDefault});
        this.customWordCompleter = new ArrayList<IAceWordCompleter>();
    }

    public void addTextAtPosition(int row, int column, String text) {
        this.getElement().callJsFunction("insertText", new Object[]{row, column, text});
    }

    public void addTextAtCurrentPosition(String text) {
        this.addTextAtPosition(this.cursorPosition.getRow(), this.cursorPosition.getColumn(), text);
    }

    public AceMarker addMarkerAtCurrentSelection(AceMarkerColor color) {
        if (!this.selection.compareTo(new AceSelection())) {
            AceSelection currentSelection = this.selection;
            AceMarker marker = new AceMarker(currentSelection.getStartRow(), currentSelection.getStartColumn(), currentSelection.getEndRow(), currentSelection.getEndColumn(), color);
            this.getElement().setProperty("marker", marker.getRowStart() + "|" + marker.getFrom() + "|" + marker.getRowEnd() + "|" + marker.getTo() + "|" + marker.getAceMarkerColor().toString() + "|" + marker.getID());
            this.markers.add(marker);
            return marker;
        }
        return null;
    }

    public AceMarker addMarkerAtCurrentSelection(AceMarkerColor color, String alias) {
        if (!this.selection.compareTo(new AceSelection())) {
            AceSelection currentSelection = this.selection;
            AceMarker marker = new AceMarker(currentSelection.getStartRow(), currentSelection.getStartColumn(), currentSelection.getEndRow(), currentSelection.getEndColumn(), color, alias);
            this.getElement().setProperty("marker", marker.getRowStart() + "|" + marker.getFrom() + "|" + marker.getRowEnd() + "|" + marker.getTo() + "|" + marker.getAceMarkerColor().toString() + "|" + marker.getID());
            this.markers.add(marker);
            return marker;
        }
        return null;
    }

    public AceMarker addMarkerAtSelection(int rowStart, int from, int rowEnd, int to, AceMarkerColor color) {
        int tmp;
        rowStart = Math.abs(rowStart);
        from = Math.abs(from);
        rowEnd = Math.abs(rowEnd);
        if ((to = Math.abs(to)) < from) {
            tmp = from;
            from = to;
            to = tmp;
        }
        if (rowEnd < rowStart) {
            tmp = rowStart;
            rowStart = rowEnd;
            rowEnd = tmp;
        }
        AceMarker marker = new AceMarker(rowStart, from, rowEnd, to, color);
        this.getElement().setProperty("marker", marker.getRowStart() + "|" + marker.getFrom() + "|" + marker.getRowEnd() + "|" + marker.getTo() + "|" + marker.getAceMarkerColor().toString() + "|" + marker.getID());
        this.markers.add(marker);
        return marker;
    }

    public AceMarker addMarkerAtSelection(int rowStart, int from, int rowEnd, int to, AceMarkerColor color, String alias) {
        int tmp;
        rowStart = Math.abs(rowStart);
        from = Math.abs(from);
        rowEnd = Math.abs(rowEnd);
        if ((to = Math.abs(to)) < from) {
            tmp = from;
            from = to;
            to = tmp;
        }
        if (rowEnd < rowStart) {
            tmp = rowStart;
            rowStart = rowEnd;
            rowEnd = tmp;
        }
        AceMarker marker = new AceMarker(rowStart, from, rowEnd, to, color, alias);
        this.getElement().setProperty("marker", marker.getRowStart() + "|" + marker.getFrom() + "|" + marker.getRowEnd() + "|" + marker.getTo() + "|" + marker.getAceMarkerColor().toString() + "|" + marker.getID());
        this.markers.add(marker);
        return marker;
    }

    public void addMarker(AceMarker marker) {
        this.getElement().setProperty("marker", marker.getRowStart() + "|" + marker.getFrom() + "|" + marker.getRowEnd() + "|" + marker.getTo() + "|" + marker.getAceMarkerColor().toString() + "|" + marker.getID());
        this.markers.add(marker);
    }

    public List<AceMarker> getAllMarkers() {
        return this.markers;
    }

    public void removeMarker(AceMarker marker) {
        for (AceMarker mar : this.markers) {
            if (!mar.getID().equals(marker.getID())) continue;
            this.getElement().setProperty("rmMarker", marker.getID());
            this.markers.remove(marker);
        }
    }

    public void removeMarkerByID(String id) {
        for (AceMarker mar : this.markers) {
            if (!mar.getID().equals(id)) continue;
            this.getElement().setProperty("rmMarker", id);
            this.markers.remove(mar);
        }
    }

    public void removeMarkerByAlias(String alias) {
        for (AceMarker mar : this.markers) {
            if (!mar.getAlias().equals(alias)) continue;
            this.getElement().setProperty("rmMarker", mar.getID());
            this.markers.remove(mar);
        }
    }

    public void removeAllMarkers() {
        this.getElement().setProperty("rmMarker", "all" + UUID.randomUUID().toString());
        this.markers = new ArrayList<AceMarker>();
    }

    public Registration addSelectionChangeListener(ComponentEventListener<AceSelectionChanged> listener) {
        return this.addListener(AceSelectionChanged.class, listener);
    }

    public void sync() {
        this.getElement().callJsFunction("forceSync", new Object[0]);
    }

    public Registration addSyncCompletedListener(ComponentEventListener<AceForceSyncEvent> listener) {
        return this.addListener(AceForceSyncEvent.class, listener);
    }

    public void generateHTML(AceExportType type) {
        this.getElement().callJsFunction("generateHTML", new Object[]{type.getType()});
    }

    public Registration addHTMLGeneratedListener(ComponentEventListener<AceHTMLGeneratedEvent> listener) {
        return this.addListener(AceHTMLGeneratedEvent.class, listener);
    }

    public Registration addAceChangedListener(ComponentEventListener<AceChanged> listener) {
        return this.addListener(AceChanged.class, listener);
    }

    public void replaceTextAtCurrentSelection(String text) {
        if (!this.selection.compareTo(new AceSelection())) {
            if (text == null) {
                text = "";
            }
            this.getElement().callJsFunction("replaceTextAtSelection", new Object[]{text});
        }
    }

    public void focus() {
        this.getElement().callJsFunction("focusEditor", new Object[0]);
    }

    public void runAfterSync(Runnable action) {
        Objects.requireNonNull(action);
        this.addListener(AceForceSyncDomEvent.class, (ComponentEventListener & Serializable)event -> this.runAfterSync((AceForceSyncDomEvent)event, action));
        this.sync();
    }

    private void runAfterSync(AceForceSyncDomEvent event, Runnable action) {
        event.unregisterListener();
        action.run();
    }

    public void foldAll() {
        this.getElement().callJsFunction("foldAll", new Object[0]);
    }

    public void foldAll(int startRow) {
        this.getElement().callJsFunction("foldAll", new Object[]{startRow});
    }

    public void unfold() {
        this.getElement().callJsFunction("unfold", new Object[0]);
    }

    public void beautify() {
        this.getElement().callJsFunction("beautify", new Object[0]);
    }

    public void setStatusbarEnabled(boolean statusbarEnabled) {
        this.getElement().setProperty("statusbarEnabled", statusbarEnabled);
        this.statusbarEnabled = statusbarEnabled;
    }

    public boolean isStatusbarEnabled() {
        return this.statusbarEnabled;
    }

    public void setStatusbarTextColor(String textColor) {
        this.getElement().getStyle().set("--las-color", textColor);
    }

    public void setStatusbarBackgroundColor(String backgroundColor) {
        this.getElement().getStyle().set("--las-background-color", backgroundColor);
    }

    public void setStatusbarBorderRadius(String borderRadius) {
        this.getElement().getStyle().set("--las-border-radius", borderRadius);
    }

    public Registration addAceReadyListener(ComponentEventListener<AceReady> listener) {
        return this.addListener(AceReady.class, listener);
    }

    @Deprecated(forRemoval=false)
    public void addDynamicAutocompletion(Map<String, List<String>> map, String seperator) {
        this.addDynamicWordCompleter(map, seperator);
    }

    @Deprecated(forRemoval=false)
    public void addDynamicAutocompletion(Map<String, List<String>> map, String seperator, String category) {
        this.addDynamicWordCompleter(map, seperator, category);
    }

    @Deprecated(forRemoval=false)
    public void addDynamicAutocompletion(Map<String, List<String>> map, String seperator, boolean keepCompleters) {
        this.addDynamicAutocompletion(map, seperator, keepCompleters);
    }

    @Deprecated
    public void addDynamicAutocompletion(Map<String, List<String>> map, String seperator, String category, boolean keepCompleters) {
        this.addDynamicWordCompleter(map, seperator, category, keepCompleters);
    }

    public void addDynamicWordCompleter(Map<String, List<String>> dynamicWords, String seperator) {
        if (dynamicWords.isEmpty()) {
            return;
        }
        AceDynamicWordCompleter adwc = new AceDynamicWordCompleter(dynamicWords, seperator);
        this.getElement().callJsFunction("addDynamicWordCompleter", new Object[]{adwc.toJSON()});
        this.customWordCompleter = new ArrayList<AceDynamicWordCompleter>(Arrays.asList(adwc));
    }

    public void addDynamicWordCompleter(Map<String, List<String>> dynamicWords, String seperator, String category) {
        if (dynamicWords.isEmpty()) {
            return;
        }
        AceDynamicWordCompleter adwc = new AceDynamicWordCompleter(dynamicWords, seperator, category);
        this.getElement().callJsFunction("addDynamicWordCompleter", new Object[]{adwc.toJSON()});
        this.customWordCompleter = new ArrayList<AceDynamicWordCompleter>(Arrays.asList(adwc));
    }

    public void addDynamicWordCompleter(Map<String, List<String>> dynamicWords, String seperator, boolean keepCompleters) {
        if (dynamicWords.isEmpty()) {
            return;
        }
        AceDynamicWordCompleter adwc = new AceDynamicWordCompleter(dynamicWords, seperator, keepCompleters);
        this.getElement().callJsFunction("addDynamicWordCompleter", new Object[]{adwc.toJSON()});
        if (keepCompleters) {
            this.customWordCompleter.add(adwc);
        } else {
            this.customWordCompleter = new ArrayList<AceDynamicWordCompleter>(Arrays.asList(adwc));
        }
    }

    public void addDynamicWordCompleter(Map<String, List<String>> dynamicWords, String seperator, String category, boolean keepCompleters) {
        if (dynamicWords.isEmpty()) {
            return;
        }
        AceDynamicWordCompleter adwc = new AceDynamicWordCompleter(dynamicWords, seperator, category, keepCompleters);
        this.getElement().callJsFunction("addDynamicWordCompleter", new Object[]{adwc.toJSON()});
        if (keepCompleters) {
            this.customWordCompleter.add(adwc);
        } else {
            this.customWordCompleter = new ArrayList<AceDynamicWordCompleter>(Arrays.asList(adwc));
        }
    }

    public void addDynamicWordCompleter(AceDynamicWordCompleter dynamicWordCompleter) {
        if (dynamicWordCompleter.getDynamicWords().isEmpty()) {
            return;
        }
        this.getElement().callJsFunction("addDynamicWordCompleter", new Object[]{dynamicWordCompleter.toJSON()});
        if (dynamicWordCompleter.isKeepCompleters()) {
            this.customWordCompleter.add(dynamicWordCompleter);
        } else {
            this.customWordCompleter = new ArrayList<AceDynamicWordCompleter>(Arrays.asList(dynamicWordCompleter));
        }
    }

    public List<AceDynamicWordCompleter> getDynamicWordCompleter() {
        ArrayList<AceDynamicWordCompleter> dynamicCompleter = new ArrayList<AceDynamicWordCompleter>();
        for (IAceWordCompleter completer : this.customWordCompleter) {
            if (!(completer instanceof AceDynamicWordCompleter)) continue;
            AceDynamicWordCompleter aceDynamicWordCompleter = (AceDynamicWordCompleter)completer;
            dynamicCompleter.add(aceDynamicWordCompleter);
        }
        return dynamicCompleter;
    }

    public List<IAceWordCompleter> getWordCompleter() {
        return this.customWordCompleter;
    }

    public void openAutocompletion() {
        this.getElement().callJsFunction("openAutocompletion", new Object[0]);
    }

    public void setEditorBorder(String border) {
        this.getElement().getStyle().set("--lae-border", border);
    }

    public void setEditorBorderRadius(String borderRadius) {
        this.getElement().getStyle().set("--lae-border-radius", borderRadius);
    }

    public void scrollToLine(int line) {
        this.getElement().callJsFunction("scrollToLine", new Object[]{line});
    }

    public void scrollToEnd() {
        this.getElement().callJsFunction("scrollToEnd", new Object[0]);
    }

    public void findAndSelect(String text) {
        this.getElement().callJsFunction("findAndSelect", new Object[]{text});
    }

    public Registration addValueChangeListener(ComponentEventListener<AceValueChanged> listener) {
        return this.addListener(AceValueChanged.class, listener);
    }

    public void print(AceExportType exportType) {
        this.getElement().callJsFunction("print", new Object[]{exportType.getType()});
    }

    public void setStatusbarIndexing(AceStatusbarIndexing statusbarIndexing) {
        this.getElement().callJsFunction("setStatusbarIndexing", new Object[]{statusbarIndexing.getIntValue()});
        this.statusbarIndexing = statusbarIndexing;
    }

    public AceStatusbarIndexing getStatusbarIndexing() {
        return this.statusbarIndexing;
    }

    public void addCustomMode(String name, AceCustomMode customMode) {
        this.getElement().callJsFunction("addCustomMode", new Object[]{name, this.objectMapper.writeValueAsString((Object)customMode)});
        this.customModes.put(name, customMode);
    }

    public Map<String, AceCustomMode> getCustomModes() {
        return this.customModes;
    }

    public void setCustomMode(String customMode) {
        if (this.customModes.containsKey(customMode)) {
            this.getElement().callJsFunction("setCustomMode", new Object[]{customMode});
            this.setMode(AceMode.custom);
            this.customMode = customMode;
        }
    }
}

