/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor;

import com.wontlost.ckeditor.CKEditorConfig;
import com.wontlost.ckeditor.CKEditorPlugin;
import com.wontlost.ckeditor.CKEditorPluginDependencies;
import com.wontlost.ckeditor.CKEditorPreset;
import com.wontlost.ckeditor.CKEditorTheme;
import com.wontlost.ckeditor.CKEditorType;
import com.wontlost.ckeditor.CustomPlugin;
import com.wontlost.ckeditor.VaadinCKEditor;
import com.wontlost.ckeditor.event.FallbackEvent;
import com.wontlost.ckeditor.handler.ErrorHandler;
import com.wontlost.ckeditor.handler.HtmlSanitizer;
import com.wontlost.ckeditor.handler.UploadHandler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public class VaadinCKEditorBuilder {
    private static final Pattern LANGUAGE_CODE_PATTERN = Pattern.compile("^[a-z]{2}(-[a-z]{2})?$");
    private static final String TOOLBAR_SEPARATOR = "|";
    private final VaadinCKEditor editor;
    private boolean built = false;
    private CKEditorPreset preset;
    private final Set<CKEditorPlugin> additionalPlugins = new LinkedHashSet<CKEditorPlugin>();
    private final Set<CKEditorPlugin> removedPlugins = new HashSet<CKEditorPlugin>();
    private final Set<CustomPlugin> customPlugins = new LinkedHashSet<CustomPlugin>();
    private String[] toolbar;
    private CKEditorConfig config;
    private DependencyMode dependencyMode = DependencyMode.AUTO_RESOLVE;
    private boolean hideToolbar = false;

    VaadinCKEditorBuilder() {
        this.editor = new VaadinCKEditor();
    }

    public static VaadinCKEditorBuilder create() {
        return new VaadinCKEditorBuilder();
    }

    public VaadinCKEditorBuilder withPreset(CKEditorPreset preset) {
        this.preset = preset;
        return this;
    }

    public VaadinCKEditorBuilder withPlugins(CKEditorPlugin ... plugins) {
        this.editor.clearPlugins();
        this.editor.addPluginsInternal(Arrays.asList(plugins));
        return this;
    }

    public VaadinCKEditorBuilder addPlugin(CKEditorPlugin plugin) {
        this.additionalPlugins.add(plugin);
        return this;
    }

    public VaadinCKEditorBuilder addPlugins(CKEditorPlugin ... plugins) {
        this.additionalPlugins.addAll(Arrays.asList(plugins));
        return this;
    }

    public VaadinCKEditorBuilder removePlugin(CKEditorPlugin plugin) {
        this.removedPlugins.add(plugin);
        return this;
    }

    public VaadinCKEditorBuilder addCustomPlugin(CustomPlugin plugin) {
        this.customPlugins.add(plugin);
        return this;
    }

    public VaadinCKEditorBuilder withToolbar(String ... items) {
        this.validateToolbar(items);
        this.toolbar = items;
        return this;
    }

    public VaadinCKEditorBuilder withType(CKEditorType type) {
        this.editor.setEditorTypeInternal(type);
        return this;
    }

    public VaadinCKEditorBuilder withTheme(CKEditorTheme theme) {
        this.editor.setThemeInternal(theme);
        return this;
    }

    public VaadinCKEditorBuilder withLanguage(String language) {
        this.validateLanguageCode(language);
        this.editor.setLanguageInternal(language);
        return this;
    }

    public VaadinCKEditorBuilder withFallbackMode(FallbackEvent.FallbackMode mode) {
        this.editor.setFallbackModeInternal(mode);
        return this;
    }

    public VaadinCKEditorBuilder withErrorHandler(ErrorHandler handler) {
        this.editor.setErrorHandlerInternal(handler);
        return this;
    }

    public VaadinCKEditorBuilder withHtmlSanitizer(HtmlSanitizer sanitizer) {
        this.editor.setHtmlSanitizerInternal(sanitizer);
        return this;
    }

    public VaadinCKEditorBuilder withUploadHandler(UploadHandler handler) {
        this.editor.setUploadHandlerInternal(handler);
        return this;
    }

    public VaadinCKEditorBuilder withUploadConfig(UploadHandler.UploadConfig config) {
        this.editor.setUploadConfigInternal(config);
        return this;
    }

    public VaadinCKEditorBuilder withValue(String value) {
        this.editor.setEditorDataInternal(value);
        return this;
    }

    public VaadinCKEditorBuilder readOnly(boolean readOnly) {
        this.editor.setReadOnlyInternal(readOnly);
        return this;
    }

    public VaadinCKEditorBuilder withReadOnly(boolean readOnly) {
        return this.readOnly(readOnly);
    }

    public VaadinCKEditorBuilder withViewOnly() {
        this.editor.setReadOnlyInternal(true);
        this.hideToolbar = true;
        this.editor.setFallbackModeInternal(FallbackEvent.FallbackMode.READ_ONLY);
        return this;
    }

    public VaadinCKEditorBuilder withHideToolbar(boolean hide) {
        this.hideToolbar = hide;
        return this;
    }

    public VaadinCKEditorBuilder withAutosave(Consumer<String> callback, int waitingTime) {
        if (waitingTime < 100 || waitingTime > 60000) {
            throw new IllegalArgumentException("Autosave waiting time must be between 100 and 60000 milliseconds, got: " + waitingTime);
        }
        this.editor.setAutosaveInternal(true, waitingTime, callback);
        return this;
    }

    public VaadinCKEditorBuilder withConfig(CKEditorConfig config) {
        this.config = config;
        return this;
    }

    public VaadinCKEditorBuilder withWidth(String width) {
        this.editor.setWidth(width);
        return this;
    }

    public VaadinCKEditorBuilder withHeight(String height) {
        this.editor.setHeight(height);
        return this;
    }

    public VaadinCKEditorBuilder withDependencyMode(DependencyMode mode) {
        this.dependencyMode = mode;
        return this;
    }

    public VaadinCKEditorBuilder withLicenseKey(String licenseKey) {
        this.editor.setLicenseKeyInternal(licenseKey);
        return this;
    }

    public VaadinCKEditor build() {
        if (this.built) {
            throw new IllegalStateException("Builder has already been used. Create a new builder for additional editors.");
        }
        this.built = true;
        LinkedHashSet<CKEditorPlugin> initialPlugins = new LinkedHashSet<CKEditorPlugin>();
        if (this.preset != null && !this.editor.hasPlugins()) {
            initialPlugins.addAll(this.preset.getPlugins());
        }
        initialPlugins.addAll(this.editor.getPluginsInternal());
        initialPlugins.addAll(this.additionalPlugins);
        initialPlugins.removeAll(this.removedPlugins);
        Set<CKEditorPlugin> finalPlugins = this.processPluginDependencies(initialPlugins);
        this.editor.clearPlugins();
        this.editor.addPluginsInternal(finalPlugins);
        this.editor.addCustomPluginsInternal(this.customPlugins);
        if (this.toolbar != null) {
            this.editor.setToolbarInternal(this.toolbar);
        } else if (this.preset != null) {
            this.editor.setToolbarInternal(this.preset.getDefaultToolbar());
        }
        if (this.config != null) {
            this.editor.setConfigInternal(this.config);
        }
        this.editor.getConfigInternal().setLanguage(this.editor.getLanguageInternal());
        if (finalPlugins.contains((Object)CKEditorPlugin.CLOUD_SERVICES)) {
            this.editor.setAllowConfigRequiredPlugins(true);
        }
        this.editor.initialize();
        if (this.hideToolbar) {
            this.editor.setHideToolbar(true);
        }
        return this.editor;
    }

    private Set<CKEditorPlugin> processPluginDependencies(Set<CKEditorPlugin> plugins) {
        switch (this.dependencyMode.ordinal()) {
            case 0: {
                return CKEditorPluginDependencies.resolveWithPremium(plugins, this.customPlugins, true);
            }
            case 1: {
                Set<CKEditorPlugin> resolved = CKEditorPluginDependencies.resolveWithRecommended(plugins);
                for (CustomPlugin customPlugin : this.customPlugins) {
                    Set<CKEditorPlugin> premiumDeps = CKEditorPluginDependencies.getPremiumDependencies(customPlugin.getJsName());
                    for (CKEditorPlugin dep : premiumDeps) {
                        resolved.add(dep);
                        resolved.addAll(CKEditorPluginDependencies.resolve(Set.of(dep), false));
                    }
                }
                return resolved;
            }
            case 2: {
                this.validateDependenciesStrict(plugins);
                LinkedHashSet<CKEditorPlugin> withCore = new LinkedHashSet<CKEditorPlugin>(plugins);
                withCore.add(CKEditorPlugin.ESSENTIALS);
                withCore.add(CKEditorPlugin.PARAGRAPH);
                for (CustomPlugin customPlugin : this.customPlugins) {
                    Set<CKEditorPlugin> premiumDeps = CKEditorPluginDependencies.getPremiumDependencies(customPlugin.getJsName());
                    withCore.addAll(premiumDeps);
                }
                return withCore;
            }
        }
        return plugins;
    }

    private void validateDependenciesStrict(Set<CKEditorPlugin> plugins) {
        Map<CKEditorPlugin, Set<CKEditorPlugin>> missing = CKEditorPluginDependencies.validateDependencies(plugins);
        Map<String, Set<CKEditorPlugin>> premiumMissing = CKEditorPluginDependencies.validatePremiumDependencies(plugins, this.customPlugins);
        if (!missing.isEmpty() || !premiumMissing.isEmpty()) {
            StringBuilder message = new StringBuilder("Missing plugin dependencies:\n");
            for (Map.Entry<CKEditorPlugin, Set<CKEditorPlugin>> entry : missing.entrySet()) {
                message.append("  - ").append(entry.getKey().getJsName()).append(" requires: ");
                entry.getValue().forEach(dep -> message.append(dep.getJsName()).append(", "));
                message.setLength(message.length() - 2);
                message.append("\n");
            }
            for (Map.Entry<Object, Set<CKEditorPlugin>> entry : premiumMissing.entrySet()) {
                message.append("  - [Premium] ").append((String)entry.getKey()).append(" requires: ");
                entry.getValue().forEach(dep -> message.append(dep.getJsName()).append(", "));
                message.setLength(message.length() - 2);
                message.append("\n");
            }
            throw new IllegalStateException(message.toString());
        }
    }

    public Set<CKEditorPlugin> getResolvedPlugins() {
        LinkedHashSet<CKEditorPlugin> initialPlugins = new LinkedHashSet<CKEditorPlugin>();
        if (this.preset != null && !this.editor.hasPlugins()) {
            initialPlugins.addAll(this.preset.getPlugins());
        }
        initialPlugins.addAll(this.editor.getPluginsInternal());
        initialPlugins.addAll(this.additionalPlugins);
        initialPlugins.removeAll(this.removedPlugins);
        return this.processPluginDependencies(initialPlugins);
    }

    public Map<CKEditorPlugin, Set<CKEditorPlugin>> getMissingDependencies() {
        LinkedHashSet<CKEditorPlugin> initialPlugins = new LinkedHashSet<CKEditorPlugin>();
        if (this.preset != null && !this.editor.hasPlugins()) {
            initialPlugins.addAll(this.preset.getPlugins());
        }
        initialPlugins.addAll(this.editor.getPluginsInternal());
        initialPlugins.addAll(this.additionalPlugins);
        initialPlugins.removeAll(this.removedPlugins);
        return CKEditorPluginDependencies.validateDependencies(initialPlugins);
    }

    public Map<String, Set<CKEditorPlugin>> getMissingPremiumDependencies() {
        LinkedHashSet<CKEditorPlugin> initialPlugins = new LinkedHashSet<CKEditorPlugin>();
        if (this.preset != null && !this.editor.hasPlugins()) {
            initialPlugins.addAll(this.preset.getPlugins());
        }
        initialPlugins.addAll(this.editor.getPluginsInternal());
        initialPlugins.addAll(this.additionalPlugins);
        initialPlugins.removeAll(this.removedPlugins);
        return CKEditorPluginDependencies.validatePremiumDependencies(initialPlugins, this.customPlugins);
    }

    private void validateToolbar(String[] items) {
        if (items == null) {
            throw new IllegalArgumentException("Toolbar items must not be null");
        }
        if (items.length == 0) {
            throw new IllegalArgumentException("Toolbar items must not be empty");
        }
        for (String item : items) {
            if (item == null) {
                throw new IllegalArgumentException("Toolbar item must not be null");
            }
            if (item.equals(TOOLBAR_SEPARATOR) || item.equals("-") || !item.trim().isEmpty()) continue;
            throw new IllegalArgumentException("Toolbar item must not be empty or whitespace");
        }
    }

    private void validateLanguageCode(String language) {
        if (language == null || language.isEmpty()) {
            throw new IllegalArgumentException("Language code must not be null or empty");
        }
        String normalized = language.toLowerCase(Locale.ROOT);
        if (!LANGUAGE_CODE_PATTERN.matcher(normalized).matches()) {
            throw new IllegalArgumentException("Invalid language code format: '" + language + "'. Expected ISO 639-1 format (e.g., 'en', 'zh-cn', 'pt-br')");
        }
    }

    public static enum DependencyMode {
        AUTO_RESOLVE,
        AUTO_RESOLVE_WITH_RECOMMENDED,
        STRICT,
        MANUAL;

    }
}

