/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor;

import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.SessionInitListener;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.wontlost.ckeditor.VaadinCKEditor;
import java.io.Serializable;
import java.util.logging.Logger;

public class HotDeployConfig
implements VaadinServiceInitListener {
    private static final Logger logger = Logger.getLogger(HotDeployConfig.class.getName());
    public static final String HOT_DEPLOY_DEBUG_PROPERTY = "vaadin.ckeditor.hotdeploy.debug";
    public static final String HOT_DEPLOY_DISABLED_PROPERTY = "vaadin.ckeditor.hotdeploy.disabled";
    private static volatile boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serviceInit(ServiceInitEvent event) {
        if (HotDeployConfig.isHotDeployDisabled()) {
            return;
        }
        if (initialized) return;
        Class<HotDeployConfig> clazz = HotDeployConfig.class;
        synchronized (HotDeployConfig.class) {
            if (initialized) return;
            this.initializeHotDeploy(event);
            initialized = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void initializeHotDeploy(ServiceInitEvent event) {
        boolean debug = HotDeployConfig.isDebugEnabled();
        if (debug) {
            logger.info("VaadinCKEditor hot deploy initialized");
            logger.info("  Version: " + VaadinCKEditor.getVersion());
            logger.info("  Development mode: " + !event.getSource().getDeploymentConfiguration().isProductionMode());
        }
        event.getSource().addUIInitListener((UIInitListener & Serializable)uiEvent -> {
            if (debug) {
                logger.fine("UI initialized: " + uiEvent.getUI().getUIId());
            }
        });
        event.getSource().addSessionInitListener((SessionInitListener & Serializable)sessionEvent -> {
            if (debug) {
                logger.fine("Session initialized: " + sessionEvent.getSession().getSession().getId());
            }
        });
    }

    public static boolean isHotDeployDisabled() {
        return Boolean.getBoolean(HOT_DEPLOY_DISABLED_PROPERTY);
    }

    public static boolean isDebugEnabled() {
        return Boolean.getBoolean(HOT_DEPLOY_DEBUG_PROPERTY);
    }

    public static boolean isDevelopmentMode() {
        String devMode = System.getProperty("vaadin.productionMode");
        if (devMode != null) {
            return !Boolean.parseBoolean(devMode);
        }
        String springProfiles = System.getProperty("spring.profiles.active", "");
        if (springProfiles.contains("dev") || springProfiles.contains("development")) {
            return true;
        }
        return true;
    }

    public static void refreshFrontend() {
        if (HotDeployConfig.isDebugEnabled()) {
            logger.info("Frontend refresh requested");
        }
    }

    public static String getStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("VaadinCKEditor Hot Deploy Status:\n");
        sb.append("  Initialized: ").append(initialized).append("\n");
        sb.append("  Disabled: ").append(HotDeployConfig.isHotDeployDisabled()).append("\n");
        sb.append("  Debug: ").append(HotDeployConfig.isDebugEnabled()).append("\n");
        sb.append("  Development Mode: ").append(HotDeployConfig.isDevelopmentMode()).append("\n");
        sb.append("  Version: ").append(VaadinCKEditor.getVersion()).append("\n");
        return sb.toString();
    }
}

