/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor;

import com.wontlost.ckeditor.CKEditorPlugin;
import com.wontlost.ckeditor.CustomPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CKEditorPluginDependencies {
    private static final Logger logger = Logger.getLogger(CKEditorPluginDependencies.class.getName());
    private static final Map<CKEditorPlugin, Set<CKEditorPlugin>> DEPENDENCIES;
    private static final Map<CKEditorPlugin, Set<CKEditorPlugin>> RECOMMENDED;
    private static final Map<String, Set<CKEditorPlugin>> PREMIUM_DEPENDENCIES;
    private static final Set<String> CLOUD_SERVICES_REQUIRED_PLUGINS;

    private CKEditorPluginDependencies() {
    }

    public static Set<CKEditorPlugin> getDependencies(CKEditorPlugin plugin) {
        return DEPENDENCIES.getOrDefault((Object)plugin, Collections.emptySet());
    }

    public static Set<CKEditorPlugin> getRecommended(CKEditorPlugin plugin) {
        return RECOMMENDED.getOrDefault((Object)plugin, Collections.emptySet());
    }

    public static boolean hasDependencies(CKEditorPlugin plugin) {
        return DEPENDENCIES.containsKey((Object)plugin) && !DEPENDENCIES.get((Object)plugin).isEmpty();
    }

    public static Set<CKEditorPlugin> resolve(Set<CKEditorPlugin> plugins) {
        return CKEditorPluginDependencies.resolve(plugins, true);
    }

    public static Set<CKEditorPlugin> resolve(Set<CKEditorPlugin> plugins, boolean includeCorePlugins) {
        EnumSet<CKEditorPlugin> resolved = EnumSet.noneOf(CKEditorPlugin.class);
        if (includeCorePlugins) {
            resolved.add(CKEditorPlugin.ESSENTIALS);
            resolved.add(CKEditorPlugin.PARAGRAPH);
        }
        for (CKEditorPlugin plugin : plugins) {
            CKEditorPluginDependencies.resolveTransitive(plugin, resolved);
        }
        return resolved;
    }

    public static Set<CKEditorPlugin> resolveWithRecommended(Set<CKEditorPlugin> plugins) {
        Set<CKEditorPlugin> resolved = CKEditorPluginDependencies.resolve(plugins, true);
        EnumSet<CKEditorPlugin> withRecommended = EnumSet.copyOf(resolved);
        for (CKEditorPlugin plugin : resolved) {
            Set<CKEditorPlugin> recommended = RECOMMENDED.get((Object)plugin);
            if (recommended == null) continue;
            for (CKEditorPlugin rec : recommended) {
                CKEditorPluginDependencies.resolveTransitive(rec, withRecommended);
            }
        }
        return withRecommended;
    }

    private static void resolveTransitive(CKEditorPlugin plugin, Set<CKEditorPlugin> resolved) {
        if (resolved.contains((Object)plugin)) {
            return;
        }
        Set<CKEditorPlugin> deps = DEPENDENCIES.get((Object)plugin);
        if (deps != null) {
            for (CKEditorPlugin dep : deps) {
                CKEditorPluginDependencies.resolveTransitive(dep, resolved);
            }
        }
        resolved.add(plugin);
    }

    public static Set<CKEditorPlugin> getDependents(CKEditorPlugin plugin) {
        EnumSet<CKEditorPlugin> dependents = EnumSet.noneOf(CKEditorPlugin.class);
        for (Map.Entry<CKEditorPlugin, Set<CKEditorPlugin>> entry : DEPENDENCIES.entrySet()) {
            if (!entry.getValue().contains((Object)plugin)) continue;
            dependents.add(entry.getKey());
        }
        return dependents;
    }

    public static Set<CKEditorPlugin> checkRemovalImpact(CKEditorPlugin plugin, Set<CKEditorPlugin> currentPlugins) {
        EnumSet<CKEditorPlugin> broken = EnumSet.noneOf(CKEditorPlugin.class);
        for (CKEditorPlugin p : currentPlugins) {
            Set<CKEditorPlugin> deps = DEPENDENCIES.get((Object)p);
            if (deps == null || !deps.contains((Object)plugin)) continue;
            broken.add(p);
        }
        return broken;
    }

    public static Map<CKEditorPlugin, Set<CKEditorPlugin>> validateDependencies(Set<CKEditorPlugin> plugins) {
        EnumMap<CKEditorPlugin, Set<CKEditorPlugin>> missing = new EnumMap<CKEditorPlugin, Set<CKEditorPlugin>>(CKEditorPlugin.class);
        for (CKEditorPlugin plugin : plugins) {
            Set<CKEditorPlugin> deps = DEPENDENCIES.get((Object)plugin);
            if (deps == null) continue;
            EnumSet<CKEditorPlugin> missingDeps = EnumSet.noneOf(CKEditorPlugin.class);
            for (CKEditorPlugin dep : deps) {
                if (plugins.contains((Object)dep)) continue;
                missingDeps.add(dep);
            }
            if (missingDeps.isEmpty()) continue;
            missing.put(plugin, missingDeps);
        }
        return missing;
    }

    public static List<CKEditorPlugin> topologicalSort(Set<CKEditorPlugin> plugins) {
        ArrayList<CKEditorPlugin> sorted = new ArrayList<CKEditorPlugin>();
        EnumSet<CKEditorPlugin> visited = EnumSet.noneOf(CKEditorPlugin.class);
        EnumSet<CKEditorPlugin> visiting = EnumSet.noneOf(CKEditorPlugin.class);
        for (CKEditorPlugin plugin : plugins) {
            if (visited.contains((Object)plugin)) continue;
            CKEditorPluginDependencies.topologicalSortVisit(plugin, plugins, visited, visiting, sorted);
        }
        return sorted;
    }

    private static void topologicalSortVisit(CKEditorPlugin plugin, Set<CKEditorPlugin> plugins, Set<CKEditorPlugin> visited, Set<CKEditorPlugin> visiting, List<CKEditorPlugin> sorted) {
        if (visiting.contains((Object)plugin)) {
            logger.log(Level.WARNING, "Circular dependency detected involving plugin: {0}", plugin.getJsName());
            return;
        }
        if (visited.contains((Object)plugin)) {
            return;
        }
        visiting.add(plugin);
        Set<CKEditorPlugin> deps = DEPENDENCIES.get((Object)plugin);
        if (deps != null) {
            for (CKEditorPlugin dep : deps) {
                if (!plugins.contains((Object)dep)) continue;
                CKEditorPluginDependencies.topologicalSortVisit(dep, plugins, visited, visiting, sorted);
            }
        }
        visiting.remove((Object)plugin);
        visited.add(plugin);
        sorted.add(plugin);
    }

    public static String getDependencyTree(CKEditorPlugin plugin) {
        StringBuilder sb = new StringBuilder();
        CKEditorPluginDependencies.buildDependencyTree(plugin, sb, "", true, EnumSet.noneOf(CKEditorPlugin.class));
        return sb.toString();
    }

    private static void buildDependencyTree(CKEditorPlugin plugin, StringBuilder sb, String prefix, boolean isLast, Set<CKEditorPlugin> visited) {
        sb.append(prefix);
        sb.append(isLast ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ");
        sb.append(plugin.getJsName());
        if (visited.contains((Object)plugin)) {
            sb.append(" (circular)");
            sb.append("\n");
            return;
        }
        sb.append("\n");
        visited.add(plugin);
        Set<CKEditorPlugin> deps = DEPENDENCIES.get((Object)plugin);
        if (deps != null && !deps.isEmpty()) {
            ArrayList<CKEditorPlugin> depList = new ArrayList<CKEditorPlugin>(deps);
            for (int i = 0; i < depList.size(); ++i) {
                String newPrefix = prefix + (isLast ? "    " : "\u2502   ");
                CKEditorPluginDependencies.buildDependencyTree((CKEditorPlugin)((Object)depList.get(i)), sb, newPrefix, i == depList.size() - 1, visited);
            }
        }
        visited.remove((Object)plugin);
    }

    public static List<CKEditorPlugin> getLoadOrder(Set<CKEditorPlugin> plugins) {
        Set<CKEditorPlugin> resolved = CKEditorPluginDependencies.resolve(plugins);
        return CKEditorPluginDependencies.topologicalSort(resolved);
    }

    public static Set<CKEditorPlugin> getPremiumDependencies(String premiumPluginName) {
        return PREMIUM_DEPENDENCIES.getOrDefault(premiumPluginName, Collections.emptySet());
    }

    public static boolean requiresCloudServices(String premiumPluginName) {
        return CLOUD_SERVICES_REQUIRED_PLUGINS.contains(premiumPluginName);
    }

    public static boolean hasPremiumDependencies(String premiumPluginName) {
        Set<CKEditorPlugin> deps = PREMIUM_DEPENDENCIES.get(premiumPluginName);
        return deps != null && !deps.isEmpty();
    }

    public static Set<CKEditorPlugin> resolveWithPremium(Set<CKEditorPlugin> plugins, Collection<CustomPlugin> customPlugins) {
        return CKEditorPluginDependencies.resolveWithPremium(plugins, customPlugins, true);
    }

    public static Set<CKEditorPlugin> resolveWithPremium(Set<CKEditorPlugin> plugins, Collection<CustomPlugin> customPlugins, boolean includeCorePlugins) {
        Set<CKEditorPlugin> resolved = CKEditorPluginDependencies.resolve(plugins, includeCorePlugins);
        if (customPlugins != null) {
            for (CustomPlugin customPlugin : customPlugins) {
                Set<CKEditorPlugin> premiumDeps = CKEditorPluginDependencies.getPremiumDependencies(customPlugin.getJsName());
                for (CKEditorPlugin dep : premiumDeps) {
                    CKEditorPluginDependencies.resolveTransitive(dep, resolved);
                }
            }
        }
        return resolved;
    }

    public static Set<String> getPremiumDependents(CKEditorPlugin plugin, Set<String> premiumPluginNames) {
        HashSet<String> dependents = new HashSet<String>();
        for (String premiumName : premiumPluginNames) {
            Set<CKEditorPlugin> deps = PREMIUM_DEPENDENCIES.get(premiumName);
            if (deps == null || !deps.contains((Object)plugin)) continue;
            dependents.add(premiumName);
        }
        return dependents;
    }

    public static Map<String, Set<CKEditorPlugin>> validatePremiumDependencies(Set<CKEditorPlugin> plugins, Collection<CustomPlugin> customPlugins) {
        HashMap<String, Set<CKEditorPlugin>> missing = new HashMap<String, Set<CKEditorPlugin>>();
        if (customPlugins == null) {
            return missing;
        }
        for (CustomPlugin customPlugin : customPlugins) {
            Set<CKEditorPlugin> deps = PREMIUM_DEPENDENCIES.get(customPlugin.getJsName());
            if (deps == null) continue;
            EnumSet<CKEditorPlugin> missingDeps = EnumSet.noneOf(CKEditorPlugin.class);
            for (CKEditorPlugin dep : deps) {
                if (plugins.contains((Object)dep)) continue;
                missingDeps.add(dep);
            }
            if (missingDeps.isEmpty()) continue;
            missing.put(customPlugin.getJsName(), missingDeps);
        }
        return missing;
    }

    public static Set<String> getKnownPremiumPlugins() {
        return Collections.unmodifiableSet(PREMIUM_DEPENDENCIES.keySet());
    }

    public static Set<String> getCloudServicesRequiredPlugins() {
        return CLOUD_SERVICES_REQUIRED_PLUGINS;
    }

    static {
        EnumMap<CKEditorPlugin, Set<CKEditorPlugin>> deps = new EnumMap<CKEditorPlugin, Set<CKEditorPlugin>>(CKEditorPlugin.class);
        deps.put(CKEditorPlugin.IMAGE_TOOLBAR, Set.of(CKEditorPlugin.IMAGE));
        deps.put(CKEditorPlugin.IMAGE_CAPTION, Set.of(CKEditorPlugin.IMAGE));
        deps.put(CKEditorPlugin.IMAGE_STYLE, Set.of(CKEditorPlugin.IMAGE));
        deps.put(CKEditorPlugin.IMAGE_RESIZE, Set.of(CKEditorPlugin.IMAGE));
        deps.put(CKEditorPlugin.IMAGE_UPLOAD, Set.of(CKEditorPlugin.IMAGE));
        deps.put(CKEditorPlugin.IMAGE_INSERT, Set.of(CKEditorPlugin.IMAGE));
        deps.put(CKEditorPlugin.IMAGE_BLOCK, Set.of(CKEditorPlugin.IMAGE));
        deps.put(CKEditorPlugin.IMAGE_INLINE, Set.of(CKEditorPlugin.IMAGE));
        deps.put(CKEditorPlugin.LINK_IMAGE, Set.of(CKEditorPlugin.IMAGE, CKEditorPlugin.LINK));
        deps.put(CKEditorPlugin.AUTO_IMAGE, Set.of(CKEditorPlugin.IMAGE, CKEditorPlugin.CLIPBOARD));
        deps.put(CKEditorPlugin.TABLE_TOOLBAR, Set.of(CKEditorPlugin.TABLE));
        deps.put(CKEditorPlugin.TABLE_PROPERTIES, Set.of(CKEditorPlugin.TABLE));
        deps.put(CKEditorPlugin.TABLE_CELL_PROPERTIES, Set.of(CKEditorPlugin.TABLE));
        deps.put(CKEditorPlugin.TABLE_CAPTION, Set.of(CKEditorPlugin.TABLE));
        deps.put(CKEditorPlugin.TABLE_COLUMN_RESIZE, Set.of(CKEditorPlugin.TABLE));
        deps.put(CKEditorPlugin.AUTO_LINK, Set.of(CKEditorPlugin.LINK));
        deps.put(CKEditorPlugin.TODO_LIST, Set.of(CKEditorPlugin.LIST));
        deps.put(CKEditorPlugin.INDENT_BLOCK, Set.of(CKEditorPlugin.INDENT));
        deps.put(CKEditorPlugin.SPECIAL_CHARACTERS_ESSENTIALS, Set.of(CKEditorPlugin.SPECIAL_CHARACTERS));
        deps.put(CKEditorPlugin.STYLE, Set.of(CKEditorPlugin.GENERAL_HTML_SUPPORT));
        deps.put(CKEditorPlugin.HTML_COMMENT, Set.of(CKEditorPlugin.GENERAL_HTML_SUPPORT));
        deps.put(CKEditorPlugin.HTML_EMBED, Set.of(CKEditorPlugin.GENERAL_HTML_SUPPORT));
        deps.put(CKEditorPlugin.SOURCE_EDITING, Set.of(CKEditorPlugin.GENERAL_HTML_SUPPORT));
        deps.put(CKEditorPlugin.SIMPLE_UPLOAD_ADAPTER, Set.of(CKEditorPlugin.IMAGE_UPLOAD));
        deps.put(CKEditorPlugin.BASE64_UPLOAD_ADAPTER, Set.of(CKEditorPlugin.IMAGE_UPLOAD));
        deps.put(CKEditorPlugin.STANDARD_EDITING_MODE, Set.of(CKEditorPlugin.RESTRICTED_EDITING_MODE));
        deps.put(CKEditorPlugin.CLOUD_SERVICES_UPLOAD_ADAPTER, Set.of(CKEditorPlugin.CLOUD_SERVICES));
        deps.put(CKEditorPlugin.CLOUD_SERVICES, Set.of(CKEditorPlugin.CLOUD_SERVICES_CORE));
        deps.put(CKEditorPlugin.EASY_IMAGE, Set.of(CKEditorPlugin.CLOUD_SERVICES, CKEditorPlugin.IMAGE_UPLOAD));
        deps.put(CKEditorPlugin.MINIMAP, Set.of(CKEditorPlugin.WIDGET));
        deps.put(CKEditorPlugin.EMOJI_PICKER, Set.of(CKEditorPlugin.EMOJI));
        deps.put(CKEditorPlugin.SPECIAL_CHARACTERS_ARROWS, Set.of(CKEditorPlugin.SPECIAL_CHARACTERS));
        deps.put(CKEditorPlugin.SPECIAL_CHARACTERS_CURRENCY, Set.of(CKEditorPlugin.SPECIAL_CHARACTERS));
        deps.put(CKEditorPlugin.SPECIAL_CHARACTERS_LATIN, Set.of(CKEditorPlugin.SPECIAL_CHARACTERS));
        deps.put(CKEditorPlugin.SPECIAL_CHARACTERS_MATHEMATICAL, Set.of(CKEditorPlugin.SPECIAL_CHARACTERS));
        deps.put(CKEditorPlugin.SPECIAL_CHARACTERS_TEXT, Set.of(CKEditorPlugin.SPECIAL_CHARACTERS));
        deps.put(CKEditorPlugin.LIST_PROPERTIES, Set.of(CKEditorPlugin.LIST));
        deps.put(CKEditorPlugin.LIST_FORMATTING, Set.of(CKEditorPlugin.LIST));
        deps.put(CKEditorPlugin.ADJACENT_LISTS_SUPPORT, Set.of(CKEditorPlugin.LIST));
        DEPENDENCIES = Collections.unmodifiableMap(deps);
        EnumMap<CKEditorPlugin, Set<CKEditorPlugin>> rec = new EnumMap<CKEditorPlugin, Set<CKEditorPlugin>>(CKEditorPlugin.class);
        rec.put(CKEditorPlugin.IMAGE, Set.of(CKEditorPlugin.IMAGE_TOOLBAR, CKEditorPlugin.IMAGE_CAPTION, CKEditorPlugin.IMAGE_STYLE, CKEditorPlugin.IMAGE_RESIZE));
        rec.put(CKEditorPlugin.TABLE, Set.of(CKEditorPlugin.TABLE_TOOLBAR, CKEditorPlugin.TABLE_PROPERTIES, CKEditorPlugin.TABLE_CELL_PROPERTIES));
        rec.put(CKEditorPlugin.LINK, Set.of(CKEditorPlugin.AUTO_LINK));
        rec.put(CKEditorPlugin.HEADING, Set.of(CKEditorPlugin.PARAGRAPH));
        rec.put(CKEditorPlugin.CODE_BLOCK, Set.of(CKEditorPlugin.AUTOFORMAT));
        rec.put(CKEditorPlugin.SPECIAL_CHARACTERS, Set.of(CKEditorPlugin.SPECIAL_CHARACTERS_ESSENTIALS));
        rec.put(CKEditorPlugin.SOURCE_EDITING, Set.of(CKEditorPlugin.GENERAL_HTML_SUPPORT, CKEditorPlugin.HTML_EMBED));
        rec.put(CKEditorPlugin.STYLE, Set.of(CKEditorPlugin.GENERAL_HTML_SUPPORT));
        rec.put(CKEditorPlugin.INDENT, Set.of(CKEditorPlugin.INDENT_BLOCK));
        rec.put(CKEditorPlugin.CLOUD_SERVICES, Set.of(CKEditorPlugin.CLOUD_SERVICES_UPLOAD_ADAPTER));
        rec.put(CKEditorPlugin.EMOJI, Set.of(CKEditorPlugin.EMOJI_PICKER));
        rec.put(CKEditorPlugin.LIST, Set.of(CKEditorPlugin.LIST_PROPERTIES, CKEditorPlugin.TODO_LIST));
        RECOMMENDED = Collections.unmodifiableMap(rec);
        CLOUD_SERVICES_REQUIRED_PLUGINS = Set.of("ExportPdf", "ExportWord", "ImportWord");
        HashMap premDeps = new HashMap();
        Set<CKEditorPlugin> cloudServicesDeps = Set.of(CKEditorPlugin.CLOUD_SERVICES);
        premDeps.put("ExportPdf", cloudServicesDeps);
        premDeps.put("ExportWord", cloudServicesDeps);
        premDeps.put("ImportWord", cloudServicesDeps);
        premDeps.put("AIAssistant", cloudServicesDeps);
        premDeps.put("Pagination", Set.of());
        premDeps.put("MultiLevelList", Set.of(CKEditorPlugin.LIST));
        premDeps.put("PasteFromOfficeEnhanced", Set.of(CKEditorPlugin.PASTE_FROM_OFFICE));
        premDeps.put("TrackChangesData", Set.of());
        premDeps.put("TrackChangesPreview", Set.of());
        premDeps.put("RealTimeCollaboration", cloudServicesDeps);
        premDeps.put("PresenceList", Set.of(CKEditorPlugin.CLOUD_SERVICES));
        premDeps.put("CKBox", cloudServicesDeps);
        premDeps.put("CKBoxImageEdit", Set.of(CKEditorPlugin.CLOUD_SERVICES));
        PREMIUM_DEPENDENCIES = Collections.unmodifiableMap(premDeps);
    }
}

