/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor;

import com.wontlost.ckeditor.JsonUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class CKEditorConfig {
    private final Map<String, JsonNode> configs = new LinkedHashMap<String, JsonNode>();
    private boolean allowPrivateNetworks = false;
    private static final Set<String> ALLOWED_URL_PROTOCOLS = Set.of("http", "https");
    private static final Pattern OBFUSCATED_IP_PATTERN = Pattern.compile("^(0[0-7]+|0x[0-9a-f]+)(\\.(0[0-7]+|0x[0-9a-f]+|\\d+)){0,3}$", 2);
    private static final Pattern PRIVATE_CLASS_B_PATTERN = Pattern.compile("^172\\.(1[6-9]|2[0-9]|3[01])\\.");
    private static final int MIN_AUTOSAVE_WAITING_TIME = 100;
    private static final int MAX_AUTOSAVE_WAITING_TIME = 60000;
    private static final Pattern SAFE_CSS_VALUE_PATTERN = Pattern.compile("^(#[0-9a-fA-F]{3,8}|rgba?\\s*\\(\\s*[0-9.,\\s%]+\\s*\\)|hsla?\\s*\\(\\s*[0-9.,\\s%deg]+\\s*\\)|[a-zA-Z]+|-?[0-9.]+(?:px|em|rem|%|pt|vh|vw|vmin|vmax|ch|ex)?|transparent|inherit|initial|unset|none|auto)$", 2);

    public CKEditorConfig() {
        this.setPlaceholder("");
        this.setLanguage("en");
    }

    public CKEditorConfig setPlaceholder(String placeholder) {
        this.configs.put("placeholder", JsonUtil.getMapper().valueToTree((Object)(placeholder != null ? placeholder : "")));
        return this;
    }

    public CKEditorConfig setLanguage(String language) {
        this.configs.put("language", JsonUtil.getMapper().valueToTree((Object)(language != null ? language : "en")));
        return this;
    }

    public CKEditorConfig setLanguage(String uiLanguage, String contentLanguage, String[] textPartLanguages) {
        ArrayNode textPartArr;
        ObjectNode langObj = JsonUtil.createObjectNode();
        langObj.put("ui", uiLanguage != null ? uiLanguage : "en");
        if (contentLanguage != null) {
            langObj.put("content", contentLanguage);
        }
        if ((textPartArr = JsonUtil.toArrayNodeOrNull(textPartLanguages)) != null) {
            langObj.set("textPartLanguage", (JsonNode)textPartArr);
        }
        this.configs.put("language", (JsonNode)langObj);
        return this;
    }

    public CKEditorConfig setToolbar(String ... items) {
        if (JsonUtil.hasElements(items)) {
            this.configs.put("toolbar", (JsonNode)JsonUtil.toArrayNode(items));
        }
        return this;
    }

    public CKEditorConfig setToolbar(String[] items, boolean shouldNotGroupWhenFull) {
        if (JsonUtil.hasElements(items)) {
            ObjectNode toolbarObj = JsonUtil.createObjectNode();
            toolbarObj.set("items", (JsonNode)JsonUtil.toArrayNode(items));
            toolbarObj.put("shouldNotGroupWhenFull", shouldNotGroupWhenFull);
            this.configs.put("toolbar", (JsonNode)toolbarObj);
        }
        return this;
    }

    public CKEditorConfig setHeading(HeadingOption ... options) {
        if (JsonUtil.hasElements(options)) {
            ObjectNode headingObj = JsonUtil.createObjectNode();
            ArrayNode optionsArr = JsonUtil.createArrayNode();
            for (HeadingOption option : options) {
                optionsArr.add((JsonNode)option.toJson());
            }
            headingObj.set("options", (JsonNode)optionsArr);
            this.configs.put("heading", (JsonNode)headingObj);
        }
        return this;
    }

    public CKEditorConfig setFontSize(String ... sizes) {
        return this.setFontSize(false, sizes);
    }

    public CKEditorConfig setFontSize(boolean supportAllValues, String ... sizes) {
        ObjectNode fontSizeObj = JsonUtil.createObjectNode();
        fontSizeObj.put("supportAllValues", supportAllValues);
        ArrayNode arr = JsonUtil.toArrayNodeOrNull(sizes);
        if (arr != null) {
            fontSizeObj.set("options", (JsonNode)arr);
        }
        this.configs.put("fontSize", (JsonNode)fontSizeObj);
        return this;
    }

    public CKEditorConfig setFontFamily(String ... families) {
        return this.setFontFamily(false, families);
    }

    public CKEditorConfig setFontFamily(boolean supportAllValues, String ... families) {
        ObjectNode fontFamilyObj = JsonUtil.createObjectNode();
        fontFamilyObj.put("supportAllValues", supportAllValues);
        ArrayNode arr = JsonUtil.toArrayNodeOrNull(families);
        if (arr != null) {
            fontFamilyObj.set("options", (JsonNode)arr);
        }
        this.configs.put("fontFamily", (JsonNode)fontFamilyObj);
        return this;
    }

    public CKEditorConfig setAlignment(String ... options) {
        if (JsonUtil.hasElements(options)) {
            ObjectNode alignObj = JsonUtil.createObjectNode();
            alignObj.set("options", (JsonNode)JsonUtil.toArrayNode(options));
            this.configs.put("alignment", (JsonNode)alignObj);
        }
        return this;
    }

    public CKEditorConfig setLink(String defaultProtocol, boolean addTargetToExternalLinks) {
        ObjectNode linkObj = JsonUtil.createObjectNode();
        if (defaultProtocol != null) {
            linkObj.put("defaultProtocol", defaultProtocol);
        }
        linkObj.put("addTargetToExternalLinks", addTargetToExternalLinks);
        this.configs.put("link", (JsonNode)linkObj);
        return this;
    }

    public CKEditorConfig setImage(String[] toolbar, String[] styles) {
        ArrayNode stylesArr;
        ObjectNode imageObj = JsonUtil.createObjectNode();
        ArrayNode toolbarArr = JsonUtil.toArrayNodeOrNull(toolbar);
        if (toolbarArr != null) {
            imageObj.set("toolbar", (JsonNode)toolbarArr);
        }
        if ((stylesArr = JsonUtil.toArrayNodeOrNull(styles)) != null) {
            imageObj.set("styles", (JsonNode)stylesArr);
        }
        this.configs.put("image", (JsonNode)imageObj);
        return this;
    }

    public CKEditorConfig setTable(String[] contentToolbar) {
        if (JsonUtil.hasElements(contentToolbar)) {
            ObjectNode tableObj = JsonUtil.createObjectNode();
            tableObj.set("contentToolbar", (JsonNode)JsonUtil.toArrayNode(contentToolbar));
            this.configs.put("table", (JsonNode)tableObj);
        }
        return this;
    }

    public CKEditorConfig setCodeBlock(String indentSequence, CodeBlockLanguage ... languages) {
        ObjectNode codeBlockObj = JsonUtil.createObjectNode();
        if (indentSequence != null) {
            codeBlockObj.put("indentSequence", indentSequence);
        }
        if (JsonUtil.hasElements(languages)) {
            ArrayNode arr = JsonUtil.createArrayNode();
            for (CodeBlockLanguage lang : languages) {
                arr.add((JsonNode)lang.toJson());
            }
            codeBlockObj.set("languages", (JsonNode)arr);
        }
        this.configs.put("codeBlock", (JsonNode)codeBlockObj);
        return this;
    }

    public CKEditorConfig setMediaEmbed(boolean previewsInData) {
        ObjectNode mediaObj = JsonUtil.createObjectNode();
        mediaObj.put("previewsInData", previewsInData);
        this.configs.put("mediaEmbed", (JsonNode)mediaObj);
        return this;
    }

    public CKEditorConfig setPagination(String pageWidth, String pageHeight, PaginationMargins pageMargins) {
        ObjectNode paginationObj = JsonUtil.createObjectNode();
        if (pageWidth != null) {
            paginationObj.put("pageWidth", pageWidth);
        }
        if (pageHeight != null) {
            paginationObj.put("pageHeight", pageHeight);
        }
        if (pageMargins != null) {
            paginationObj.set("pageMargins", (JsonNode)pageMargins.toJson());
        }
        this.configs.put("pagination", (JsonNode)paginationObj);
        return this;
    }

    public CKEditorConfig setMention(MentionFeed ... feeds) {
        if (JsonUtil.hasElements(feeds)) {
            ObjectNode mentionObj = JsonUtil.createObjectNode();
            ArrayNode feedsArr = JsonUtil.createArrayNode();
            for (MentionFeed feed : feeds) {
                feedsArr.add((JsonNode)feed.toJson());
            }
            mentionObj.set("feeds", (JsonNode)feedsArr);
            this.configs.put("mention", (JsonNode)mentionObj);
        }
        return this;
    }

    public CKEditorConfig setSimpleUpload(String uploadUrl) {
        return this.setSimpleUpload(uploadUrl, null, false);
    }

    public CKEditorConfig setSimpleUpload(String uploadUrl, Map<String, String> headers) {
        return this.setSimpleUpload(uploadUrl, headers, false);
    }

    public CKEditorConfig setSimpleUpload(String uploadUrl, Map<String, String> headers, boolean withCredentials) {
        if (uploadUrl == null || uploadUrl.isBlank()) {
            throw new IllegalArgumentException("uploadUrl must not be null or blank");
        }
        this.validateUploadUrl(uploadUrl);
        ObjectNode uploadObj = JsonUtil.createObjectNode();
        uploadObj.put("uploadUrl", uploadUrl);
        if (headers != null && !headers.isEmpty()) {
            ObjectNode headersObj = JsonUtil.createObjectNode();
            headers.forEach((arg_0, arg_1) -> ((ObjectNode)headersObj).put(arg_0, arg_1));
            uploadObj.set("headers", (JsonNode)headersObj);
        }
        if (withCredentials) {
            uploadObj.put("withCredentials", true);
        }
        this.configs.put("simpleUpload", (JsonNode)uploadObj);
        return this;
    }

    public CKEditorConfig allowPrivateNetworks(boolean allow) {
        this.allowPrivateNetworks = allow;
        return this;
    }

    public boolean isAllowPrivateNetworks() {
        return this.allowPrivateNetworks;
    }

    private void validateUploadUrl(String uploadUrl) {
        try {
            URI uri = new URI(uploadUrl);
            String scheme = uri.getScheme();
            if (scheme == null) {
                return;
            }
            String protocol = scheme.toLowerCase(Locale.ROOT);
            if (!ALLOWED_URL_PROTOCOLS.contains(protocol)) {
                throw new IllegalArgumentException("Upload URL protocol must be one of " + String.valueOf(ALLOWED_URL_PROTOCOLS) + ", got: " + protocol);
            }
            String host = uri.getHost();
            if (host == null) {
                throw new IllegalArgumentException("Upload URL must have a valid host");
            }
            if (!this.allowPrivateNetworks && this.isPrivateNetworkAddress(host)) {
                throw new IllegalArgumentException("Upload URL must not point to internal/private network addresses: " + host + ". Use allowPrivateNetworks(true) for development environments.");
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid upload URL format: " + uploadUrl, e);
        }
    }

    private boolean isPrivateNetworkAddress(String host) {
        String lowerHost = host.toLowerCase(Locale.ROOT);
        if (lowerHost.equals("localhost") || lowerHost.startsWith("127.") || lowerHost.startsWith("192.168.") || lowerHost.startsWith("10.") || this.isPrivateClassBAddress(lowerHost) || lowerHost.endsWith(".local") || lowerHost.endsWith(".internal")) {
            return true;
        }
        if (lowerHost.equals("0.0.0.0")) {
            return true;
        }
        if (lowerHost.startsWith("169.254.")) {
            return true;
        }
        if (lowerHost.equals("::1") || lowerHost.equals("[::1]")) {
            return true;
        }
        if (this.isIPv4MappedIPv6PrivateAddress(lowerHost)) {
            return true;
        }
        if (this.isIPv4CompatibleIPv6PrivateAddress(lowerHost)) {
            return true;
        }
        if (this.isSIITIPv6PrivateAddress(lowerHost)) {
            return true;
        }
        if (lowerHost.startsWith("fe80:") || lowerHost.startsWith("[fe80:")) {
            return true;
        }
        if (lowerHost.startsWith("fc") || lowerHost.startsWith("fd") || lowerHost.startsWith("[fc") || lowerHost.startsWith("[fd")) {
            return true;
        }
        return this.isObfuscatedPrivateIPv4(lowerHost);
    }

    private boolean isIPv4MappedIPv6PrivateAddress(String host) {
        String cleanHost = host.replace("[", "").replace("]", "");
        if (!cleanHost.startsWith("::ffff:")) {
            return false;
        }
        String ipv4Part = cleanHost.substring(7);
        return this.isPrivateIPv4String(ipv4Part);
    }

    private boolean isIPv4CompatibleIPv6PrivateAddress(String host) {
        String cleanHost = host.replace("[", "").replace("]", "");
        if (!cleanHost.startsWith("::") || cleanHost.startsWith("::ffff:")) {
            return false;
        }
        String remainder = cleanHost.substring(2);
        if (!remainder.contains(".")) {
            return false;
        }
        return this.isPrivateIPv4String(remainder);
    }

    private boolean isSIITIPv6PrivateAddress(String host) {
        String cleanHost = host.replace("[", "").replace("]", "");
        if (!cleanHost.startsWith("::ffff:0:")) {
            return false;
        }
        String ipv4Part = cleanHost.substring(9);
        return this.isPrivateIPv4String(ipv4Part);
    }

    private boolean isPrivateIPv4String(String ipv4) {
        return ipv4.startsWith("127.") || ipv4.startsWith("192.168.") || ipv4.startsWith("10.") || this.isPrivateClassBAddress(ipv4) || ipv4.equals("0.0.0.0") || ipv4.startsWith("169.254.");
    }

    private boolean isObfuscatedPrivateIPv4(String host) {
        if (!OBFUSCATED_IP_PATTERN.matcher(host).matches()) {
            return false;
        }
        try {
            String[] parts = host.split("\\.");
            int[] octets = new int[4];
            int partIndex = 0;
            for (String part : parts) {
                if (partIndex >= 4) break;
                int value = part.startsWith("0x") || part.startsWith("0X") ? Integer.parseInt(part.substring(2), 16) : (part.startsWith("0") && part.length() > 1 ? Integer.parseInt(part, 8) : Integer.parseInt(part));
                octets[partIndex++] = value;
            }
            while (partIndex < 4) {
                octets[partIndex++] = 0;
            }
            return this.isPrivateIPv4Octets(octets);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isPrivateIPv4Octets(int[] octets) {
        if (octets[0] == 127) {
            return true;
        }
        if (octets[0] == 10) {
            return true;
        }
        if (octets[0] == 192 && octets[1] == 168) {
            return true;
        }
        if (octets[0] == 172 && octets[1] >= 16 && octets[1] <= 31) {
            return true;
        }
        if (octets[0] == 0 && octets[1] == 0 && octets[2] == 0 && octets[3] == 0) {
            return true;
        }
        return octets[0] == 169 && octets[1] == 254;
    }

    private boolean isPrivateClassBAddress(String host) {
        return PRIVATE_CLASS_B_PATTERN.matcher(host).find();
    }

    public CKEditorConfig setAutosave(int waitingTime) {
        if (waitingTime < 100 || waitingTime > 60000) {
            throw new IllegalArgumentException("Autosave waiting time must be between 100 and 60000 milliseconds, got: " + waitingTime);
        }
        ObjectNode autosaveObj = JsonUtil.createObjectNode();
        autosaveObj.put("waitingTime", waitingTime);
        this.configs.put("autosave", (JsonNode)autosaveObj);
        return this;
    }

    public CKEditorConfig setLicenseKey(String licenseKey) {
        if (licenseKey != null && !licenseKey.isBlank()) {
            this.configs.put("licenseKey", JsonUtil.getMapper().valueToTree((Object)licenseKey));
        }
        return this;
    }

    public CKEditorConfig setStyle(StyleDefinition ... definitions) {
        if (JsonUtil.hasElements(definitions)) {
            ObjectNode styleObj = JsonUtil.createObjectNode();
            ArrayNode definitionsArr = JsonUtil.createArrayNode();
            for (StyleDefinition def : definitions) {
                definitionsArr.add((JsonNode)def.toJson());
            }
            styleObj.set("definitions", (JsonNode)definitionsArr);
            this.configs.put("style", (JsonNode)styleObj);
        }
        return this;
    }

    public CKEditorConfig setHtmlSupport(boolean allowAll) {
        ObjectNode htmlSupportObj = JsonUtil.createObjectNode();
        if (allowAll) {
            ArrayNode allowArr = JsonUtil.createArrayNode();
            ObjectNode allowAllObj = JsonUtil.createObjectNode();
            allowAllObj.put("name", "/.*/");
            allowAllObj.put("attributes", true);
            allowAllObj.put("classes", true);
            allowAllObj.put("styles", true);
            allowArr.add((JsonNode)allowAllObj);
            htmlSupportObj.set("allow", (JsonNode)allowArr);
        }
        this.configs.put("htmlSupport", (JsonNode)htmlSupportObj);
        return this;
    }

    public CKEditorConfig setToolbarStyle(ToolbarStyle style) {
        if (style != null) {
            this.configs.put("toolbarStyle", (JsonNode)style.toJson());
        }
        return this;
    }

    public CKEditorConfig setUiViewportOffset(double top, double right, double bottom, double left) {
        ObjectNode uiObj = JsonUtil.createObjectNode();
        ObjectNode viewportOffset = JsonUtil.createObjectNode();
        viewportOffset.put("top", top);
        viewportOffset.put("right", right);
        viewportOffset.put("bottom", bottom);
        viewportOffset.put("left", left);
        uiObj.set("viewportOffset", (JsonNode)viewportOffset);
        this.configs.put("ui", (JsonNode)uiObj);
        return this;
    }

    public CKEditorConfig set(String key, JsonNode value) {
        this.configs.put(key, value);
        return this;
    }

    public Map<String, JsonNode> getConfigs() {
        return Collections.unmodifiableMap(this.configs);
    }

    public ObjectNode toJson() {
        ObjectNode json = JsonUtil.createObjectNode();
        this.configs.forEach((arg_0, arg_1) -> ((ObjectNode)json).set(arg_0, arg_1));
        return json;
    }

    public String getPlaceholder() {
        JsonNode node = this.configs.get("placeholder");
        return node != null && node.isString() ? node.asString() : null;
    }

    public String getLanguage() {
        JsonNode node = this.configs.get("language");
        if (node == null) {
            return null;
        }
        if (node.isString()) {
            return node.asString();
        }
        if (node.isObject() && node.has("ui")) {
            return node.get("ui").asString();
        }
        return null;
    }

    public String[] getToolbar() {
        JsonNode node = this.configs.get("toolbar");
        if (node == null) {
            return null;
        }
        if (node.isArray()) {
            return CKEditorConfig.jsonArrayToStringArray(node);
        }
        if (node.isObject() && node.has("items")) {
            return CKEditorConfig.jsonArrayToStringArray(node.get("items"));
        }
        return null;
    }

    public boolean hasConfig(String key) {
        return this.configs.containsKey(key);
    }

    public String getString(String key) {
        JsonNode node = this.configs.get(key);
        return node != null && node.isString() ? node.asString() : null;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        JsonNode node = this.configs.get(key);
        return node != null && node.isBoolean() ? node.asBoolean() : defaultValue;
    }

    public int getInt(String key, int defaultValue) {
        JsonNode node = this.configs.get(key);
        return node != null && node.isNumber() ? node.asInt() : defaultValue;
    }

    public String getSimpleUploadUrl() {
        JsonNode node = this.configs.get("simpleUpload");
        if (node != null && node.isObject() && node.has("uploadUrl")) {
            return node.get("uploadUrl").asString();
        }
        return null;
    }

    public int getAutosaveWaitingTime() {
        JsonNode node = this.configs.get("autosave");
        if (node != null && node.isObject() && node.has("waitingTime")) {
            return node.get("waitingTime").asInt();
        }
        return -1;
    }

    public boolean hasAutosave() {
        return this.configs.containsKey("autosave");
    }

    public String getLicenseKey() {
        JsonNode node = this.configs.get("licenseKey");
        return node != null && node.isString() ? node.asString() : null;
    }

    public String[] getFontSizeOptions() {
        JsonNode node = this.configs.get("fontSize");
        if (node != null && node.isObject() && node.has("options")) {
            return CKEditorConfig.jsonArrayToStringArray(node.get("options"));
        }
        return null;
    }

    public boolean isFontSizeSupportAllValues() {
        JsonNode node = this.configs.get("fontSize");
        if (node != null && node.isObject() && node.has("supportAllValues")) {
            return node.get("supportAllValues").asBoolean();
        }
        return false;
    }

    public String[] getFontFamilyOptions() {
        JsonNode node = this.configs.get("fontFamily");
        if (node != null && node.isObject() && node.has("options")) {
            return CKEditorConfig.jsonArrayToStringArray(node.get("options"));
        }
        return null;
    }

    public boolean isFontFamilySupportAllValues() {
        JsonNode node = this.configs.get("fontFamily");
        if (node != null && node.isObject() && node.has("supportAllValues")) {
            return node.get("supportAllValues").asBoolean();
        }
        return false;
    }

    public String[] getAlignmentOptions() {
        JsonNode node = this.configs.get("alignment");
        if (node != null && node.isObject() && node.has("options")) {
            return CKEditorConfig.jsonArrayToStringArray(node.get("options"));
        }
        return null;
    }

    public String getLinkDefaultProtocol() {
        JsonNode node = this.configs.get("link");
        if (node != null && node.isObject() && node.has("defaultProtocol")) {
            return node.get("defaultProtocol").asString();
        }
        return null;
    }

    public boolean isLinkAddTargetToExternalLinks() {
        JsonNode node = this.configs.get("link");
        if (node != null && node.isObject() && node.has("addTargetToExternalLinks")) {
            return node.get("addTargetToExternalLinks").asBoolean();
        }
        return false;
    }

    public String[] getImageToolbar() {
        JsonNode node = this.configs.get("image");
        if (node != null && node.isObject() && node.has("toolbar")) {
            return CKEditorConfig.jsonArrayToStringArray(node.get("toolbar"));
        }
        return null;
    }

    public String[] getImageStyles() {
        JsonNode node = this.configs.get("image");
        if (node != null && node.isObject() && node.has("styles")) {
            return CKEditorConfig.jsonArrayToStringArray(node.get("styles"));
        }
        return null;
    }

    public String[] getTableContentToolbar() {
        JsonNode node = this.configs.get("table");
        if (node != null && node.isObject() && node.has("contentToolbar")) {
            return CKEditorConfig.jsonArrayToStringArray(node.get("contentToolbar"));
        }
        return null;
    }

    public String getCodeBlockIndentSequence() {
        JsonNode node = this.configs.get("codeBlock");
        if (node != null && node.isObject() && node.has("indentSequence")) {
            return node.get("indentSequence").asString();
        }
        return null;
    }

    public boolean isMediaEmbedPreviewsInData() {
        JsonNode node = this.configs.get("mediaEmbed");
        if (node != null && node.isObject() && node.has("previewsInData")) {
            return node.get("previewsInData").asBoolean();
        }
        return false;
    }

    public boolean isHtmlSupportAllowAll() {
        JsonNode allowNode;
        JsonNode node = this.configs.get("htmlSupport");
        if (node != null && node.isObject() && node.has("allow") && (allowNode = node.get("allow")).isArray() && !allowNode.isEmpty()) {
            JsonNode firstAllow = allowNode.get(0);
            return firstAllow.has("name") && "/.*/".equals(firstAllow.get("name").asString());
        }
        return false;
    }

    public ToolbarStyle getToolbarStyle() {
        JsonNode node = this.configs.get("toolbarStyle");
        if (node == null || !node.isObject()) {
            return null;
        }
        ToolbarStyle.Builder builder = ToolbarStyle.builder();
        if (node.has("background")) {
            builder.background(node.get("background").asString());
        }
        if (node.has("borderColor")) {
            builder.borderColor(node.get("borderColor").asString());
        }
        if (node.has("borderRadius")) {
            builder.borderRadius(node.get("borderRadius").asString());
        }
        if (node.has("buttonBackground")) {
            builder.buttonBackground(node.get("buttonBackground").asString());
        }
        if (node.has("buttonHoverBackground")) {
            builder.buttonHoverBackground(node.get("buttonHoverBackground").asString());
        }
        if (node.has("buttonActiveBackground")) {
            builder.buttonActiveBackground(node.get("buttonActiveBackground").asString());
        }
        if (node.has("buttonOnBackground")) {
            builder.buttonOnBackground(node.get("buttonOnBackground").asString());
        }
        if (node.has("buttonOnColor")) {
            builder.buttonOnColor(node.get("buttonOnColor").asString());
        }
        if (node.has("iconColor")) {
            builder.iconColor(node.get("iconColor").asString());
        }
        return builder.build();
    }

    public double[] getUiViewportOffset() {
        JsonNode offset;
        JsonNode node = this.configs.get("ui");
        if (node != null && node.isObject() && node.has("viewportOffset") && (offset = node.get("viewportOffset")).isObject()) {
            return new double[]{offset.has("top") ? offset.get("top").asDouble() : 0.0, offset.has("right") ? offset.get("right").asDouble() : 0.0, offset.has("bottom") ? offset.get("bottom").asDouble() : 0.0, offset.has("left") ? offset.get("left").asDouble() : 0.0};
        }
        return null;
    }

    public JsonNode getJsonNode(String key) {
        return this.configs.get(key);
    }

    public JsonNode getHeadingOptions() {
        JsonNode node = this.configs.get("heading");
        if (node != null && node.isObject() && node.has("options")) {
            return node.get("options");
        }
        return null;
    }

    public JsonNode getMentionFeeds() {
        JsonNode node = this.configs.get("mention");
        if (node != null && node.isObject() && node.has("feeds")) {
            return node.get("feeds");
        }
        return null;
    }

    public JsonNode getStyleDefinitions() {
        JsonNode node = this.configs.get("style");
        if (node != null && node.isObject() && node.has("definitions")) {
            return node.get("definitions");
        }
        return null;
    }

    public boolean isStrictPluginLoading() {
        JsonNode node = this.configs.get("strictPluginLoading");
        return node != null && node.asBoolean();
    }

    public boolean isAllowConfigRequiredPlugins() {
        JsonNode node = this.configs.get("allowConfigRequiredPlugins");
        return node != null && node.asBoolean();
    }

    private static String[] jsonArrayToStringArray(JsonNode arrayNode) {
        if (arrayNode == null || !arrayNode.isArray()) {
            return null;
        }
        String[] result = new String[arrayNode.size()];
        for (int i = 0; i < arrayNode.size(); ++i) {
            result[i] = arrayNode.get(i).asString();
        }
        return result;
    }

    private static void validateCssValue(String value, String propertyName) {
        if (value == null || value.isEmpty()) {
            return;
        }
        String lowerValue = value.toLowerCase(Locale.ROOT);
        if (lowerValue.contains("url(") || lowerValue.contains("expression(") || lowerValue.contains("javascript:") || lowerValue.contains("data:") || value.contains(";") || value.contains("{") || value.contains("}") || value.contains("/*") || value.contains("*/") || value.contains("\\")) {
            throw new IllegalArgumentException("CSS value for '" + propertyName + "' contains potentially dangerous content: " + value);
        }
        if (!SAFE_CSS_VALUE_PATTERN.matcher(value.trim()).matches()) {
            throw new IllegalArgumentException("CSS value for '" + propertyName + "' has invalid format: " + value + ". Allowed: color values (#hex, rgb, rgba, named), sizes (px, em, %), keywords (transparent, inherit).");
        }
    }

    public static class HeadingOption {
        private final String model;
        private final String view;
        private final String title;
        private final String className;

        public HeadingOption(String model, String view, String title, String className) {
            this.model = model;
            this.view = view;
            this.title = title;
            this.className = className;
        }

        public static HeadingOption paragraph(String title, String className) {
            return new HeadingOption("paragraph", null, title, className);
        }

        public static HeadingOption heading(int level, String title, String className) {
            return new HeadingOption("heading" + level, "h" + level, title, className);
        }

        public ObjectNode toJson() {
            ObjectNode obj = JsonUtil.createObjectNode();
            obj.put("model", this.model);
            if (this.view != null) {
                obj.put("view", this.view);
            }
            obj.put("title", this.title);
            obj.put("class", this.className);
            return obj;
        }
    }

    public static class CodeBlockLanguage {
        private final String language;
        private final String label;
        private final String className;

        public CodeBlockLanguage(String language, String label, String className) {
            this.language = language;
            this.label = label;
            this.className = className;
        }

        public static CodeBlockLanguage of(String language, String label) {
            return new CodeBlockLanguage(language, label, null);
        }

        public static CodeBlockLanguage of(String language, String label, String className) {
            return new CodeBlockLanguage(language, label, className);
        }

        public ObjectNode toJson() {
            ObjectNode obj = JsonUtil.createObjectNode();
            obj.put("language", this.language);
            obj.put("label", this.label);
            if (this.className != null) {
                obj.put("class", this.className);
            }
            return obj;
        }
    }

    public static class PaginationMargins {
        private final String top;
        private final String right;
        private final String bottom;
        private final String left;

        public PaginationMargins(String top, String right, String bottom, String left) {
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.left = left;
        }

        ObjectNode toJson() {
            ObjectNode obj = JsonUtil.createObjectNode();
            if (this.top != null) {
                obj.put("top", this.top);
            }
            if (this.right != null) {
                obj.put("right", this.right);
            }
            if (this.bottom != null) {
                obj.put("bottom", this.bottom);
            }
            if (this.left != null) {
                obj.put("left", this.left);
            }
            return obj;
        }
    }

    public static class MentionFeed {
        private final String marker;
        private final String[] feed;
        private final int minimumCharacters;

        public MentionFeed(String marker, String[] feed, int minimumCharacters) {
            this.marker = marker;
            this.feed = Objects.requireNonNull(feed, "Mention feed items must not be null");
            this.minimumCharacters = minimumCharacters;
        }

        public static MentionFeed users(String ... users) {
            return new MentionFeed("@", users, 0);
        }

        public static MentionFeed tags(String ... tags) {
            return new MentionFeed("#", tags, 0);
        }

        public ObjectNode toJson() {
            ObjectNode obj = JsonUtil.createObjectNode();
            obj.put("marker", this.marker != null ? this.marker : "@");
            obj.put("minimumCharacters", this.minimumCharacters);
            obj.set("feed", (JsonNode)JsonUtil.toArrayNode(this.feed));
            return obj;
        }
    }

    public static class StyleDefinition {
        private final String name;
        private final String element;
        private final String[] classes;

        public StyleDefinition(String name, String element, String ... classes) {
            this.name = name;
            this.element = element;
            this.classes = classes;
        }

        public static StyleDefinition block(String name, String element, String ... classes) {
            return new StyleDefinition(name, element, classes);
        }

        public static StyleDefinition inline(String name, String ... classes) {
            return new StyleDefinition(name, "span", classes);
        }

        public static StyleDefinition codeBlock(String name, String ... classes) {
            return new StyleDefinition(name, "pre", classes);
        }

        public String getName() {
            return this.name;
        }

        public String getElement() {
            return this.element;
        }

        public String[] getClasses() {
            return this.classes != null ? (String[])this.classes.clone() : null;
        }

        public ObjectNode toJson() {
            ObjectNode obj = JsonUtil.createObjectNode();
            obj.put("name", this.name);
            obj.put("element", this.element);
            obj.set("classes", (JsonNode)JsonUtil.toArrayNode(this.classes));
            return obj;
        }
    }

    public static class ToolbarStyle {
        private final String background;
        private final String borderColor;
        private final String borderRadius;
        private final String buttonBackground;
        private final String buttonHoverBackground;
        private final String buttonActiveBackground;
        private final String buttonOnBackground;
        private final String buttonOnColor;
        private final String iconColor;
        private final Map<String, ButtonStyle> buttonStyles;

        private ToolbarStyle(Builder builder) {
            this.background = builder.background;
            this.borderColor = builder.borderColor;
            this.borderRadius = builder.borderRadius;
            this.buttonBackground = builder.buttonBackground;
            this.buttonHoverBackground = builder.buttonHoverBackground;
            this.buttonActiveBackground = builder.buttonActiveBackground;
            this.buttonOnBackground = builder.buttonOnBackground;
            this.buttonOnColor = builder.buttonOnColor;
            this.iconColor = builder.iconColor;
            this.buttonStyles = builder.buttonStyles != null ? Collections.unmodifiableMap(new LinkedHashMap<String, ButtonStyle>(builder.buttonStyles)) : null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public String getBackground() {
            return this.background;
        }

        public String getBorderColor() {
            return this.borderColor;
        }

        public String getBorderRadius() {
            return this.borderRadius;
        }

        public String getButtonBackground() {
            return this.buttonBackground;
        }

        public String getButtonHoverBackground() {
            return this.buttonHoverBackground;
        }

        public String getButtonActiveBackground() {
            return this.buttonActiveBackground;
        }

        public String getButtonOnBackground() {
            return this.buttonOnBackground;
        }

        public String getButtonOnColor() {
            return this.buttonOnColor;
        }

        public String getIconColor() {
            return this.iconColor;
        }

        public Map<String, ButtonStyle> getButtonStyles() {
            return this.buttonStyles != null ? this.buttonStyles : Collections.emptyMap();
        }

        public ObjectNode toJson() {
            ObjectNode obj = JsonUtil.createObjectNode();
            if (this.background != null) {
                obj.put("background", this.background);
            }
            if (this.borderColor != null) {
                obj.put("borderColor", this.borderColor);
            }
            if (this.borderRadius != null) {
                obj.put("borderRadius", this.borderRadius);
            }
            if (this.buttonBackground != null) {
                obj.put("buttonBackground", this.buttonBackground);
            }
            if (this.buttonHoverBackground != null) {
                obj.put("buttonHoverBackground", this.buttonHoverBackground);
            }
            if (this.buttonActiveBackground != null) {
                obj.put("buttonActiveBackground", this.buttonActiveBackground);
            }
            if (this.buttonOnBackground != null) {
                obj.put("buttonOnBackground", this.buttonOnBackground);
            }
            if (this.buttonOnColor != null) {
                obj.put("buttonOnColor", this.buttonOnColor);
            }
            if (this.iconColor != null) {
                obj.put("iconColor", this.iconColor);
            }
            if (this.buttonStyles != null && !this.buttonStyles.isEmpty()) {
                ObjectNode stylesObj = JsonUtil.createObjectNode();
                this.buttonStyles.forEach((key, style) -> stylesObj.set(key, (JsonNode)style.toJson()));
                obj.set("buttonStyles", (JsonNode)stylesObj);
            }
            return obj;
        }

        public static class Builder {
            private String background;
            private String borderColor;
            private String borderRadius;
            private String buttonBackground;
            private String buttonHoverBackground;
            private String buttonActiveBackground;
            private String buttonOnBackground;
            private String buttonOnColor;
            private String iconColor;
            private Map<String, ButtonStyle> buttonStyles;

            private Builder() {
            }

            public Builder background(String background) {
                this.background = background;
                return this;
            }

            public Builder borderColor(String borderColor) {
                this.borderColor = borderColor;
                return this;
            }

            public Builder borderRadius(String borderRadius) {
                this.borderRadius = borderRadius;
                return this;
            }

            public Builder buttonBackground(String buttonBackground) {
                this.buttonBackground = buttonBackground;
                return this;
            }

            public Builder buttonHoverBackground(String buttonHoverBackground) {
                this.buttonHoverBackground = buttonHoverBackground;
                return this;
            }

            public Builder buttonActiveBackground(String buttonActiveBackground) {
                this.buttonActiveBackground = buttonActiveBackground;
                return this;
            }

            public Builder buttonOnBackground(String buttonOnBackground) {
                this.buttonOnBackground = buttonOnBackground;
                return this;
            }

            public Builder buttonOnColor(String buttonOnColor) {
                this.buttonOnColor = buttonOnColor;
                return this;
            }

            public Builder iconColor(String iconColor) {
                this.iconColor = iconColor;
                return this;
            }

            public Builder buttonStyle(String buttonName, ButtonStyle style) {
                if (this.buttonStyles == null) {
                    this.buttonStyles = new LinkedHashMap<String, ButtonStyle>();
                }
                this.buttonStyles.put(buttonName, style);
                return this;
            }

            public Builder buttonStyles(Map<String, ButtonStyle> buttonStyles) {
                this.buttonStyles = buttonStyles;
                return this;
            }

            public ToolbarStyle build() {
                CKEditorConfig.validateCssValue(this.background, "background");
                CKEditorConfig.validateCssValue(this.borderColor, "borderColor");
                CKEditorConfig.validateCssValue(this.borderRadius, "borderRadius");
                CKEditorConfig.validateCssValue(this.buttonBackground, "buttonBackground");
                CKEditorConfig.validateCssValue(this.buttonHoverBackground, "buttonHoverBackground");
                CKEditorConfig.validateCssValue(this.buttonActiveBackground, "buttonActiveBackground");
                CKEditorConfig.validateCssValue(this.buttonOnBackground, "buttonOnBackground");
                CKEditorConfig.validateCssValue(this.buttonOnColor, "buttonOnColor");
                CKEditorConfig.validateCssValue(this.iconColor, "iconColor");
                return new ToolbarStyle(this);
            }
        }
    }

    public static class ButtonStyle {
        private final String background;
        private final String hoverBackground;
        private final String activeBackground;
        private final String iconColor;

        private ButtonStyle(String background, String hoverBackground, String activeBackground, String iconColor) {
            this.background = background;
            this.hoverBackground = hoverBackground;
            this.activeBackground = activeBackground;
            this.iconColor = iconColor;
        }

        public static Builder builder() {
            return new Builder();
        }

        public String getBackground() {
            return this.background;
        }

        public String getHoverBackground() {
            return this.hoverBackground;
        }

        public String getActiveBackground() {
            return this.activeBackground;
        }

        public String getIconColor() {
            return this.iconColor;
        }

        public ObjectNode toJson() {
            ObjectNode obj = JsonUtil.createObjectNode();
            if (this.background != null) {
                obj.put("background", this.background);
            }
            if (this.hoverBackground != null) {
                obj.put("hoverBackground", this.hoverBackground);
            }
            if (this.activeBackground != null) {
                obj.put("activeBackground", this.activeBackground);
            }
            if (this.iconColor != null) {
                obj.put("iconColor", this.iconColor);
            }
            return obj;
        }

        public static class Builder {
            private String background;
            private String hoverBackground;
            private String activeBackground;
            private String iconColor;

            private Builder() {
            }

            public Builder background(String background) {
                this.background = background;
                return this;
            }

            public Builder hoverBackground(String hoverBackground) {
                this.hoverBackground = hoverBackground;
                return this;
            }

            public Builder activeBackground(String activeBackground) {
                this.activeBackground = activeBackground;
                return this;
            }

            public Builder iconColor(String iconColor) {
                this.iconColor = iconColor;
                return this;
            }

            public ButtonStyle build() {
                CKEditorConfig.validateCssValue(this.background, "background");
                CKEditorConfig.validateCssValue(this.hoverBackground, "hoverBackground");
                CKEditorConfig.validateCssValue(this.activeBackground, "activeBackground");
                CKEditorConfig.validateCssValue(this.iconColor, "iconColor");
                return new ButtonStyle(this.background, this.hoverBackground, this.activeBackground, this.iconColor);
            }
        }
    }
}

