/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor.internal;

import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.shared.Registration;
import com.wontlost.ckeditor.VaadinCKEditor;
import com.wontlost.ckeditor.event.AutosaveEvent;
import com.wontlost.ckeditor.event.ContentChangeEvent;
import com.wontlost.ckeditor.event.EditorErrorEvent;
import com.wontlost.ckeditor.event.EditorReadyEvent;
import com.wontlost.ckeditor.event.FallbackEvent;
import com.wontlost.ckeditor.handler.ErrorHandler;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventDispatcher {
    private static final Logger logger = Logger.getLogger(EventDispatcher.class.getName());
    private final VaadinCKEditor source;
    private ErrorHandler errorHandler;
    private final List<ComponentEventListener<EditorReadyEvent>> readyListeners = new CopyOnWriteArrayList<ComponentEventListener<EditorReadyEvent>>();
    private final List<ComponentEventListener<EditorErrorEvent>> errorListeners = new CopyOnWriteArrayList<ComponentEventListener<EditorErrorEvent>>();
    private final List<ComponentEventListener<AutosaveEvent>> autosaveListeners = new CopyOnWriteArrayList<ComponentEventListener<AutosaveEvent>>();
    private final List<ComponentEventListener<ContentChangeEvent>> contentChangeListeners = new CopyOnWriteArrayList<ComponentEventListener<ContentChangeEvent>>();
    private final List<ComponentEventListener<FallbackEvent>> fallbackListeners = new CopyOnWriteArrayList<ComponentEventListener<FallbackEvent>>();

    public EventDispatcher(VaadinCKEditor source) {
        this.source = source;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public Registration addEditorReadyListener(ComponentEventListener<EditorReadyEvent> listener) {
        this.readyListeners.add(listener);
        return (Registration & Serializable)() -> this.readyListeners.remove(listener);
    }

    public Registration addEditorErrorListener(ComponentEventListener<EditorErrorEvent> listener) {
        this.errorListeners.add(listener);
        return (Registration & Serializable)() -> this.errorListeners.remove(listener);
    }

    public Registration addAutosaveListener(ComponentEventListener<AutosaveEvent> listener) {
        this.autosaveListeners.add(listener);
        return (Registration & Serializable)() -> this.autosaveListeners.remove(listener);
    }

    public Registration addContentChangeListener(ComponentEventListener<ContentChangeEvent> listener) {
        this.contentChangeListeners.add(listener);
        return (Registration & Serializable)() -> this.contentChangeListeners.remove(listener);
    }

    public Registration addFallbackListener(ComponentEventListener<FallbackEvent> listener) {
        this.fallbackListeners.add(listener);
        return (Registration & Serializable)() -> this.fallbackListeners.remove(listener);
    }

    public void fireEditorReady(long initTimeMs) {
        EditorReadyEvent event = new EditorReadyEvent(this.source, true, initTimeMs);
        this.dispatchEvent(this.readyListeners, event, "EditorReady");
    }

    public boolean fireEditorError(EditorErrorEvent.EditorError error) {
        if (this.errorHandler != null) {
            try {
                if (this.errorHandler.handleError(error)) {
                    return true;
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error in error handler", e);
            }
        }
        EditorErrorEvent event = new EditorErrorEvent(this.source, true, error);
        this.dispatchEvent(this.errorListeners, event, "EditorError");
        return false;
    }

    public void fireAutosave(String content, boolean success, String errorMessage) {
        AutosaveEvent event = new AutosaveEvent(this.source, true, content, success, errorMessage);
        this.dispatchEvent(this.autosaveListeners, event, "Autosave");
    }

    public void fireContentChange(String oldContent, String newContent, ContentChangeEvent.ChangeSource changeSource) {
        ContentChangeEvent event = new ContentChangeEvent(this.source, true, oldContent, newContent, changeSource);
        this.dispatchEvent(this.contentChangeListeners, event, "ContentChange");
    }

    public void fireFallback(FallbackEvent.FallbackMode mode, String reason, String originalError) {
        FallbackEvent event = new FallbackEvent(this.source, true, mode, reason, originalError);
        this.dispatchEvent(this.fallbackListeners, event, "Fallback");
    }

    private <E extends ComponentEvent<?>> void dispatchEvent(List<ComponentEventListener<E>> listeners, E event, String eventName) {
        for (ComponentEventListener<E> listener : listeners) {
            try {
                listener.onComponentEvent(event);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error in " + eventName + " listener", e);
            }
        }
    }

    public void cleanup() {
        this.readyListeners.clear();
        this.errorListeners.clear();
        this.autosaveListeners.clear();
        this.contentChangeListeners.clear();
        this.fallbackListeners.clear();
    }

    public ListenerStats getListenerStats() {
        return new ListenerStats(this.readyListeners.size(), this.errorListeners.size(), this.autosaveListeners.size(), this.contentChangeListeners.size(), this.fallbackListeners.size());
    }

    public static class ListenerStats {
        public final int ready;
        public final int error;
        public final int autosave;
        public final int contentChange;
        public final int fallback;

        ListenerStats(int ready, int error, int autosave, int contentChange, int fallback) {
            this.ready = ready;
            this.error = error;
            this.autosave = autosave;
            this.contentChange = contentChange;
            this.fallback = fallback;
        }

        public int total() {
            return this.ready + this.error + this.autosave + this.contentChange + this.fallback;
        }
    }
}

