/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor.internal;

import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class EnumParser {
    private static final Logger logger = Logger.getLogger(EnumParser.class.getName());

    private EnumParser() {
    }

    public static <T extends Enum<T>> T parse(String value, Class<T> enumType, T defaultValue) {
        if (value == null || value.isEmpty()) {
            logger.log(Level.FINE, () -> String.format("Null or empty value for %s, using default: %s", enumType.getSimpleName(), defaultValue));
            return defaultValue;
        }
        try {
            return Enum.valueOf(enumType, value.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.WARNING, () -> String.format("Invalid %s value: '%s', using default: %s", enumType.getSimpleName(), value, defaultValue));
            return defaultValue;
        }
    }

    public static <T extends Enum<T>> T parse(String value, Class<T> enumType, T defaultValue, String context) {
        if (value == null || value.isEmpty()) {
            logger.log(Level.FINE, () -> String.format("[%s] Null or empty value for %s, using default: %s", context, enumType.getSimpleName(), defaultValue));
            return defaultValue;
        }
        try {
            return Enum.valueOf(enumType, value.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.WARNING, () -> String.format("[%s] Invalid %s value: '%s', using default: %s", context, enumType.getSimpleName(), value, defaultValue));
            return defaultValue;
        }
    }

    public static <T extends Enum<T>> T parseStrict(String value, Class<T> enumType) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s value must not be null or empty", enumType.getSimpleName()));
        }
        try {
            return Enum.valueOf(enumType, value.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid %s value: '%s'. Valid values: %s", enumType.getSimpleName(), value, Arrays.toString(enumType.getEnumConstants())), e);
        }
    }
}

