/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor.handler;

import com.wontlost.ckeditor.event.EditorErrorEvent;
import java.util.logging.Logger;

@FunctionalInterface
public interface ErrorHandler {
    public boolean handleError(EditorErrorEvent.EditorError var1);

    public static ErrorHandler logging(Logger logger) {
        return error -> {
            switch (error.getSeverity()) {
                case WARNING: {
                    logger.warning(() -> String.format("[%s] %s", error.getCode(), error.getMessage()));
                    break;
                }
                case ERROR: {
                    logger.severe(() -> String.format("[%s] %s", error.getCode(), error.getMessage()));
                    break;
                }
                case FATAL: {
                    logger.severe(() -> String.format("FATAL [%s] %s\n%s", error.getCode(), error.getMessage(), error.getStackTrace()));
                }
            }
            return false;
        };
    }

    public static ErrorHandler compose(ErrorHandler ... handlers) {
        return error -> {
            for (ErrorHandler handler : handlers) {
                if (!handler.handleError(error)) continue;
                return true;
            }
            return false;
        };
    }
}

