/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import com.wontlost.ckeditor.CKEditorConfig;
import com.wontlost.ckeditor.CKEditorPlugin;
import com.wontlost.ckeditor.CKEditorPreset;
import com.wontlost.ckeditor.CKEditorTheme;
import com.wontlost.ckeditor.CKEditorType;
import com.wontlost.ckeditor.CustomPlugin;
import com.wontlost.ckeditor.JsonUtil;
import com.wontlost.ckeditor.VaadinCKEditorBuilder;
import com.wontlost.ckeditor.event.AutosaveEvent;
import com.wontlost.ckeditor.event.ContentChangeEvent;
import com.wontlost.ckeditor.event.EditorErrorEvent;
import com.wontlost.ckeditor.event.EditorReadyEvent;
import com.wontlost.ckeditor.event.FallbackEvent;
import com.wontlost.ckeditor.handler.ErrorHandler;
import com.wontlost.ckeditor.handler.HtmlSanitizer;
import com.wontlost.ckeditor.handler.UploadHandler;
import com.wontlost.ckeditor.internal.ContentManager;
import com.wontlost.ckeditor.internal.EnumParser;
import com.wontlost.ckeditor.internal.EventDispatcher;
import com.wontlost.ckeditor.internal.UploadManager;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsoup.safety.Safelist;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.ObjectNode;

@Tag(value="vaadin-ckeditor")
@JsModule(value="./vaadin-ckeditor/vaadin-ckeditor.ts")
@NpmPackage.Container(value={@NpmPackage(value="ckeditor5", version="47.4.0"), @NpmPackage(value="lit", version="^3.3.2")})
public class VaadinCKEditor
extends CustomField<String>
implements HasAriaLabel {
    private static final Logger logger = Logger.getLogger(VaadinCKEditor.class.getName());
    private static final String VERSION = "5.0.3";
    private static final int DEFAULT_AUTOSAVE_WAITING_TIME = 2000;
    private static final String DEFAULT_LANGUAGE = "en";
    private static final String DEFAULT_LICENSE_KEY = "GPL";
    private String editorData = "";
    private final Set<CKEditorPlugin> plugins = new LinkedHashSet<CKEditorPlugin>();
    private final Set<CustomPlugin> customPlugins = new LinkedHashSet<CustomPlugin>();
    private CKEditorConfig config;
    private CKEditorType editorType = CKEditorType.CLASSIC;
    private CKEditorTheme theme = CKEditorTheme.AUTO;
    private String language = "en";
    private String[] toolbar;
    private boolean readOnly = false;
    private boolean autosave = false;
    private int autosaveWaitingTime = 2000;
    private Consumer<String> autosaveCallback;
    private String licenseKey = "GPL";
    private ErrorHandler errorHandler;
    private HtmlSanitizer htmlSanitizer;
    private UploadHandler uploadHandler;
    private UploadHandler.UploadConfig uploadConfig;
    private FallbackEvent.FallbackMode fallbackMode = FallbackEvent.FallbackMode.TEXTAREA;
    private UploadManager uploadManager;
    private ContentManager contentManager;
    private EventDispatcher eventDispatcher;

    VaadinCKEditor() {
        this.config = new CKEditorConfig();
        this.eventDispatcher = new EventDispatcher(this);
        this.contentManager = new ContentManager(null);
    }

    public static VaadinCKEditorBuilder create() {
        return VaadinCKEditorBuilder.create();
    }

    public static VaadinCKEditor withPreset(CKEditorPreset preset) {
        return VaadinCKEditor.create().withPreset(preset).build();
    }

    void initialize() {
        this.initializeManagers();
        String editorId = "editor_" + UUID.randomUUID().toString().substring(0, 8);
        this.getElement().setProperty("editorId", editorId);
        this.getElement().setProperty("editorType", this.editorType.getJsName());
        this.getElement().setProperty("themeType", this.theme.getJsName());
        this.getElement().setProperty("editorData", this.editorData);
        this.getElement().setProperty("isReadOnly", this.readOnly);
        this.getElement().setProperty("language", this.language);
        this.getElement().setProperty("autosave", this.autosave);
        this.getElement().setProperty("autosaveWaitingTime", (double)this.autosaveWaitingTime);
        this.getElement().setProperty("licenseKey", this.licenseKey);
        this.getElement().setProperty("fallbackMode", this.fallbackMode.getJsName());
        this.getElement().setPropertyJson("plugins", (BaseJsonNode)this.buildPluginsJson());
        if (this.toolbar != null && this.toolbar.length > 0) {
            this.getElement().setPropertyJson("toolbar", (BaseJsonNode)this.buildToolbarJson());
        }
        if (this.config != null) {
            this.getElement().setPropertyJson("config", (BaseJsonNode)this.config.toJson());
        }
    }

    private void initializeManagers() {
        if (this.htmlSanitizer != null) {
            this.contentManager = new ContentManager(this.htmlSanitizer);
        }
        if (this.uploadHandler != null) {
            WeakReference<VaadinCKEditor> editorRef = new WeakReference<VaadinCKEditor>(this);
            this.uploadManager = new UploadManager(this.uploadHandler, this.uploadConfig, (uploadId, url, error) -> {
                VaadinCKEditor editor = (VaadinCKEditor)((Object)((Object)editorRef.get()));
                if (editor == null) {
                    logger.fine("Upload callback ignored: editor has been garbage collected");
                    return;
                }
                editor.getUI().ifPresent(ui -> ui.access((Command & Serializable)() -> {
                    if (url != null) {
                        editor.getElement().executeJs("this._resolveUpload($0, $1, null)", new Object[]{uploadId, url});
                    } else {
                        editor.getElement().executeJs("this._resolveUpload($0, null, $1)", new Object[]{uploadId, error});
                    }
                }));
            });
        }
    }

    private ArrayNode buildPluginsJson() {
        ObjectNode pluginObj;
        ArrayNode arr = JsonUtil.createArrayNode();
        for (CKEditorPlugin cKEditorPlugin : this.plugins) {
            pluginObj = JsonUtil.createObjectNode();
            pluginObj.put("name", cKEditorPlugin.getJsName());
            pluginObj.put("premium", cKEditorPlugin.isPremium());
            arr.add((JsonNode)pluginObj);
        }
        for (CustomPlugin customPlugin : this.customPlugins) {
            pluginObj = JsonUtil.createObjectNode();
            pluginObj.put("name", customPlugin.getJsName());
            pluginObj.put("premium", customPlugin.isPremium());
            if (customPlugin.getImportPath() != null) {
                pluginObj.put("importPath", customPlugin.getImportPath());
            }
            arr.add((JsonNode)pluginObj);
        }
        return arr;
    }

    private ArrayNode buildToolbarJson() {
        return JsonUtil.toArrayNode(this.toolbar);
    }

    protected String generateModelValue() {
        return this.editorData;
    }

    protected void setPresentationValue(String value) {
        this.editorData = value;
    }

    public String getValue() {
        return this.editorData;
    }

    public String getSanitizedValue() {
        return this.contentManager.getSanitizedValue(this.editorData);
    }

    public void setValue(String value) {
        super.setValue((Object)value);
        this.editorData = value != null ? value : "";
        this.getElement().setProperty("editorData", this.editorData);
        this.updateEditorData(this.editorData);
    }

    protected void setModelValue(String value, boolean fromClient) {
        String newValue;
        String oldValue = this.editorData;
        String string = newValue = value != null ? value : "";
        if (Objects.equals(oldValue, newValue)) {
            return;
        }
        super.setModelValue((Object)newValue, fromClient);
        this.editorData = newValue;
        this.fireEvent((ComponentEvent)new AbstractField.ComponentValueChangeEvent((Component)this, (HasValue)this, (Object)oldValue, fromClient));
    }

    @ClientCallable
    private void setEditorData(String data) {
        this.setModelValue(data, true);
    }

    @ClientCallable
    private void saveEditorData(String data) {
        boolean success = true;
        Object errorMessage = null;
        if (this.autosaveCallback != null) {
            try {
                this.autosaveCallback.accept(data);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in autosave callback", e);
                success = false;
                errorMessage = e.getMessage();
                if (errorMessage == null || ((String)errorMessage).isEmpty()) {
                    errorMessage = e.getClass().getSimpleName() + " occurred during autosave";
                }
            }
        } else {
            logger.log(Level.WARNING, "Autosave triggered but no callback registered");
        }
        this.eventDispatcher.fireAutosave(data, success, (String)errorMessage);
    }

    private void updateEditorData(String content) {
        this.getElement().executeJs("this.updateData($0)", new Object[]{content});
    }

    public void setId(String id) {
        String editorId = id != null ? id : "editor_" + UUID.randomUUID().toString().substring(0, 8);
        super.setId(editorId);
        this.getElement().setProperty("editorId", editorId);
    }

    public Optional<String> getId() {
        return Optional.ofNullable(this.getElement().getProperty("editorId"));
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.getElement().setProperty("isReadOnly", readOnly);
        this.getId().ifPresent(id -> this.getElement().executeJs("this.setReadOnly($0)", new Object[]{readOnly}));
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setWidth(String width) {
        super.setWidth(width);
        this.getElement().setProperty("editorWidth", width != null ? width : "auto");
    }

    public void setHeight(String height) {
        super.setHeight(height);
        this.getElement().setProperty("editorHeight", height != null ? height : "auto");
    }

    public void setHideToolbar(boolean hide) {
        this.getElement().setProperty("hideToolbar", hide);
    }

    public void setReadOnlyWithToolbarAction(boolean readOnly) {
        this.setReadOnly(readOnly);
        this.setHideToolbar(readOnly);
    }

    public void setMinimapEnabled(boolean enabled) {
        this.getElement().setProperty("minimapEnabled", enabled);
    }

    public void setMinimapSimplePreview(boolean enabled) {
        this.getElement().setProperty("minimapSimplePreview", enabled);
    }

    public void setDocumentOutlineEnabled(boolean enabled) {
        this.getElement().setProperty("documentOutlineEnabled", enabled);
    }

    public void setGeneralHtmlSupportEnabled(boolean enabled) {
        this.getElement().setProperty("ghsEnabled", enabled);
    }

    public void setAllowConfigRequiredPlugins(boolean allow) {
        this.getElement().setProperty("allowConfigRequiredPlugins", allow);
    }

    public void setSynchronized(boolean sync) {
        this.getElement().setProperty("sync", sync);
    }

    public void setOverrideCssUrl(String url) {
        if (url != null) {
            this.getElement().setProperty("overrideCssUrl", url);
        }
    }

    public void setAutosaveCallback(Consumer<String> callback) {
        this.autosaveCallback = callback;
    }

    public void clear() {
        this.setValue("");
    }

    public void insertText(String text) {
        this.getId().ifPresent(id -> this.getElement().executeJs("this.insertText($0)", new Object[]{text}));
    }

    public String getPlainText() {
        return this.contentManager.getPlainText(this.editorData);
    }

    public String getSanitizedHtml() {
        return this.contentManager.getSanitizedHtml(this.editorData);
    }

    public String sanitizeHtml(String html, Safelist safelist) {
        return this.contentManager.sanitizeHtml(html, safelist);
    }

    public int getCharacterCount() {
        return this.contentManager.getCharacterCount(this.editorData);
    }

    public int getWordCount() {
        return this.contentManager.getWordCount(this.editorData);
    }

    public boolean isContentEmpty() {
        return this.contentManager.isContentEmpty(this.editorData);
    }

    public static String getVersion() {
        return VERSION;
    }

    public Registration addEditorReadyListener(ComponentEventListener<EditorReadyEvent> listener) {
        return this.eventDispatcher.addEditorReadyListener(listener);
    }

    public Registration addEditorErrorListener(ComponentEventListener<EditorErrorEvent> listener) {
        return this.eventDispatcher.addEditorErrorListener(listener);
    }

    public Registration addAutosaveListener(ComponentEventListener<AutosaveEvent> listener) {
        return this.eventDispatcher.addAutosaveListener(listener);
    }

    public Registration addContentChangeListener(ComponentEventListener<ContentChangeEvent> listener) {
        return this.eventDispatcher.addContentChangeListener(listener);
    }

    public Registration addFallbackListener(ComponentEventListener<FallbackEvent> listener) {
        return this.eventDispatcher.addFallbackListener(listener);
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
        this.eventDispatcher.setErrorHandler(handler);
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setHtmlSanitizer(HtmlSanitizer sanitizer) {
        this.htmlSanitizer = sanitizer;
    }

    public HtmlSanitizer getHtmlSanitizer() {
        return this.htmlSanitizer;
    }

    public void setUploadHandler(UploadHandler handler) {
        this.uploadHandler = handler;
    }

    public UploadHandler getUploadHandler() {
        return this.uploadHandler;
    }

    public void setFallbackMode(FallbackEvent.FallbackMode mode) {
        this.fallbackMode = mode;
        this.getElement().setProperty("fallbackMode", mode.getJsName());
    }

    public FallbackEvent.FallbackMode getFallbackMode() {
        return this.fallbackMode;
    }

    public EventDispatcher.ListenerStats getListenerStats() {
        return this.eventDispatcher.getListenerStats();
    }

    public void cleanupListeners() {
        this.eventDispatcher.cleanup();
        if (this.uploadManager != null) {
            this.uploadManager.cleanup();
        }
    }

    @ClientCallable
    private void fireEditorReady(double initTimeMs) {
        this.eventDispatcher.fireEditorReady((long)initTimeMs);
    }

    @ClientCallable
    private void fireEditorError(String code, String message, String severity, boolean recoverable, String stackTrace) {
        EditorErrorEvent.ErrorSeverity errorSeverity = EnumParser.parse(severity, EditorErrorEvent.ErrorSeverity.class, EditorErrorEvent.ErrorSeverity.ERROR, "fireEditorError");
        EditorErrorEvent.EditorError error = new EditorErrorEvent.EditorError(code, message, errorSeverity, recoverable, stackTrace);
        this.eventDispatcher.fireEditorError(error);
    }

    @ClientCallable
    private void fireContentChange(String oldContent, String newContent, String source) {
        ContentChangeEvent.ChangeSource changeSource = EnumParser.parse(source, ContentChangeEvent.ChangeSource.class, ContentChangeEvent.ChangeSource.UNKNOWN, "fireContentChange");
        this.eventDispatcher.fireContentChange(oldContent, newContent, changeSource);
    }

    @ClientCallable
    private void fireFallback(String mode, String reason, String originalError) {
        FallbackEvent.FallbackMode fallbackModeValue = FallbackEvent.FallbackMode.fromJsName(mode);
        this.eventDispatcher.fireFallback(fallbackModeValue, reason, originalError);
    }

    @ClientCallable
    private void handleFileUpload(String uploadId, String fileName, String mimeType, String base64Data) {
        if (this.uploadManager == null) {
            this.getElement().executeJs("this._resolveUpload($0, null, $1)", new Object[]{uploadId, "No upload handler configured"});
            return;
        }
        this.uploadManager.handleUpload(uploadId, fileName, mimeType, base64Data);
    }

    public boolean hasActiveUploads() {
        return this.uploadManager != null && this.uploadManager.hasActiveUploads();
    }

    public int getActiveUploadCount() {
        return this.uploadManager != null ? this.uploadManager.getActiveUploadCount() : 0;
    }

    public boolean cancelUpload(String uploadId) {
        return this.uploadManager != null && this.uploadManager.cancelUpload(uploadId);
    }

    @ClientCallable
    private void cancelUploadFromClient(String uploadId) {
        this.cancelUpload(uploadId);
    }

    void clearPlugins() {
        this.plugins.clear();
    }

    void addPluginsInternal(Collection<CKEditorPlugin> p) {
        this.plugins.addAll(p);
    }

    void addCustomPluginsInternal(Collection<CustomPlugin> p) {
        this.customPlugins.addAll(p);
    }

    boolean hasPlugins() {
        return !this.plugins.isEmpty();
    }

    Set<CKEditorPlugin> getPluginsInternal() {
        return new LinkedHashSet<CKEditorPlugin>(this.plugins);
    }

    void setEditorTypeInternal(CKEditorType type) {
        this.editorType = type;
    }

    void setThemeInternal(CKEditorTheme theme) {
        this.theme = theme;
    }

    void setLanguageInternal(String language) {
        this.language = language;
    }

    String getLanguageInternal() {
        return this.language;
    }

    void setFallbackModeInternal(FallbackEvent.FallbackMode mode) {
        this.fallbackMode = mode;
    }

    void setErrorHandlerInternal(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    void setHtmlSanitizerInternal(HtmlSanitizer sanitizer) {
        this.htmlSanitizer = sanitizer;
    }

    void setUploadHandlerInternal(UploadHandler handler) {
        this.uploadHandler = handler;
    }

    void setUploadConfigInternal(UploadHandler.UploadConfig config) {
        this.uploadConfig = config;
    }

    void setEditorDataInternal(String data) {
        this.editorData = data != null ? data : "";
    }

    void setReadOnlyInternal(boolean readOnly) {
        this.readOnly = readOnly;
    }

    void setLicenseKeyInternal(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    void setToolbarInternal(String[] toolbar) {
        this.toolbar = toolbar;
    }

    void setConfigInternal(CKEditorConfig config) {
        this.config = config;
    }

    CKEditorConfig getConfigInternal() {
        return this.config;
    }

    void setAutosaveInternal(boolean enabled, int waitingTime, Consumer<String> callback) {
        this.autosave = enabled;
        this.autosaveWaitingTime = waitingTime;
        this.autosaveCallback = callback;
    }
}

