/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor;

import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public final class JsonUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private JsonUtil() {
    }

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    public static ObjectNode createObjectNode() {
        return MAPPER.createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return MAPPER.createArrayNode();
    }

    public static <T> JsonNode valueToTree(T value) {
        return MAPPER.valueToTree(value);
    }

    public static ArrayNode toArrayNode(String[] items) {
        ArrayNode arr = MAPPER.createArrayNode();
        if (items != null) {
            for (String item : items) {
                if (item == null) continue;
                arr.add(item);
            }
        }
        return arr;
    }

    public static ArrayNode toArrayNodeOrNull(String[] items) {
        if (items == null || items.length == 0) {
            return null;
        }
        return JsonUtil.toArrayNode(items);
    }

    public static boolean hasElements(Object[] items) {
        return items != null && items.length > 0;
    }
}

