/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class CustomPlugin {
    private static final Pattern VALID_IMPORT_PATH = Pattern.compile("^(?:@[a-z0-9][a-z0-9._-]*/[a-z0-9][a-z0-9._/-]*|[a-z0-9][a-z0-9._/-]*|(?:\\.{1,2}/){1,2}(?:[a-zA-Z0-9_.-]+/)*[a-zA-Z0-9_.-]+)$", 2);
    private final String jsName;
    private final String importPath;
    private final Set<String> toolbarItems;
    private final Set<String> dependencies;
    private final boolean isPremium;

    private CustomPlugin(Builder builder) {
        this.jsName = Objects.requireNonNull(builder.jsName, "Plugin name cannot be null");
        this.importPath = builder.importPath;
        this.toolbarItems = builder.toolbarItems != null ? Collections.unmodifiableSet(builder.toolbarItems) : Collections.emptySet();
        this.dependencies = builder.dependencies != null ? Collections.unmodifiableSet(builder.dependencies) : Collections.emptySet();
        this.isPremium = builder.isPremium;
    }

    public String getJsName() {
        return this.jsName;
    }

    public String getImportPath() {
        return this.importPath;
    }

    public Set<String> getToolbarItems() {
        return this.toolbarItems;
    }

    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public boolean isPremium() {
        return this.isPremium;
    }

    public static Builder builder(String jsName) {
        return new Builder(jsName);
    }

    public static CustomPlugin of(String jsName, String importPath) {
        return CustomPlugin.builder(jsName).withImportPath(importPath).build();
    }

    public static CustomPlugin fromCKEditor5(String jsName) {
        return CustomPlugin.builder(jsName).build();
    }

    public static CustomPlugin fromPremium(String jsName) {
        return CustomPlugin.builder(jsName).premium().build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomPlugin that = (CustomPlugin)o;
        return this.jsName.equals(that.jsName);
    }

    public int hashCode() {
        return Objects.hash(this.jsName);
    }

    public String toString() {
        return "CustomPlugin{jsName='" + this.jsName + "', importPath='" + this.importPath + "', isPremium=" + this.isPremium + "}";
    }

    public static class Builder {
        private final String jsName;
        private String importPath;
        private Set<String> toolbarItems;
        private Set<String> dependencies;
        private boolean isPremium = false;

        private Builder(String jsName) {
            this.jsName = jsName;
        }

        public Builder withImportPath(String importPath) {
            if (importPath != null && !importPath.isEmpty()) {
                this.validateImportPath(importPath);
            }
            this.importPath = importPath;
            return this;
        }

        private void validateImportPath(String path) {
            if (path.startsWith("/") || path.matches("^[a-zA-Z]:.*") || path.startsWith("\\\\")) {
                throw new IllegalArgumentException("Absolute paths are not allowed in importPath: " + path);
            }
            if (path.contains("://")) {
                throw new IllegalArgumentException("URLs are not allowed in importPath: " + path);
            }
            if (path.contains("../../..")) {
                throw new IllegalArgumentException("Deep path traversal (more than 2 levels up) is not allowed in importPath: " + path);
            }
            if (!VALID_IMPORT_PATH.matcher(path).matches()) {
                throw new IllegalArgumentException("Invalid importPath format. Must be a valid npm package name or relative path: " + path);
            }
        }

        public Builder withToolbarItems(String ... items) {
            this.toolbarItems = Set.of(items);
            return this;
        }

        public Builder withDependencies(String ... deps) {
            this.dependencies = Set.of(deps);
            return this;
        }

        public Builder premium() {
            this.isPremium = true;
            return this;
        }

        public CustomPlugin build() {
            return new CustomPlugin(this);
        }
    }
}

