/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor;

import com.wontlost.ckeditor.CKEditorPlugin;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public enum CKEditorPreset {
    BASIC("Basic Editor", new CKEditorPlugin[]{CKEditorPlugin.ESSENTIALS, CKEditorPlugin.PARAGRAPH, CKEditorPlugin.BOLD, CKEditorPlugin.ITALIC, CKEditorPlugin.UNDERLINE, CKEditorPlugin.LINK, CKEditorPlugin.LIST, CKEditorPlugin.BLOCK_QUOTE, CKEditorPlugin.UNDO}, new String[]{"undo", "redo", "|", "bold", "italic", "underline", "|", "link", "|", "bulletedList", "numberedList", "|", "blockQuote"}),
    STANDARD("Standard Editor", new CKEditorPlugin[]{CKEditorPlugin.ESSENTIALS, CKEditorPlugin.PARAGRAPH, CKEditorPlugin.UNDO, CKEditorPlugin.BOLD, CKEditorPlugin.ITALIC, CKEditorPlugin.UNDERLINE, CKEditorPlugin.STRIKETHROUGH, CKEditorPlugin.CODE, CKEditorPlugin.HEADING, CKEditorPlugin.ALIGNMENT, CKEditorPlugin.BLOCK_QUOTE, CKEditorPlugin.INDENT, CKEditorPlugin.INDENT_BLOCK, CKEditorPlugin.LIST, CKEditorPlugin.TODO_LIST, CKEditorPlugin.LINK, CKEditorPlugin.AUTO_LINK, CKEditorPlugin.IMAGE, CKEditorPlugin.IMAGE_TOOLBAR, CKEditorPlugin.IMAGE_CAPTION, CKEditorPlugin.IMAGE_STYLE, CKEditorPlugin.IMAGE_RESIZE, CKEditorPlugin.IMAGE_INSERT, CKEditorPlugin.IMAGE_UPLOAD, CKEditorPlugin.BASE64_UPLOAD_ADAPTER, CKEditorPlugin.TABLE, CKEditorPlugin.TABLE_TOOLBAR, CKEditorPlugin.MEDIA_EMBED, CKEditorPlugin.HORIZONTAL_LINE, CKEditorPlugin.AUTOFORMAT, CKEditorPlugin.FIND_AND_REPLACE, CKEditorPlugin.PASTE_FROM_OFFICE}, new String[]{"undo", "redo", "|", "heading", "|", "bold", "italic", "underline", "strikethrough", "code", "|", "link", "insertImage", "insertTable", "mediaEmbed", "|", "bulletedList", "numberedList", "todoList", "|", "alignment", "outdent", "indent", "|", "blockQuote", "horizontalLine", "|", "findAndReplace"}),
    FULL("Full Editor", new CKEditorPlugin[]{CKEditorPlugin.ESSENTIALS, CKEditorPlugin.PARAGRAPH, CKEditorPlugin.UNDO, CKEditorPlugin.BOLD, CKEditorPlugin.ITALIC, CKEditorPlugin.UNDERLINE, CKEditorPlugin.STRIKETHROUGH, CKEditorPlugin.CODE, CKEditorPlugin.SUPERSCRIPT, CKEditorPlugin.SUBSCRIPT, CKEditorPlugin.FONT_SIZE, CKEditorPlugin.FONT_FAMILY, CKEditorPlugin.FONT_COLOR, CKEditorPlugin.FONT_BACKGROUND_COLOR, CKEditorPlugin.HEADING, CKEditorPlugin.ALIGNMENT, CKEditorPlugin.BLOCK_QUOTE, CKEditorPlugin.INDENT, CKEditorPlugin.INDENT_BLOCK, CKEditorPlugin.LIST, CKEditorPlugin.TODO_LIST, CKEditorPlugin.LINK, CKEditorPlugin.AUTO_LINK, CKEditorPlugin.IMAGE, CKEditorPlugin.IMAGE_TOOLBAR, CKEditorPlugin.IMAGE_CAPTION, CKEditorPlugin.IMAGE_STYLE, CKEditorPlugin.IMAGE_INSERT, CKEditorPlugin.IMAGE_UPLOAD, CKEditorPlugin.BASE64_UPLOAD_ADAPTER, CKEditorPlugin.TABLE, CKEditorPlugin.TABLE_TOOLBAR, CKEditorPlugin.MEDIA_EMBED, CKEditorPlugin.CODE_BLOCK, CKEditorPlugin.HORIZONTAL_LINE, CKEditorPlugin.AUTOFORMAT, CKEditorPlugin.FIND_AND_REPLACE, CKEditorPlugin.REMOVE_FORMAT, CKEditorPlugin.HIGHLIGHT, CKEditorPlugin.PASTE_FROM_OFFICE}, new String[]{"undo", "redo", "|", "heading", "|", "fontFamily", "fontSize", "fontColor", "fontBackgroundColor", "|", "bold", "italic", "underline", "strikethrough", "code", "subscript", "superscript", "|", "removeFormat", "|", "link", "insertImage", "insertTable", "mediaEmbed", "|", "bulletedList", "numberedList", "todoList", "|", "alignment", "outdent", "indent", "|", "blockQuote", "codeBlock", "horizontalLine", "|", "highlight", "|", "findAndReplace"}),
    DOCUMENT("Document Editor", new CKEditorPlugin[]{CKEditorPlugin.ESSENTIALS, CKEditorPlugin.PARAGRAPH, CKEditorPlugin.UNDO, CKEditorPlugin.CLIPBOARD, CKEditorPlugin.SELECT_ALL, CKEditorPlugin.BOLD, CKEditorPlugin.ITALIC, CKEditorPlugin.UNDERLINE, CKEditorPlugin.STRIKETHROUGH, CKEditorPlugin.SUPERSCRIPT, CKEditorPlugin.SUBSCRIPT, CKEditorPlugin.FONT_SIZE, CKEditorPlugin.FONT_FAMILY, CKEditorPlugin.FONT_COLOR, CKEditorPlugin.FONT_BACKGROUND_COLOR, CKEditorPlugin.HEADING, CKEditorPlugin.ALIGNMENT, CKEditorPlugin.BLOCK_QUOTE, CKEditorPlugin.INDENT, CKEditorPlugin.INDENT_BLOCK, CKEditorPlugin.LIST, CKEditorPlugin.TODO_LIST, CKEditorPlugin.LINK, CKEditorPlugin.AUTO_LINK, CKEditorPlugin.IMAGE, CKEditorPlugin.IMAGE_TOOLBAR, CKEditorPlugin.IMAGE_CAPTION, CKEditorPlugin.IMAGE_STYLE, CKEditorPlugin.IMAGE_RESIZE, CKEditorPlugin.IMAGE_INSERT, CKEditorPlugin.IMAGE_UPLOAD, CKEditorPlugin.BASE64_UPLOAD_ADAPTER, CKEditorPlugin.TABLE, CKEditorPlugin.TABLE_TOOLBAR, CKEditorPlugin.TABLE_PROPERTIES, CKEditorPlugin.TABLE_CELL_PROPERTIES, CKEditorPlugin.HORIZONTAL_LINE, CKEditorPlugin.PAGE_BREAK, CKEditorPlugin.AUTOFORMAT, CKEditorPlugin.FIND_AND_REPLACE, CKEditorPlugin.REMOVE_FORMAT, CKEditorPlugin.WORD_COUNT, CKEditorPlugin.TITLE, CKEditorPlugin.PASTE_FROM_OFFICE, CKEditorPlugin.AUTOSAVE}, new String[]{"undo", "redo", "|", "heading", "|", "fontFamily", "fontSize", "|", "bold", "italic", "underline", "|", "fontColor", "fontBackgroundColor", "|", "link", "insertImage", "insertTable", "|", "bulletedList", "numberedList", "|", "alignment", "outdent", "indent", "|", "pageBreak", "|", "findAndReplace"}),
    COLLABORATIVE("Collaborative Editor", new CKEditorPlugin[]{CKEditorPlugin.ESSENTIALS, CKEditorPlugin.PARAGRAPH, CKEditorPlugin.UNDO, CKEditorPlugin.CLIPBOARD, CKEditorPlugin.SELECT_ALL, CKEditorPlugin.BOLD, CKEditorPlugin.ITALIC, CKEditorPlugin.UNDERLINE, CKEditorPlugin.STRIKETHROUGH, CKEditorPlugin.SUPERSCRIPT, CKEditorPlugin.SUBSCRIPT, CKEditorPlugin.FONT_SIZE, CKEditorPlugin.FONT_FAMILY, CKEditorPlugin.FONT_COLOR, CKEditorPlugin.FONT_BACKGROUND_COLOR, CKEditorPlugin.HEADING, CKEditorPlugin.ALIGNMENT, CKEditorPlugin.BLOCK_QUOTE, CKEditorPlugin.INDENT, CKEditorPlugin.INDENT_BLOCK, CKEditorPlugin.LIST, CKEditorPlugin.TODO_LIST, CKEditorPlugin.LINK, CKEditorPlugin.AUTO_LINK, CKEditorPlugin.IMAGE, CKEditorPlugin.IMAGE_TOOLBAR, CKEditorPlugin.IMAGE_CAPTION, CKEditorPlugin.IMAGE_STYLE, CKEditorPlugin.IMAGE_RESIZE, CKEditorPlugin.IMAGE_INSERT, CKEditorPlugin.IMAGE_UPLOAD, CKEditorPlugin.BASE64_UPLOAD_ADAPTER, CKEditorPlugin.TABLE, CKEditorPlugin.TABLE_TOOLBAR, CKEditorPlugin.TABLE_PROPERTIES, CKEditorPlugin.TABLE_CELL_PROPERTIES, CKEditorPlugin.HORIZONTAL_LINE, CKEditorPlugin.PAGE_BREAK, CKEditorPlugin.AUTOFORMAT, CKEditorPlugin.FIND_AND_REPLACE, CKEditorPlugin.REMOVE_FORMAT, CKEditorPlugin.WORD_COUNT, CKEditorPlugin.PASTE_FROM_OFFICE, CKEditorPlugin.AUTOSAVE}, new String[]{"undo", "redo", "|", "heading", "|", "fontFamily", "fontSize", "|", "bold", "italic", "underline", "|", "fontColor", "fontBackgroundColor", "|", "link", "insertImage", "insertTable", "|", "bulletedList", "numberedList", "todoList", "|", "alignment", "outdent", "indent", "|", "pageBreak", "|", "findAndReplace"}),
    EMPTY("Empty Editor", new CKEditorPlugin[]{CKEditorPlugin.ESSENTIALS, CKEditorPlugin.PARAGRAPH}, new String[0]);

    private final String displayName;
    private final Set<CKEditorPlugin> plugins;
    private final String[] defaultToolbar;

    private CKEditorPreset(String displayName, CKEditorPlugin[] plugins, String[] defaultToolbar) {
        this.displayName = displayName;
        this.plugins = Collections.unmodifiableSet(new LinkedHashSet<CKEditorPlugin>(Arrays.asList(plugins)));
        this.defaultToolbar = defaultToolbar;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Set<CKEditorPlugin> getPlugins() {
        return this.plugins;
    }

    public String[] getDefaultToolbar() {
        return (String[])this.defaultToolbar.clone();
    }

    public boolean hasPlugin(CKEditorPlugin plugin) {
        return this.plugins.contains((Object)plugin);
    }

    public int getEstimatedSize() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 300;
            case 1 -> 600;
            case 2 -> 700;
            case 3 -> 800;
            case 4 -> 850;
            case 5 -> 100;
        };
    }
}

