/*
 * Decompiled with CFR 0.152.
 */
package com.wontlost.ckeditor.internal;

import com.wontlost.ckeditor.handler.HtmlSanitizer;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;

public class ContentManager {
    private final HtmlSanitizer htmlSanitizer;

    public ContentManager(HtmlSanitizer htmlSanitizer) {
        this.htmlSanitizer = htmlSanitizer;
    }

    public String getSanitizedValue(String html) {
        if (html == null || html.isEmpty()) {
            return html;
        }
        if (this.htmlSanitizer != null) {
            return this.htmlSanitizer.sanitize(html);
        }
        return html;
    }

    public String getPlainText(String html) {
        if (html == null || html.isEmpty()) {
            return "";
        }
        return Jsoup.parse((String)html).text();
    }

    public String getSanitizedHtml(String html) {
        if (html == null || html.isEmpty()) {
            return "";
        }
        return Jsoup.clean((String)html, (Safelist)Safelist.relaxed());
    }

    public String sanitizeHtml(String html, Safelist safelist) {
        if (html == null || html.isEmpty()) {
            return "";
        }
        return Jsoup.clean((String)html, (Safelist)safelist);
    }

    public String normalizeForComparison(String html) {
        if (html == null) {
            return "";
        }
        return html.trim().replaceAll("\\s+", " ").replaceAll(">\\s+<", "><");
    }

    public boolean isContentEmpty(String html) {
        if (html == null || html.isEmpty()) {
            return true;
        }
        String text = this.getPlainText(html);
        return text.trim().isEmpty();
    }

    public int getCharacterCount(String html) {
        String text = this.getPlainText(html);
        return text.length();
    }

    public int getWordCount(String html) {
        String text = this.getPlainText(html);
        if (text.trim().isEmpty()) {
            return 0;
        }
        String[] words = text.trim().split("\\s+");
        int count = 0;
        for (String word : words) {
            if (word.isEmpty()) continue;
            int chineseChars = 0;
            for (char c : word.toCharArray()) {
                if (Character.UnicodeScript.of(c) != Character.UnicodeScript.HAN) continue;
                ++chineseChars;
            }
            count += chineseChars > 0 ? chineseChars : 1;
        }
        return count;
    }
}

